/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.gadgets;

import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.rest.DocumentObject;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="GadgetDocument")
public class GadgetDocument
extends DocumentObject {
    private static final String DTEFORMAT = "ddMMMyyyyHH:mm:ss z";
    private static final String GADGET_HTML_CONTENT = "gadget:htmlContent";
    private static final int DEFAULT_SIZE_WIDTH = 600;
    private ConversionService conversionService = null;
    private static final Log log = LogFactory.getLog(GadgetDocument.class);
    private ImagingService imagingService;

    @GET
    public Object doGet() {
        return Response.serverError();
    }

    @POST
    @Path(value="deletePicture")
    public Response doDelete() {
        try {
            this.doc.setPropertyValue("file:content", null);
            CoreSession session = this.getContext().getCoreSession();
            session.saveDocument(this.doc);
            session.save();
        }
        catch (ClientException e) {
            throw WebException.wrap((Throwable)e);
        }
        return Response.ok((Object)"File upload ok", (String)"text/plain").build();
    }

    @POST
    public Response doPost() {
        FormData form = this.ctx.getForm();
        form.fillDocument(this.doc);
        if (form.isMultipartContent()) {
            String xpath = "file:content";
            Blob blob = form.getFirstBlob();
            if (blob == null) {
                throw new IllegalArgumentException("Could not find any uploaded file");
            }
            if (!"".equals(blob.getFilename())) {
                try {
                    String resize = form.getString("resize_width");
                    if (resize != null) {
                        int resizeWidth = 600;
                        try {
                            resizeWidth = Integer.parseInt(resize);
                        }
                        catch (NumberFormatException e) {
                            log.info((Object)"No width for resize picture, use default size");
                        }
                        blob = this.getResizedBlobl(blob, resizeWidth);
                    }
                    Property p = this.doc.getProperty(xpath);
                    p.getParent().get("filename").setValue((Object)blob.getFilename());
                    p.setValue((Object)blob);
                }
                catch (Exception e) {
                    throw WebException.wrap((String)"Failed to attach file", (Throwable)e);
                }
            }
        }
        try {
            CoreSession session = this.getContext().getCoreSession();
            session.saveDocument(this.doc);
            session.save();
        }
        catch (ClientException e) {
            throw WebException.wrap((Throwable)e);
        }
        return Response.ok((Object)"File upload ok!", (String)"text/plain").build();
    }

    protected Blob getResizedBlobl(Blob blob, int newWidth) throws ClientException, IOException {
        String fileName = blob.getFilename();
        blob.persist();
        SimpleBlobHolder bh = new SimpleBlobHolder(blob);
        HashMap<String, Object> options = new HashMap<String, Object>();
        try {
            ImageInfo imageInfo = this.getImagingService().getImageInfo(bh.getBlob());
            int width = imageInfo.getWidth();
            int height = imageInfo.getHeight();
            int depth = imageInfo.getDepth();
            double ratio = 1.0 * (double)newWidth / (double)width;
            int newHeight = (int)Math.round((double)height * ratio);
            options.put("height", newHeight);
            options.put("depth", depth);
        }
        catch (Exception e) {
            // empty catch block
        }
        options.put("width", newWidth);
        options.put("conversionFormat", "jpg");
        bh = this.getConversionService().convert("pictureResize", (BlobHolder)bh, options);
        blob = bh.getBlob() != null ? bh.getBlob() : blob;
        String viewFilename = this.computeViewFilename(fileName, "jpg");
        blob.setFilename(viewFilename);
        return blob;
    }

    protected ConversionService getConversionService() throws ClientException {
        if (this.conversionService == null) {
            try {
                this.conversionService = (ConversionService)Framework.getService(ConversionService.class);
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
        }
        return this.conversionService;
    }

    protected ImagingService getImagingService() {
        if (this.imagingService == null) {
            try {
                this.imagingService = (ImagingService)Framework.getService(ImagingService.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.imagingService;
    }

    @GET
    @Path(value="hasFile")
    public Response hasFile() {
        try {
            this.getBlobFromDoc(this.doc);
        }
        catch (Exception e) {
            return Response.ok((Object)"false").build();
        }
        return Response.ok((Object)"true").build();
    }

    @GET
    @Path(value="file")
    public Object getFile(@Context Request request) {
        try {
            Calendar modified = (Calendar)this.doc.getPropertyValue("dc:modified");
            EntityTag tag = GadgetDocument.getEntityTagForDocument(this.doc);
            Response.ResponseBuilder rb = request.evaluatePreconditions(modified.getTime(), tag);
            if (rb != null) {
                throw new WebApplicationException(rb.build());
            }
            Blob blob = this.getBlobFromDoc(this.doc);
            String filename = blob.getFilename();
            String contentDisposition = "attachment;filename=" + filename;
            if (filename.endsWith(".swf")) {
                contentDisposition = "inline;";
            }
            return Response.ok((Object)blob).header("Content-Disposition", (Object)contentDisposition).type(blob.getMimeType()).lastModified(modified.getTime()).expires(modified.getTime()).tag(tag).build();
        }
        catch (Exception e) {
            throw WebException.wrap((String)"Failed to get the attached file", (Throwable)e);
        }
    }

    static EntityTag getEntityTagForDocument(DocumentModel doc) {
        Calendar modified;
        try {
            modified = (Calendar)doc.getPropertyValue("dc:modified");
        }
        catch (ClientException e) {
            modified = Calendar.getInstance();
        }
        return new EntityTag(GadgetDocument.computeDigest(doc.getId() + new SimpleDateFormat(DTEFORMAT).format(modified.getTime())));
    }

    private static String computeDigest(String content) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] digest = md.digest(content.getBytes());
            BigInteger bi = new BigInteger(digest);
            return bi.toString(16);
        }
        catch (Exception e) {
            return "";
        }
    }

    private Blob getBlobFromDoc(DocumentModel doc) throws ClientException {
        String xpath = "file:content";
        Property p = doc.getProperty(xpath);
        Blob blob = (Blob)p.getValue();
        if (blob == null) {
            throw new WebResourceNotFoundException("No attached file at " + xpath);
        }
        String fileName = blob.getFilename();
        if (fileName == null) {
            if ((p = p.getParent()).isComplex()) {
                try {
                    fileName = (String)((Object)p.getValue("filename"));
                }
                catch (PropertyException e) {
                    fileName = "Unknown";
                }
            }
            blob.setFilename(fileName);
        }
        return blob;
    }

    @GET
    @Path(value="html")
    public Object doGetHtml(@Context Request request) throws PropertyException, ClientException {
        EntityTag tag = GadgetDocument.getEntityTagForDocument(this.doc);
        Response.ResponseBuilder rb = request.evaluatePreconditions(tag);
        if (rb != null) {
            throw new WebApplicationException(rb.build());
        }
        String htmlContent = (String)((Object)this.doc.getPropertyValue(GADGET_HTML_CONTENT));
        return Response.ok((Object)htmlContent, (String)"text/html").build();
    }

    protected String computeViewFilename(String filename, String format) {
        int index = filename.lastIndexOf(".");
        if (index == -1) {
            return filename + "." + format;
        }
        return filename.substring(0, index + 1) + format;
    }
}

