/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Accessibility;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.UIObject;

public class MenuItem
extends UIObject
implements HasHTML {
    private static final String DEPENDENT_STYLENAME_SELECTED_ITEM = "selected";
    private Command command;
    private MenuBar parentMenu;
    private MenuBar subMenu;

    public MenuItem(String text, Command cmd) {
        this(text, false);
        this.setCommand(cmd);
    }

    public MenuItem(String text, boolean asHTML, Command cmd) {
        this(text, asHTML);
        this.setCommand(cmd);
    }

    public MenuItem(String text, MenuBar subMenu) {
        this(text, false);
        this.setSubMenu(subMenu);
    }

    public MenuItem(String text, boolean asHTML, MenuBar subMenu) {
        this(text, asHTML);
        this.setSubMenu(subMenu);
    }

    MenuItem(String text, boolean asHTML) {
        this.setElement(DOM.createTD());
        this.setSelectionStyle(false);
        if (asHTML) {
            this.setHTML(text);
        } else {
            this.setText(text);
        }
        this.setStyleName("gwt-MenuItem");
        DOM.setElementAttribute(this.getElement(), "id", DOM.createUniqueId());
        Accessibility.setRole(this.getElement(), "menuitem");
    }

    public Command getCommand() {
        return this.command;
    }

    public String getHTML() {
        return DOM.getInnerHTML(this.getElement());
    }

    public MenuBar getParentMenu() {
        return this.parentMenu;
    }

    public MenuBar getSubMenu() {
        return this.subMenu;
    }

    public String getText() {
        return DOM.getInnerText(this.getElement());
    }

    public void setCommand(Command cmd) {
        this.command = cmd;
    }

    public void setHTML(String html) {
        DOM.setInnerHTML(this.getElement(), html);
    }

    public void setSubMenu(MenuBar subMenu) {
        this.subMenu = subMenu;
        if (this.parentMenu != null) {
            this.parentMenu.updateSubmenuIcon(this);
        }
        FocusPanel.impl.setTabIndex(subMenu.getElement(), -1);
        Accessibility.setState(this.getElement(), "aria-haspopup", "true");
    }

    public void setText(String text) {
        DOM.setInnerText(this.getElement(), text);
    }

    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        if (this.subMenu != null) {
            this.subMenu.setMenuItemDebugIds(baseID);
        }
    }

    void setParentMenu(MenuBar parentMenu) {
        this.parentMenu = parentMenu;
    }

    void setSelectionStyle(boolean selected) {
        if (selected) {
            this.addStyleDependentName(DEPENDENT_STYLENAME_SELECTED_ITEM);
        } else {
            this.removeStyleDependentName(DEPENDENT_STYLENAME_SELECTED_ITEM);
        }
    }
}

