/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.dashboard;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.security.PermitAll;
import javax.ejb.Remove;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.contexts.Context;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PagedDocumentsProvider;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.impl.EmptyResultsProvider;
import org.nuxeo.ecm.platform.jbpm.dashboard.DashBoardItem;
import org.nuxeo.ecm.platform.jbpm.dashboard.DocumentProcessItem;
import org.nuxeo.ecm.platform.jbpm.dashboard.WorkflowDashBoard;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.pagination.ResultsProviderFarmUserException;
import org.nuxeo.ecm.webapp.dashboard.DashboardActions;
import org.nuxeo.ecm.webapp.dashboard.DashboardNavigationHelper;
import org.nuxeo.ecm.webapp.pagination.ResultsProvidersCache;
import org.nuxeo.ecm.webapp.querymodel.QueryModelActions;

@Name(value="dashboardActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class DashBoardActionsBean
implements DashboardActions {
    private static final long serialVersionUID = 7737098220471277412L;
    private static final Log log = LogFactory.getLog(DashBoardActionsBean.class);
    protected static final String REVIEW_TAB_ID = "TAB_CONTENT_REVIEW";
    protected static final String BOARD_LATEST_MODIFIED = "DOMAIN_DOCUMENTS";
    protected static final String BOARD_LATEST_PUBLISHED = "DOMAIN_PUBLISHED_DOCUMENTS";
    protected static final String BOARD_USER = "USER_DOCUMENTS";
    protected static final String BOARD_WORKSPACES = "USER_WORKSPACES";
    protected static final String BOARD_SITES = "USER_SITES";
    protected static final String BOARD_SECTIONS = "USER_SECTIONS";
    @In
    protected transient Context eventContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient QueryModelActions queryModelActions;
    @In(required=false)
    protected transient Principal currentUser;
    @In(create=true)
    protected DashboardNavigationHelper dashboardNavigationHelper;
    protected transient DocumentModel selectedDomain;
    protected transient List<DocumentModel> availableDomains;
    @In(create=true)
    protected transient WebActions webActions;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient ResultsProvidersCache resultsProvidersCache;
    @In(create=true, required=false)
    protected WorkflowDashBoard workflowDashBoardActions;
    @RequestParameter(value="sortColumn")
    protected String newSortColumn;
    protected SortInfo sortInfo;

    @Override
    @Factory(value="currentUserTasks", scope=ScopeType.EVENT)
    public Collection<DashBoardItem> computeDashboardItems() throws ClientException {
        if (this.workflowDashBoardActions == null) {
            return new ArrayList<DashBoardItem>();
        }
        return this.workflowDashBoardActions.computeDashboardItems();
    }

    @Override
    @Factory(value="currentUserProcesses", scope=ScopeType.EVENT)
    public Collection<DocumentProcessItem> computeDocumentProcessItems() throws ClientException {
        if (this.workflowDashBoardActions == null) {
            return new ArrayList<DocumentProcessItem>();
        }
        return this.workflowDashBoardActions.computeDocumentProcessItems();
    }

    @Override
    public void invalidateDocumentProcessItems() {
        if (this.workflowDashBoardActions == null) {
            return;
        }
        this.workflowDashBoardActions.invalidateDocumentProcessItems();
    }

    @Override
    public void invalidateDashboardItems() {
        if (this.workflowDashBoardActions == null) {
            return;
        }
        this.workflowDashBoardActions.invalidateDashboardItems();
    }

    @Override
    @Destroy
    @Remove
    @PermitAll
    public void destroy() {
    }

    @Override
    public String viewDashboard() {
        return this.dashboardNavigationHelper.navigateToDashboard();
    }

    @Override
    @Observer(value={"domainSelectionChanged"}, create=false)
    public void invalidateDomainBoundInfo() throws ClientException {
        this.selectedDomain = null;
        this.invalidateDomainResultProviders();
    }

    @Override
    public void invalidateDomainResultProviders() throws ClientException {
        String[] domainProviders;
        for (String providerName : domainProviders = new String[]{BOARD_USER, BOARD_LATEST_MODIFIED, BOARD_LATEST_PUBLISHED, BOARD_WORKSPACES, BOARD_SITES, BOARD_SECTIONS}) {
            this.resultsProvidersCache.invalidate(providerName);
        }
    }

    public PagedDocumentsProvider getResultsProvider(String name, SortInfo sortInfo) throws ClientException, ResultsProviderFarmUserException {
        PagedDocumentsProvider provider;
        Object[] params;
        DocumentModel domain = this.getSelectedDomain();
        if (domain == null) {
            return new EmptyResultsProvider();
        }
        String location = domain.getPathAsString();
        String templates = location + "/templates";
        if (BOARD_USER.equals(name)) {
            params = new Object[]{this.currentUser.getName(), location};
        } else if (BOARD_LATEST_MODIFIED.equals(name)) {
            params = new Object[]{location, templates};
        } else if (BOARD_LATEST_PUBLISHED.equals(name)) {
            params = new Object[]{location};
        } else if (BOARD_WORKSPACES.equals(name)) {
            params = new Object[]{location, templates};
        } else if (BOARD_SITES.equals(name)) {
            params = new Object[]{location, templates};
        } else if (BOARD_SECTIONS.equals(name)) {
            params = new Object[]{location};
        } else {
            throw new ClientException("Unknown board: " + name);
        }
        try {
            provider = this.getQmDocuments(name, params, sortInfo);
        }
        catch (Exception e) {
            log.error((Object)"sorted query failed");
            log.debug((Object)e);
            log.error((Object)"retrying without sort parameters");
            provider = this.getQmDocuments(name, params, null);
        }
        provider.setName(name);
        return provider;
    }

    public PagedDocumentsProvider getResultsProvider(String name) throws ClientException, ResultsProviderFarmUserException {
        return this.getResultsProvider(name, null);
    }

    protected PagedDocumentsProvider getQmDocuments(String qmName, Object[] params, SortInfo sortInfo) throws ClientException {
        return this.queryModelActions.get(qmName).getResultsProvider(this.documentManager, params, sortInfo);
    }

    @Override
    public String navigateToDocumentTab(DocumentModel dm) throws ClientException {
        String view = this.navigationContext.navigateToDocument(dm);
        this.webActions.resetTabList();
        this.webActions.setCurrentTabAction(REVIEW_TAB_ID);
        return view;
    }

    @Override
    public DocumentModelList getLastModifiedDocuments() throws ClientException {
        return this.resultsProvidersCache.get(BOARD_LATEST_MODIFIED).getCurrentPage();
    }

    @Override
    public DocumentModelList getUserDocuments() {
        return null;
    }

    @Override
    public DocumentModelList getUserWorkspaces() {
        return null;
    }

    @Override
    public String refreshDashboardItems() {
        if (this.workflowDashBoardActions == null) {
            return null;
        }
        return this.workflowDashBoardActions.refreshDashboardItems();
    }

    @Override
    public String refreshDocumentProcessItems() {
        if (this.workflowDashBoardActions == null) {
            return null;
        }
        return this.workflowDashBoardActions.refreshDocumentProcessItems();
    }

    public String refreshProvider(String providerName) {
        this.resultsProvidersCache.invalidate(providerName);
        return null;
    }

    @Override
    public String doSearch() {
        return null;
    }

    @Override
    public SortInfo getSortInfo() {
        return this.sortInfo;
    }

    @Override
    public DocumentModel getSelectedDomain() throws ClientException {
        List<DocumentModel> availableDomains = this.getAvailableDomains();
        if (this.selectedDomain == null) {
            DocumentModel currentDomain = this.navigationContext.getCurrentDomain();
            if (currentDomain != null) {
                this.selectedDomain = currentDomain;
            } else if (availableDomains != null && !availableDomains.isEmpty()) {
                this.selectedDomain = availableDomains.get(0);
            }
        } else if (availableDomains != null && !availableDomains.isEmpty() && !availableDomains.contains(this.selectedDomain)) {
            this.selectedDomain = availableDomains.get(0);
        }
        return this.selectedDomain;
    }

    @Override
    @Factory(value="availableDomains", scope=ScopeType.EVENT)
    public List<DocumentModel> getAvailableDomains() throws ClientException {
        if (this.documentManager == null) {
            return new ArrayList<DocumentModel>();
        }
        if (this.availableDomains == null) {
            DocumentModel rootDocument = this.documentManager.getRootDocument();
            String query = String.format("SELECT * from Document WHERE ecm:parentId = '%s' AND ecm:currentLifeCycleState != '%s' AND ecm:mixinType != '%s' AND ecm:isProxy = 0", rootDocument.getId(), "deleted", "HiddenInNavigation");
            this.availableDomains = this.documentManager.query(query);
        }
        return this.availableDomains;
    }

    @Override
    @Observer(value={"documentChanged", "documentSecurityChanged", "documentChildrenChanged"}, create=false)
    public void invalidateAvailableDomains() throws ClientException {
        this.availableDomains = null;
    }

    @Override
    public String getSelectedDomainId() throws ClientException {
        DocumentModel selectedDomain = this.getSelectedDomain();
        if (selectedDomain != null) {
            return selectedDomain.getId();
        }
        return null;
    }

    @Override
    public void setSelectedDomainId(String selectedDomainId) throws ClientException {
        this.selectedDomain = this.documentManager.getDocument((DocumentRef)new IdRef(selectedDomainId));
    }

    @Override
    public String submitSelectedDomainChange() throws ClientException {
        this.invalidateDomainResultProviders();
        return null;
    }
}

