/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.filemanager;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.nuxeo.common.utils.Base64;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.ui.web.api.UserAction;
import org.nuxeo.ecm.platform.ui.web.util.files.FileUtils;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.ExceptionHelper;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.clipboard.ClipboardActions;
import org.nuxeo.ecm.webapp.filemanager.FileManageActions;
import org.nuxeo.ecm.webapp.filemanager.UploadItemHolder;
import org.nuxeo.ecm.webapp.filemanager.UploadItemHolderCycleManager;
import org.nuxeo.ecm.webapp.helpers.EventManager;
import org.nuxeo.runtime.api.Framework;
import org.richfaces.event.UploadEvent;
import org.richfaces.model.UploadItem;

@Name(value="FileManageActions")
@Scope(value=ScopeType.EVENT)
@Install(precedence=10)
public class FileManageActionsBean
extends InputController
implements FileManageActions {
    private static final Log log = LogFactory.getLog(FileManageActionsBean.class);
    public static final String TRANSF_ERROR = "TRANSF_ERROR";
    public static final String SECURITY_ERROR = "SECURITY_ERROR";
    public static final String MOVE_ERROR = "MOVE_ERROR";
    public static final String COPY_ERROR = "COPY_ERROR";
    public static final String PASTE_ERROR = "PASTE_ERROR";
    public static final String MOVE_IMPOSSIBLE = "MOVE_IMPOSSIBLE";
    public static final String MOVE_PUBLISH = "MOVE_PUBLISH";
    public static final String MOVE_OK = "MOVE_OK";
    @In(create=true, required=false)
    protected CoreSession documentManager;
    @In(create=true)
    protected TypeManager typeManager;
    @In(create=true)
    protected ClipboardActions clipboardActions;
    @In(create=true, required=false)
    protected UploadItemHolder fileUploadHolder;
    @In(create=true, required=false)
    protected UploadItemHolderCycleManager fileUploadHolderCycle;
    protected FileManager fileManager;

    protected FileManager getFileManagerService() throws ClientException {
        if (this.fileManager == null) {
            try {
                this.fileManager = (FileManager)Framework.getService(FileManager.class);
            }
            catch (Exception e) {
                log.error((Object)"Unable to get FileManager service ", (Throwable)e);
                throw new ClientException("Unable to get FileManager service ", (Throwable)e);
            }
        }
        return this.fileManager;
    }

    public void destroy() {
        log.debug((Object)"Removing Seam action listener...");
    }

    @Override
    public String display() {
        return "view_documents";
    }

    @Override
    public String addFile() throws ClientException {
        return this.addFile(this.getFileUpload(), this.getFileName());
    }

    public String addFile(InputStream fileUpload, String fileName) throws ClientException {
        try {
            if (fileUpload == null || fileName == null) {
                this.facesMessages.add(FacesMessage.SEVERITY_ERROR, (String)this.resourcesAccessor.getMessages().get("fileImporter.error.nullUploadedFile"), new Object[0]);
                return this.navigationContext.getActionResult(this.navigationContext.getCurrentDocument(), UserAction.AFTER_CREATE);
            }
            fileName = FileUtils.getCleanFileName((String)fileName);
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            String path = currentDocument.getPathAsString();
            Blob blob = FileUtils.createSerializableBlob((InputStream)fileUpload, (String)fileName, null);
            DocumentModel createdDoc = this.getFileManagerService().createDocumentFromBlob(this.documentManager, blob, path, true, fileName);
            EventManager.raiseEventsOnDocumentSelected((DocumentModel)createdDoc);
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{currentDocument});
            this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("document_saved"), new Object[]{this.resourcesAccessor.getMessages().get(createdDoc.getType())});
            return this.navigationContext.getActionResult(createdDoc, UserAction.AFTER_CREATE);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    @Override
    @Deprecated
    @WebRemote
    public boolean canWrite() throws ClientException {
        return true;
    }

    protected String getErrorMessage(String errorType, String errorInfo) {
        return this.getErrorMessage(errorType, errorInfo, "message.operation.fails.generic");
    }

    protected String getErrorMessage(String errorType, String errorInfo, String errorLabel) {
        return String.format("%s |(%s)| %s", errorType, errorInfo, this.resourcesAccessor.getMessages().get(errorLabel));
    }

    @Override
    @Deprecated
    @WebRemote
    public String addFileFromPlugin(String content, String mimetype, String fullName, String morePath, Boolean UseBase64) throws ClientException {
        try {
            byte[] bcontent = UseBase64 != false ? Base64.decode((String)content) : content.getBytes();
            return this.addBinaryFileFromPlugin(bcontent, mimetype, fullName, morePath);
        }
        catch (Throwable t) {
            log.error((Object)t, t);
            return this.getErrorMessage(TRANSF_ERROR, fullName);
        }
    }

    @WebRemote
    public String addBinaryFileFromPlugin(Blob blob, String fullName, String morePath) throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        String curPath = currentDocument.getPathAsString();
        String path = curPath + morePath;
        return this.createDocumentFromBlob(blob, fullName, path);
    }

    @WebRemote
    public String addBinaryFileFromPlugin(Blob blob, String fullName, DocumentModel targetContainer) throws ClientException {
        return this.createDocumentFromBlob(blob, fullName, targetContainer.getPathAsString());
    }

    protected String createDocumentFromBlob(Blob blob, String fullName, String path) throws ClientException {
        DocumentModel createdDoc;
        try {
            createdDoc = this.getFileManagerService().createDocumentFromBlob(this.documentManager, blob, path, true, fullName);
        }
        catch (Throwable t) {
            Throwable unwrappedError = ExceptionHelper.unwrapException((Throwable)t);
            if (ExceptionHelper.isSecurityError((Throwable)unwrappedError)) {
                log.debug((Object)("No permissions creating " + fullName));
                return this.getErrorMessage(SECURITY_ERROR, fullName, "Error.Insuffisant.Rights");
            }
            log.error((Object)("Error importing " + fullName), t);
            return this.getErrorMessage(TRANSF_ERROR, fullName);
        }
        if (createdDoc == null) {
            log.error((Object)("could not create the document " + fullName));
            return this.getErrorMessage(TRANSF_ERROR, fullName);
        }
        if (this.navigationContext.getCurrentDocument().getRef().equals(createdDoc.getRef())) {
            this.navigationContext.updateDocumentContext(createdDoc);
        }
        Events.instance().raiseEvent("documentChildrenChanged", new Object[]{this.currentDocument});
        EventManager.raiseEventsOnDocumentSelected((DocumentModel)createdDoc);
        return createdDoc.getName();
    }

    @Deprecated
    public String addBinaryFileFromPlugin(byte[] content, String mimetype, String fullName, String morePath) throws ClientException {
        StreamingBlob blob = StreamingBlob.createFromByteArray((byte[])content, null);
        return this.addBinaryFileFromPlugin((Blob)blob, fullName, morePath);
    }

    @Override
    @WebRemote
    public String addFolderFromPlugin(String fullName, String morePath) throws ClientException {
        try {
            DocumentModel createdDoc;
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            String curPath = currentDocument.getPathAsString();
            if (!currentDocument.isFolder()) {
                curPath = curPath.substring(0, curPath.lastIndexOf(47));
            }
            String path = curPath + morePath;
            try {
                createdDoc = this.getFileManagerService().createFolder(this.documentManager, fullName, path);
            }
            catch (Throwable t) {
                Throwable unwrappedError = ExceptionHelper.unwrapException((Throwable)t);
                if (ExceptionHelper.isSecurityError((Throwable)unwrappedError)) {
                    log.debug((Object)("No permissions creating folder " + fullName));
                    return this.getErrorMessage(SECURITY_ERROR, fullName, "Error.Insuffisant.Rights");
                }
                log.error((Object)("Couldn't create the folder " + fullName));
                return this.getErrorMessage(TRANSF_ERROR, fullName);
            }
            if (createdDoc == null) {
                log.error((Object)("Couldn't create the folder " + fullName));
                return this.getErrorMessage(TRANSF_ERROR, fullName);
            }
            EventManager.raiseEventsOnDocumentSelected((DocumentModel)createdDoc);
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{currentDocument});
            return createdDoc.getName();
        }
        catch (Throwable t) {
            log.error((Object)t, t);
            return this.getErrorMessage(TRANSF_ERROR, fullName);
        }
    }

    @WebRemote
    protected String checkMoveAllowed(DocumentRef docRef, DocumentRef containerRef) throws ClientException {
        DocumentModel doc = this.documentManager.getDocument(docRef);
        DocumentModel container = this.documentManager.getDocument(containerRef);
        if ((container.getPathAsString() + "/").startsWith(doc.getPathAsString() + "/")) {
            this.facesMessages.add(FacesMessage.SEVERITY_WARN, (String)this.resourcesAccessor.getMessages().get("move_impossible"), new Object[0]);
            return MOVE_IMPOSSIBLE;
        }
        if (!doc.isProxy() && container.getType().equals("Section") && !doc.getType().equals("Section")) {
            if (!this.documentManager.hasPermission(containerRef, "AddChildren")) {
                this.facesMessages.add(FacesMessage.SEVERITY_WARN, (String)this.resourcesAccessor.getMessages().get("move_insuffisant_rights"), new Object[0]);
                return MOVE_IMPOSSIBLE;
            }
            if (doc.hasFacet("Publishable")) {
                return MOVE_PUBLISH;
            }
            this.facesMessages.add(FacesMessage.SEVERITY_WARN, (String)this.resourcesAccessor.getMessages().get("publish_impossible"), new Object[0]);
            return MOVE_IMPOSSIBLE;
        }
        if (!this.documentManager.hasPermission(doc.getParentRef(), "RemoveChildren") || !this.documentManager.hasPermission(doc.getRef(), "Remove")) {
            this.facesMessages.add(FacesMessage.SEVERITY_WARN, (String)this.resourcesAccessor.getMessages().get("move_impossible"), new Object[0]);
            return MOVE_IMPOSSIBLE;
        }
        if (!this.documentManager.hasPermission(containerRef, "AddChildren")) {
            this.facesMessages.add(FacesMessage.SEVERITY_WARN, (String)this.resourcesAccessor.getMessages().get("move_insuffisant_rights"), new Object[0]);
            return MOVE_IMPOSSIBLE;
        }
        if (doc.isProxy()) {
            if (!container.getType().equals("Section")) {
                this.facesMessages.add(FacesMessage.SEVERITY_WARN, (String)this.resourcesAccessor.getMessages().get("move_impossible"), new Object[0]);
                return MOVE_IMPOSSIBLE;
            }
        } else {
            Map allowedTypesMap = this.typeManager.getType(container.getType()).getAllowedSubTypes();
            ArrayList allowedTypes = new ArrayList(allowedTypesMap.keySet());
            if (!allowedTypes.contains(doc.getType())) {
                this.facesMessages.add(FacesMessage.SEVERITY_WARN, (String)this.resourcesAccessor.getMessages().get("move_impossible"), new Object[0]);
                return MOVE_IMPOSSIBLE;
            }
        }
        return MOVE_OK;
    }

    @Override
    @WebRemote
    public String moveWithId(String docId, String containerId) throws ClientException {
        try {
            IdRef dstRef;
            String moveStatus;
            String debug = "move " + docId + " into " + containerId;
            log.debug((Object)debug);
            if (docId.startsWith("docRef:")) {
                docId = docId.split("docRef:")[1];
            }
            if (docId.startsWith("docClipboardRef:")) {
                docId = docId.split("docClipboardRef:")[1];
            }
            IdRef srcRef = new IdRef(docId);
            String dst = containerId;
            if (dst.startsWith("docRef:")) {
                dst = dst.split("docRef:")[1];
            }
            if (dst.startsWith("nodeRef:")) {
                dst = dst.split("nodeRef:")[1];
            }
            if ((moveStatus = this.checkMoveAllowed((DocumentRef)srcRef, (DocumentRef)(dstRef = new IdRef(dst)))).equals(MOVE_IMPOSSIBLE)) {
                return debug;
            }
            String action = "document_moved";
            if (moveStatus.equals(MOVE_PUBLISH)) {
                DocumentModel srcDoc = this.documentManager.getDocument((DocumentRef)srcRef);
                DocumentModel dstDoc = this.documentManager.getDocument((DocumentRef)dstRef);
                this.documentManager.publishDocument(srcDoc, dstDoc);
                action = "document_published";
            } else {
                this.documentManager.move((DocumentRef)srcRef, (DocumentRef)dstRef, null);
            }
            this.documentManager.save();
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            EventManager.raiseEventsOnDocumentChildrenChange((DocumentModel)currentDocument);
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{currentDocument});
            DocumentModel otherContainer = this.documentManager.getDocument((DocumentRef)dstRef);
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{otherContainer});
            this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get(action), new Object[]{this.resourcesAccessor.getMessages().get(this.documentManager.getDocument((DocumentRef)srcRef).getType())});
            return debug;
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage(), t);
            return this.getErrorMessage(MOVE_ERROR, docId);
        }
    }

    @Override
    @WebRemote
    public String copyWithId(String docId) throws ClientException {
        try {
            String debug = "copying " + docId;
            log.debug((Object)debug);
            if (docId.startsWith("docRef:")) {
                docId = docId.split("docRef:")[1];
            }
            if (docId.startsWith("docClipboardRef:")) {
                docId = docId.split("docClipboardRef:")[1];
            }
            IdRef srcRef = new IdRef(docId);
            DocumentModel srcDoc = this.documentManager.getDocument((DocumentRef)srcRef);
            ArrayList<DocumentModel> docsToAdd = new ArrayList<DocumentModel>();
            docsToAdd.add(srcDoc);
            this.clipboardActions.putSelectionInWorkList(docsToAdd, Boolean.valueOf(true));
            return debug;
        }
        catch (Throwable t) {
            log.error((Object)t, t);
            return this.getErrorMessage(COPY_ERROR, docId);
        }
    }

    @Override
    @WebRemote
    public String pasteWithId(String docId) throws ClientException {
        try {
            String debug = "pasting " + docId;
            log.debug((Object)debug);
            if (docId.startsWith("pasteRef_")) {
                docId = docId.split("pasteRef_")[1];
            }
            if (docId.startsWith("docClipboardRef:")) {
                docId = docId.split("docClipboardRef:")[1];
            }
            IdRef srcRef = new IdRef(docId);
            DocumentModel srcDoc = this.documentManager.getDocument((DocumentRef)srcRef);
            ArrayList<DocumentModel> pasteDocs = new ArrayList<DocumentModel>();
            pasteDocs.add(srcDoc);
            this.clipboardActions.pasteDocumentList(pasteDocs);
            return debug;
        }
        catch (Throwable t) {
            log.error((Object)t, t);
            return this.getErrorMessage(PASTE_ERROR, docId);
        }
    }

    public void initialize() {
        log.info((Object)"Initializing...");
    }

    public void processUpload(UploadEvent uploadEvent) {
        try {
            if (this.fileUploadHolder != null) {
                this.fileUploadHolder.setTempFile(uploadEvent.getUploadItem().getFile());
                this.fileUploadHolder.setFileName(uploadEvent.getUploadItem().getFileName());
            } else {
                log.error((Object)"Unable to reach fileUploadHolder");
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public void validateMultiplesUpload() throws ClientException, FileNotFoundException {
        DocumentModel current = this.navigationContext.getCurrentDocument();
        this.validateMultipleUploadForDocument(current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateMultipleUploadForDocument(DocumentModel current) throws ClientException, FileNotFoundException {
        if (!current.hasSchema("files")) {
            return;
        }
        try {
            Collection files = (Collection)current.getProperty("files", "files");
            for (UploadItem uploadItem : this.getUploadedFiles()) {
                String filename = FileUtils.getCleanFileName((String)uploadItem.getFileName());
                Blob blob = FileUtils.createSerializableBlob((InputStream)new FileInputStream(uploadItem.getFile()), (String)filename, null);
                HashMap<String, Object> fileMap = new HashMap<String, Object>(2);
                fileMap.put("file", blob);
                fileMap.put("filename", filename);
                if (files.contains(fileMap)) continue;
                files.add(fileMap);
            }
            current.setProperty("files", "files", (Object)files);
            this.documentManager.saveDocument(current);
            this.documentManager.save();
        }
        finally {
            for (UploadItem uploadItem : this.getUploadedFiles()) {
                uploadItem.getFile().delete();
            }
        }
        Contexts.getConversationContext().remove("fileUploadHolder");
    }

    public void performAction(ActionEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext eContext = context.getExternalContext();
        String index = (String)eContext.getRequestParameterMap().get("index");
        try {
            DocumentModel current = this.navigationContext.getCurrentDocument();
            if (!current.hasSchema("files")) {
                return;
            }
            Collection files = (Collection)current.getProperty("files", "files");
            Object file = CollectionUtils.get((Object)files, (int)new Integer(index));
            files.remove(file);
            current.setProperty("files", "files", (Object)files);
            this.documentManager.saveDocument(current);
            this.documentManager.save();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String validate() throws ClientException {
        if (this.fileUploadHolder != null && this.fileUploadHolder.getTempFile() != null) {
            String string;
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(this.fileUploadHolder.getTempFile());
                string = this.addFile(stream, this.getFileName());
            }
            catch (Exception e) {
                String string2;
                try {
                    log.error((Object)e, (Throwable)e);
                    this.facesMessages.add(FacesMessage.SEVERITY_ERROR, (String)this.resourcesAccessor.getMessages().get("fileImporter.error.unsupportedFile"), new Object[0]);
                    string2 = null;
                }
                catch (Throwable throwable) {
                    org.nuxeo.common.utils.FileUtils.close(stream);
                    if (this.fileUploadHolder.getTempFile() != null) {
                        this.fileUploadHolder.getTempFile().delete();
                    }
                    throw throwable;
                }
                org.nuxeo.common.utils.FileUtils.close((InputStream)stream);
                if (this.fileUploadHolder.getTempFile() != null) {
                    this.fileUploadHolder.getTempFile().delete();
                }
                return string2;
            }
            org.nuxeo.common.utils.FileUtils.close((InputStream)stream);
            if (this.fileUploadHolder.getTempFile() != null) {
                this.fileUploadHolder.getTempFile().delete();
            }
            return string;
        }
        this.facesMessages.add(FacesMessage.SEVERITY_ERROR, (String)this.resourcesAccessor.getMessages().get("fileImporter.error.nullUploadedFile"), new Object[0]);
        return null;
    }

    @Override
    public InputStream getFileUpload() {
        if (this.fileUploadHolder != null) {
            return this.fileUploadHolder.getFileUpload();
        }
        return null;
    }

    @Override
    public void setFileUpload(InputStream fileUpload) {
        if (this.fileUploadHolder != null) {
            this.fileUploadHolder.setFileUpload(fileUpload);
        }
    }

    @Override
    public String getFileName() {
        if (this.fileUploadHolder != null) {
            return this.fileUploadHolder.getFileName();
        }
        return null;
    }

    @Override
    public void setFileName(String fileName) {
        if (this.fileUploadHolder != null) {
            this.fileUploadHolder.setFileName(fileName);
        }
    }

    public DocumentModel getChangeableDocument() {
        return this.navigationContext.getChangeableDocument();
    }

    public void setChangeableDocument(DocumentModel changeableDocument) {
        this.navigationContext.setChangeableDocument(changeableDocument);
    }

    public Collection<UploadItem> getUploadedFiles() {
        if (this.fileUploadHolder != null) {
            return this.fileUploadHolder.getUploadedFiles();
        }
        return null;
    }

    public void setUploadedFiles(Collection<UploadItem> uploadedFiles) {
        if (this.fileUploadHolder != null) {
            this.fileUploadHolder.setUploadedFiles(uploadedFiles);
        }
    }

    @Override
    @WebRemote
    public String removeSingleUploadedFile() throws ClientException {
        if (this.fileUploadHolder != null) {
            if (this.fileUploadHolder.getTempFile() != null) {
                this.fileUploadHolder.getTempFile().delete();
            }
            this.fileUploadHolder.setFileName(null);
            this.fileUploadHolder.setTempFile(null);
        }
        return "";
    }

    @Override
    @WebRemote
    public String removeAllUploadedFile() throws ClientException {
        if (this.fileUploadHolder != null) {
            for (UploadItem item : this.fileUploadHolder.getUploadedFiles()) {
                item.getFile().delete();
            }
            this.fileUploadHolder.getUploadedFiles().clear();
        }
        return "";
    }

    @Override
    @WebRemote
    public String removeUploadedFile(String fileName) throws ClientException {
        UploadItem fileToDelete = null;
        for (UploadItem file : this.getUploadedFiles()) {
            String uploadedFileName = file.getFileName();
            if (!fileName.equals(uploadedFileName)) continue;
            fileToDelete = file;
            break;
        }
        if (null != fileToDelete) {
            fileToDelete.getFile().delete();
            this.getUploadedFiles().remove(fileToDelete);
        }
        return "";
    }
}

