/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.file;

import com.sun.faces.util.MessageFactory;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileChoice;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileInfo;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileSizeValidator;

public class InputFileMimetypeValidator
implements Validator,
StateHolder {
    public static final String VALIDATOR_ID = "InputFileMimetypeValidator";
    private static final Log log = LogFactory.getLog(InputFileSizeValidator.class);
    private String[] extensions;
    private boolean authorized = true;
    private boolean transientValue = false;
    public static final String MIMETYPE_AUTHORIZED_EXTENSIONS_MESSAGE_ID = "error.inputFile.authorizedExtensions";
    public static final String MIMETYPE_UNAUTHORIZED_EXTENSIONS_MESSAGE_ID = "error.inputFile.unauthorizedExtensions";

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (value != null && this.extensions != null && this.extensions.length > 0 && value instanceof InputFileInfo) {
            InputFileInfo info = (InputFileInfo)value;
            InputFileChoice choice = info.getConvertedChoice();
            if (InputFileChoice.tempKeep != choice && InputFileChoice.upload != choice) {
                return;
            }
            String filename = info.getConvertedFilename();
            if (filename != null) {
                boolean error = this.authorized;
                for (String extension : this.extensions) {
                    if (!filename.endsWith(extension.trim())) continue;
                    error = !this.authorized;
                    break;
                }
                if (error) {
                    String messageId = this.authorized ? MIMETYPE_AUTHORIZED_EXTENSIONS_MESSAGE_ID : MIMETYPE_UNAUTHORIZED_EXTENSIONS_MESSAGE_ID;
                    throw new ValidatorException(MessageFactory.getMessage((FacesContext)context, (String)messageId, (Object[])new Object[]{StringUtils.join((Object[])this.extensions, (String)", ")}));
                }
            }
        }
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public void setExtensions(String[] extensions) {
        this.extensions = extensions;
    }

    public boolean isAuthorized() {
        return this.authorized;
    }

    public void setAuthorized(boolean authorized) {
        this.authorized = authorized;
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean newTransientValue) {
        this.transientValue = newTransientValue;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.extensions, this.authorized};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.extensions = (String[])values[0];
        this.authorized = (Boolean)values[1];
    }
}

