/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.component.html.HtmlInputHidden;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.platform.ui.web.directory.ChainSelectBase;
import org.nuxeo.ecm.platform.ui.web.directory.DirectoryEntry;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;

public class ChainSelectMany
extends ChainSelectBase {
    public static final String ADD_BUTTON = "addButton";
    private static final String REMOVE_BUTTON = "removeButton";
    private static final String EMPTY_VALUE_MARKER = "emptyValueMarker";
    private static final String REMOVE_HIDDEN = "removeHidden";
    private static final String ADD_HIDDEN = "addHidden";

    public ChainSelectMany() {
        FacesContext context = FacesContext.getCurrentInstance();
        HtmlInputHidden emptyValueMarker = new HtmlInputHidden();
        emptyValueMarker.setId(EMPTY_VALUE_MARKER);
        emptyValueMarker.setValue((Object)"true");
        this.getFacets().put(EMPTY_VALUE_MARKER, emptyValueMarker);
        UICommand addButton = (UICommand)context.getApplication().createComponent("org.ajax4jsf.ajax.CommandButton");
        addButton.getAttributes().put("id", ADD_BUTTON);
        addButton.getAttributes().put("value", "add");
        this.getFacets().put(ADD_BUTTON, addButton);
        HtmlInputHidden addHidden = new HtmlInputHidden();
        addHidden.setId(ADD_HIDDEN);
        this.getFacets().put(ADD_HIDDEN, addHidden);
        UICommand removeButton = (UICommand)context.getApplication().createComponent("org.ajax4jsf.ajax.CommandLink");
        UIGraphic image = new UIGraphic();
        image.setValue((Object)"/icons/toggle_minus.png");
        removeButton.getAttributes().put("id", REMOVE_BUTTON);
        removeButton.getChildren().add(image);
        this.getFacets().put(REMOVE_BUTTON, removeButton);
        HtmlInputHidden removeHidden = new HtmlInputHidden();
        removeHidden.setId(REMOVE_HIDDEN);
        this.getFacets().put(REMOVE_HIDDEN, removeHidden);
    }

    public void decode(FacesContext context) {
        if (this.getDisplayValueOnly()) {
            return;
        }
        this.decodeSelection(context);
        this.decodeValue(context);
        this.setValid(true);
    }

    private void decodeValue(FacesContext context) {
        Object[] selection;
        String emptyValueMarkerClientId = this.getFacet(EMPTY_VALUE_MARKER).getClientId(context);
        String removeEntryClientId = this.getFacet(REMOVE_HIDDEN).getClientId(context);
        String addEntryClientId = this.getFacet(ADD_HIDDEN).getClientId(context);
        Map map = context.getExternalContext().getRequestParameterMap();
        String removeEntryId = (String)map.get(removeEntryClientId);
        boolean addButtonClicked = "true".equals(map.get(addEntryClientId));
        String allValues = (String)map.get(emptyValueMarkerClientId);
        String[] oldValue = StringUtils.split((String)allValues, (String)",");
        ArrayList<String> valueList = new ArrayList<String>(Arrays.asList(oldValue));
        if (addButtonClicked && this.validateEntry(context, (String[])(selection = this.getSelection()))) {
            valueList.add(StringUtils.join((Object[])selection, (String)this.getKeySeparator()));
        }
        if (!StringUtils.isEmpty((String)removeEntryId)) {
            valueList.remove(removeEntryId);
        }
        String[] newValue = valueList.toArray(new String[valueList.size()]);
        this.setSubmittedValue(newValue);
    }

    @Override
    public String[] getSelection() {
        String clientId = this.getClientId(FacesContext.getCurrentInstance());
        String[] selection = (String[])this.selectionMap.get(clientId);
        if (selection == null) {
            selection = new String[]{};
            this.selectionMap.put(clientId, selection);
        }
        return selection;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (this.getDisplayValueOnly()) {
            this.encodeReadOnly(context);
        } else {
            this.encodeReadWrite(context);
        }
    }

    public void encodeReadWrite(FacesContext context) throws IOException {
        String styleClass;
        ResponseWriter writer = context.getResponseWriter();
        this.getChildren().clear();
        writer.startElement("div", (UIComponent)this);
        writer.writeAttribute("id", (Object)this.getClientId(context), "id");
        String style = this.getStyle();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if ((styleClass = this.getStyleClass()) != null) {
            writer.writeAttribute("class", (Object)styleClass, "class");
        }
        String[] selectedKeys = this.getSelection();
        for (int level = 0; level < this.getDepth(); ++level) {
            this.encodeListbox(context, level, selectedKeys);
        }
        this.encodeAddButton(context);
        this.encodeValue(context);
        writer.endElement("div");
    }

    public void encodeReadOnly(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String[] values = (String[])this.getSubmittedValue();
        if (values == null) {
            values = (String[])this.getValue();
        }
        if (values != null) {
            writer.startElement("div", (UIComponent)this);
            for (String value : values) {
                String[] keys = StringUtils.split((String)value, (String)this.getKeySeparator());
                List<DirectoryEntry> nodes = this.resolveKeys(keys);
                ArrayList<String> labels = new ArrayList<String>();
                for (DirectoryEntry node : nodes) {
                    String itemValue = node.getId();
                    String itemLabel = node.getLabel();
                    itemLabel = this.computeItemLabel(context, itemValue, itemLabel);
                    labels.add(itemLabel);
                }
                String concatenatedLabel = StringUtils.join(labels.iterator(), (String)this.getKeySeparator());
                writer.startElement("div", (UIComponent)this);
                writer.write(concatenatedLabel);
                writer.endElement("div");
            }
            writer.endElement("div");
        }
    }

    private void encodeAddButton(FacesContext context) throws IOException {
        UICommand addButton = (UICommand)this.getFacet(ADD_BUTTON);
        HtmlInputHidden addHidden = (HtmlInputHidden)this.getFacet(ADD_HIDDEN);
        String addJs = String.format("document.getElementById('%s').value = '%s'", addHidden.getClientId(context), "true");
        addButton.getAttributes().put("onclick", addJs);
        addHidden.setValue((Object)"");
        String reRender = this.getReRender();
        if (reRender == null) {
            reRender = this.getId();
        }
        addButton.getAttributes().put("reRender", reRender);
        ComponentUtils.encodeComponent(context, (UIComponent)addButton);
        ComponentUtils.encodeComponent(context, (UIComponent)addHidden);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context) throws IOException {
    }

    private void encodeValue(FacesContext context) throws IOException {
        String compValue;
        ResponseWriter writer = context.getResponseWriter();
        Object[] values = (String[])this.getSubmittedValue();
        if (values == null) {
            values = (String[])this.getValue();
        }
        compValue = (compValue = StringUtils.join((Object[])values, (String)",")) == null ? "" : compValue;
        HtmlInputHidden emptyValueMarker = (HtmlInputHidden)this.getFacet(EMPTY_VALUE_MARKER);
        emptyValueMarker.setValue((Object)compValue);
        ComponentUtils.encodeComponent(context, (UIComponent)emptyValueMarker);
        if (values != null) {
            HtmlInputHidden removeHidden = (HtmlInputHidden)this.getFacet(REMOVE_HIDDEN);
            removeHidden.setValue((Object)"");
            ComponentUtils.encodeComponent(context, (UIComponent)removeHidden);
            UICommand removeButton = (UICommand)this.getFacet(REMOVE_BUTTON);
            String reRender = this.getReRender();
            if (reRender == null) {
                reRender = this.getId();
            }
            removeButton.getAttributes().put("reRender", reRender);
            writer.startElement("div", (UIComponent)this);
            for (Object value : values) {
                String[] keys = StringUtils.split((String)value, (String)this.getKeySeparator());
                List<DirectoryEntry> nodes = this.resolveKeys(keys);
                ArrayList<String> labels = new ArrayList<String>();
                for (DirectoryEntry node : nodes) {
                    String itemValue = node.getId();
                    String itemLabel = node.getLabel();
                    itemLabel = this.computeItemLabel(context, itemValue, itemLabel);
                    labels.add(itemLabel);
                }
                String concatenatedLabel = StringUtils.join(labels.iterator(), (String)this.getKeySeparator());
                writer.startElement("div", (UIComponent)this);
                String removeJs = String.format("document.getElementById('%s').value = '%s'", removeHidden.getClientId(context), value);
                removeButton.getAttributes().put("onclick", removeJs);
                ComponentUtils.encodeComponent(context, (UIComponent)removeButton);
                writer.write(concatenatedLabel);
                writer.endElement("div");
            }
            writer.endElement("div");
        }
    }

    public int getCurrentDepth() {
        return this.getDepth();
    }

    public String getFamily() {
        return "nxdirectory.ChainSelectMany";
    }

    public String getRendererType() {
        return null;
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context)};
        return values;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
    }
}

