/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.local;

import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.spi.Session;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;

public abstract class AbstractLocalService {
    private Session session;
    private CmisServiceFactory factory;
    private String user;
    private String password;

    protected void setSession(Session session) {
        this.session = session;
        Object userObj = session.get("org.apache.chemistry.opencmis.user");
        this.user = userObj instanceof String ? userObj.toString() : null;
        Object passwordObj = session.get("org.apache.chemistry.opencmis.password");
        this.password = passwordObj instanceof String ? passwordObj.toString() : null;
    }

    protected Session getSession() {
        return this.session;
    }

    protected void setServiceFactory(CmisServiceFactory factory) {
        this.factory = factory;
    }

    protected CmisServiceFactory getServiceFactory() {
        return this.factory;
    }

    protected CallContext createCallContext(String repositoryId) {
        return new LocalCallContext(repositoryId, this.user, this.password);
    }

    protected CmisService getService(String repositoryId) {
        return this.factory.getService(this.createCallContext(repositoryId));
    }

    static class LocalCallContext
    implements CallContext {
        private Map<String, Object> contextMap = new HashMap<String, Object>();

        public LocalCallContext(String repositoryId, String user, String password) {
            this.contextMap.put("repositoryId", repositoryId);
            this.contextMap.put("useranme", user);
            this.contextMap.put("password", password);
        }

        public String getBinding() {
            return "local";
        }

        public Object get(String key) {
            return this.contextMap.get(key);
        }

        public String getRepositoryId() {
            return (String)this.get("repositoryId");
        }

        public String getUsername() {
            return (String)this.get("useranme");
        }

        public String getPassword() {
            return (String)this.get("password");
        }

        public String getLocale() {
            return null;
        }

        public boolean isObjectInfoRequired() {
            return false;
        }
    }
}

