/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.jbpm.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.taskmgmt.exe.PooledActor;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.jbpm.NuxeoJbpmException;
import org.nuxeo.runtime.api.Framework;

@Name(value="jbpmHelper")
@Scope(value=ScopeType.STATELESS)
@Install(precedence=10)
public class JbpmHelper {
    private JbpmService jbpmService;

    public JbpmService getJbpmService() throws Exception {
        if (this.jbpmService == null) {
            this.jbpmService = (JbpmService)Framework.getService(JbpmService.class);
        }
        return this.jbpmService;
    }

    public String createProcessInstance(NuxeoPrincipal principal, String pd, DocumentModel dm, String endLifeCycle) throws Exception {
        HashMap<String, String> map = null;
        if (endLifeCycle != null && !endLifeCycle.equals("") && !"null".equals(endLifeCycle)) {
            map = new HashMap<String, String>();
            map.put(JbpmService.VariableName.endLifecycleTransition.name(), endLifeCycle);
        }
        this.getJbpmService().createProcessInstance(principal, pd, dm, map, null);
        return null;
    }

    public String updateProcessVariable(ProcessInstance pi, String variableName, Object variableValue) throws NuxeoJbpmException, Exception {
        pi.getContextInstance().setVariable(variableName, variableValue);
        this.getJbpmService().persistProcessInstance(pi);
        return null;
    }

    public boolean processHasRunningTask(ProcessInstance pi, String taskName) {
        Collection tis = pi.getTaskMgmtInstance().getTaskInstances();
        for (TaskInstance ti : tis) {
            if (ti.hasEnded() || !ti.getName().equals(taskName)) continue;
            return true;
        }
        return false;
    }

    public boolean isTaskAssignedToUser(TaskInstance task, NuxeoPrincipal user) {
        if (task != null && user != null) {
            ArrayList<String> actors = new ArrayList<String>();
            List groups = user.getAllGroups();
            String actorId = "user:" + user.getName();
            actors.add(actorId);
            for (String s : groups) {
                actors.add("group:" + s);
            }
            if (actors.contains(task.getActorId())) {
                return true;
            }
            Set pooled = task.getPooledActors();
            if (pooled != null) {
                for (PooledActor pa : pooled) {
                    if (!actors.contains(pa.getActorId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public List<String> getPooledActorIds(TaskInstance task) {
        ArrayList<String> res = new ArrayList<String>();
        Set pooledActors = task.getPooledActors();
        for (PooledActor pooledActor : pooledActors) {
            res.add(pooledActor.getActorId());
        }
        return res;
    }
}

