/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.container.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.spaces.api.Gadget;
import org.nuxeo.ecm.spaces.api.Space;
import org.nuxeo.ecm.spaces.api.SpaceManager;
import org.nuxeo.opensocial.container.client.bean.GadgetBean;
import org.nuxeo.opensocial.container.factory.ContainerManagerImpl;
import org.nuxeo.opensocial.container.factory.GadgetFactory;
import org.nuxeo.opensocial.container.factory.api.GadgetManager;
import org.nuxeo.opensocial.container.factory.utils.CoreSessionHelper;
import org.nuxeo.runtime.api.Framework;

public class GadgetManagerImpl
implements GadgetManager {
    private static final Log log = LogFactory.getLog(GadgetManagerImpl.class);
    private static final Object NX_BASE_URL = "nxBaseUrl";

    protected SpaceManager spaceManager() throws Exception {
        return (SpaceManager)Framework.getService(SpaceManager.class);
    }

    public void removeGadget(GadgetBean bean, Map<String, String> gwtParams) throws ClientException {
        try {
            String spaceId = this.getParamValue("docRef", gwtParams, true, null);
            Space space = this.spaceManager().getSpaceFromId(spaceId, this.getCoreSession(gwtParams));
            space.remove(GadgetFactory.getGadget(bean));
            space.save();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new ClientException((Throwable)e);
        }
    }

    protected CoreSession getCoreSession(Map<String, String> gwtParams) throws Exception {
        return CoreSessionHelper.getCoreSession(gwtParams.get("repoName"));
    }

    public GadgetBean saveGadget(GadgetBean bean, Map<String, String> gwtParams) {
        try {
            String spaceId = this.getParamValue("docRef", gwtParams, true, null);
            Space space = this.spaceManager().getSpaceFromId(spaceId, this.getCoreSession(gwtParams));
            space.save(GadgetFactory.getGadget(bean));
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return bean;
    }

    public GadgetBean savePreferences(GadgetBean bean, Map<String, String> updatePrefs, Map<String, String> gwtParams) throws Exception {
        try {
            Space space = this.getCurrentSpace(gwtParams);
            String serverBase = this.getServerBase(gwtParams);
            Gadget gadget = GadgetFactory.getGadget(bean, updatePrefs);
            space.save(gadget);
            return GadgetFactory.getGadgetBean(space.getGadget(gadget.getId()), ContainerManagerImpl.getLocale(gwtParams), serverBase);
        }
        catch (Exception e) {
            log.error((Object)("GadgetManagerImpl - savePreferences : " + e.fillInStackTrace()));
            return bean;
        }
    }

    private String getServerBase(Map<String, String> gwtParams) {
        return gwtParams.get(NX_BASE_URL);
    }

    private Space getCurrentSpace(Map<String, String> gwtParams) throws Exception {
        CoreSession session = this.getCoreSession(gwtParams);
        String spaceId = this.getParamValue("docRef", gwtParams, true, null);
        return this.spaceManager().getSpaceFromId(spaceId, session);
    }

    private String getParamValue(String key, Map<String, String> containerParams, boolean required, String defaultValue) {
        String value = containerParams.get(key);
        String retour = null;
        if (value == null) {
            if (required) {
                throw new RuntimeException("Container param for key '" + key + "' is required");
            }
            retour = defaultValue;
        } else {
            retour = value;
        }
        return retour;
    }

    public Boolean validateGadgets(Collection<GadgetBean> beans, Map<String, String> gwtParams) throws ClientException {
        try {
            String spaceId = this.getParamValue("docRef", gwtParams, true, null);
            Space space = this.spaceManager().getSpaceFromId(spaceId, this.getCoreSession(gwtParams));
            ArrayList<Gadget> gadgets = new ArrayList<Gadget>();
            for (GadgetBean bean : beans) {
                gadgets.add(GadgetFactory.getGadget(bean));
            }
            return space.validateGadgets(gadgets);
        }
        catch (Exception e) {
            log.error((Object)e);
            return true;
        }
    }
}

