/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.session;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.webengine.session.SessionException;
import org.nuxeo.runtime.api.Framework;

public class SessionProvider {
    protected Map<String, CoreSession> sessions = new HashMap<String, CoreSession>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreSession getSession(String repositoryName) throws Exception {
        CoreSession session = this.sessions.get(repositoryName);
        if (session == null) {
            SessionProvider sessionProvider = this;
            synchronized (sessionProvider) {
                session = this.sessions.get(repositoryName);
                if (session == null) {
                    session = this.openSession(repositoryName);
                    this.sessions.put(repositoryName, session);
                }
            }
        }
        return session;
    }

    public CoreSession openSession(String repoName) throws Exception {
        RepositoryManager rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
        Repository repo = null;
        repo = repoName == null ? rm.getDefaultRepository() : rm.getRepository(repoName);
        if (repo == null) {
            throw new SessionException("Unable to get " + repoName + " repository");
        }
        return repo.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy(Principal principal) throws Exception {
        if (this.sessions == null || this.sessions.isEmpty()) {
            this.sessions = null;
            return;
        }
        LoginContext lc = null;
        try {
            lc = Framework.loginAs((String)principal.getName());
            for (CoreSession session : this.sessions.values()) {
                session.destroy();
            }
            this.sessions = null;
        }
        finally {
            if (lc != null) {
                try {
                    lc.logout();
                }
                catch (LoginException loginException) {}
            }
        }
    }
}

