/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.util;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.util.JSonDocumentExporter;

public class JSonHelper {
    private static final Log log = LogFactory.getLog(JSonHelper.class);

    private JSonHelper() {
    }

    public static String toJSon(DocumentModel doc) {
        return JSonHelper.doc2JSon(doc).toString();
    }

    public static String toChildrenList(DocumentModel doc) {
        return JSonHelper.getChildrenList(doc).toString();
    }

    public static JSONArray asJSON(DocumentModelList docList) {
        JSONArray list = new JSONArray();
        if (docList != null) {
            for (DocumentModel d : docList) {
                JSONObject o = new JSONObject();
                o.put((Object)"id", (Object)d.getId());
                o.put((Object)"name", (Object)d.getName());
                o.put((Object)"path", (Object)d.getPathAsString());
                o.put((Object)"type", (Object)d.getType());
                try {
                    o.put((Object)"title", (Object)d.getTitle());
                }
                catch (ClientException e) {
                    o.put((Object)"title", (Object)d.getName());
                }
                o.put((Object)"isFolderish", (Object)d.hasFacet("Folderish"));
                list.add((Object)o);
            }
        }
        return list;
    }

    public static JSONArray getChildrenList(DocumentModel doc) {
        CoreSession session = CoreInstance.getInstance().getSession(doc.getSessionId());
        try {
            DocumentModelList docs = session.getChildren(doc.getRef());
            return JSonHelper.asJSON(docs);
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public static String toJSon(DocumentModel doc, String ... schemas) {
        return JSonHelper.doc2JSon(doc).toString();
    }

    public static JSONObject doc2JSon(DocumentModel doc) {
        return JSonHelper.doc2JSon(doc, null);
    }

    public static JSONObject doc2JSon(DocumentModel doc, String ... schemas) {
        try {
            JSONObject obj = new JSONObject();
            obj.put((Object)"id", (Object)doc.getId());
            obj.put((Object)"name", (Object)doc.getName());
            obj.put((Object)"path", (Object)doc.getPathAsString());
            obj.put((Object)"isLocked", (Object)doc.isLocked());
            obj.put((Object)"lifeCycleState", (Object)doc.getCurrentLifeCycleState());
            obj.put((Object)"lifeCyclePolicy", (Object)doc.getLifeCyclePolicy());
            obj.put((Object)"type", (Object)doc.getType());
            obj.put((Object)"isVersion", (Object)doc.isVersion());
            obj.put((Object)"isProxy", (Object)doc.isProxy());
            obj.put((Object)"sourceId", (Object)doc.getSourceId());
            obj.put((Object)"facets", (Object)doc.getDeclaredFacets());
            obj.put((Object)"schemas", (Object)doc.getDeclaredSchemas());
            JSonDocumentExporter jde = new JSonDocumentExporter();
            if (schemas != null) {
                for (String schema : schemas) {
                    obj.put((Object)schema, (Object)jde.run(doc.getPart(schema)));
                }
            } else {
                for (DocumentPart part : doc.getParts()) {
                    obj.put((Object)part.getName(), (Object)jde.run(part));
                }
            }
            return obj;
        }
        catch (Exception e) {
            throw WebException.wrap("Failed to export document as json: " + doc.getPath(), e);
        }
    }
}

