/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache.tree;

import java.util.Properties;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.TreeCache;
import org.jboss.cache.eviction.LRUPolicy;
import org.jboss.cache.eviction.Region;
import org.jboss.cache.eviction.RegionNameConflictException;
import org.jboss.cache.loader.FileCacheLoader;
import org.jboss.util.xml.XmlHelper;
import org.w3c.dom.Element;

public class PassivationEvictionPolicy
extends LRUPolicy {
    protected FileCacheLoader fileCacheLoader = new FileCacheLoader();

    public void createRegion(String name, int maxSize, long timeToLive) {
        if (this.regionManager_.hasRegion(name)) {
            return;
        }
        try {
            Region region = this.regionManager_.createRegion(name, this.getEvictionAlgorithm());
            region.setTimeToLiveSeconds(timeToLive);
            region.setMaxNodes(maxSize);
        }
        catch (RegionNameConflictException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeRegion(String name) {
        this.regionManager_.removeRegion(name);
    }

    public void superEvict(Fqn fqn) throws Exception {
        super.evict(fqn);
    }

    public void evict(Fqn fqn) throws Exception {
        Node node = this.cache_.get(fqn);
        this.fileCacheLoader.put(fqn, node.getData(), true);
        super.evict(fqn);
    }

    public void configure(TreeCache cache) {
        super.configure(cache);
        Element elem = cache.getEvictionPolicyConfig();
        try {
            String name = XmlHelper.getUniqueChildContent((Element)elem, (String)"name");
            String filename = System.getProperty("jboss.server.temp.dir") + "/" + name;
            Properties p = new Properties();
            p.put("location", filename);
            this.fileCacheLoader.setConfig(p);
            this.fileCacheLoader.create();
            this.fileCacheLoader.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

