/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.dd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.ejb.TransactionManagementType;
import org.jboss.ejb3.dd.ClusterConfig;
import org.jboss.ejb3.dd.Consumer;
import org.jboss.ejb3.dd.EjbLocalRef;
import org.jboss.ejb3.dd.EjbRef;
import org.jboss.ejb3.dd.EntityEnterpriseBean;
import org.jboss.ejb3.dd.EnvEntry;
import org.jboss.ejb3.dd.Injectable;
import org.jboss.ejb3.dd.InjectionTarget;
import org.jboss.ejb3.dd.MessageDestinationRef;
import org.jboss.ejb3.dd.MessageDrivenBean;
import org.jboss.ejb3.dd.MethodAttributes;
import org.jboss.ejb3.dd.PersistenceContextRef;
import org.jboss.ejb3.dd.PersistenceUnitRef;
import org.jboss.ejb3.dd.ResourceEnvRef;
import org.jboss.ejb3.dd.ResourceRef;
import org.jboss.ejb3.dd.SecurityIdentity;
import org.jboss.ejb3.dd.Service;
import org.jboss.ejb3.dd.SessionEnterpriseBean;
import org.jboss.ejb3.dd.WebServiceRef;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnterpriseBean
implements Injectable {
    private static final Logger log = Logger.getLogger(EnterpriseBean.class);
    public static final String BEAN = "Bean";
    public static final String CONTAINER = "Container";
    private String ejbName = null;
    private String home = null;
    private String remote = null;
    private String localHome = null;
    private String local = null;
    private String ejbClass = null;
    private HashMap<String, EjbLocalRef> ejbLocalRefs = new HashMap();
    private HashMap<String, EjbRef> ejbRefs = new HashMap();
    private HashMap<String, EnvEntry> envEntries = new HashMap();
    private HashMap<String, ResourceEnvRef> resourceEnvRefs = new HashMap();
    private HashMap<String, ResourceRef> resourceRefs = new HashMap();
    private HashMap<String, WebServiceRef> webServiceRefs = new HashMap();
    private SecurityIdentity securityIdentity;
    protected TransactionManagementType tmType = null;
    private HashMap<String, MessageDestinationRef> messageDestinationRefs = new HashMap();
    private String jndiName;
    private String localJndiName;
    private String securityDomain;
    private boolean callByValue = false;
    private ClusterConfig clusterConfig = null;
    private String aopDomainName = null;
    private MethodAttributes methodAttributes = null;
    private Collection<String> dependencies = new HashSet<String>();
    private Collection<InjectionTarget> ignoreDependencies = new HashSet<InjectionTarget>();
    private String interceptorStack;
    private String proxyFactory;
    private List<PersistenceContextRef> persistenceContextRefs = new ArrayList<PersistenceContextRef>();
    private List<PersistenceUnitRef> persistenceUnitRefs = new ArrayList<PersistenceUnitRef>();

    public void addDependency(String depends) {
        this.dependencies.add(depends);
    }

    public Collection<String> getDependencies() {
        return this.dependencies;
    }

    public void addIgnoreDependency(InjectionTarget ignore) {
        this.ignoreDependencies.add(ignore);
    }

    public Collection<InjectionTarget> getIgnoreDependencies() {
        return this.ignoreDependencies;
    }

    public void mergeMessageDestinationRef(MessageDestinationRef ref) {
        MessageDestinationRef tmpRef = this.messageDestinationRefs.get(ref.getMessageDestinationRefName());
        if (tmpRef != null) {
            tmpRef.merge(ref);
        }
    }

    public void mergeResourceRef(ResourceRef ref) {
        ResourceRef tmpRef = this.resourceRefs.get(ref.getResRefName());
        if (tmpRef != null) {
            tmpRef.merge(ref);
        }
    }

    public void mergeResourceEnvRef(ResourceEnvRef ref) {
        ResourceEnvRef tmpRef = this.resourceEnvRefs.get(ref.getResRefName());
        if (tmpRef != null) {
            tmpRef.merge(ref);
        }
    }

    public void setMethodAttributes(MethodAttributes methodAttributes) {
        this.methodAttributes = methodAttributes;
    }

    public MethodAttributes getMethodAttributes() {
        return this.methodAttributes;
    }

    public String getInterceptorStack() {
        return this.interceptorStack;
    }

    public void setInterceptorStack(String interceptorStack) {
        this.interceptorStack = interceptorStack;
    }

    public String getProxyFactory() {
        return this.proxyFactory;
    }

    public void setProxyFactory(String proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public void updateEjbRef(EjbRef updatedRef) {
        EjbRef ref = this.ejbRefs.get(updatedRef.getEjbRefName());
        if (ref != null) {
            ref.setMappedName(updatedRef.getMappedName());
            ref.setIgnoreDependency(updatedRef.isIgnoreDependency());
        } else {
            this.ejbRefs.put(updatedRef.getEjbRefName(), updatedRef);
        }
    }

    public void updateEjbLocalRef(EjbLocalRef updatedRef) {
        EjbLocalRef ref = this.ejbLocalRefs.get(updatedRef.getEjbRefName());
        if (ref != null) {
            ref.setMappedName(updatedRef.getMappedName());
            ref.setIgnoreDependency(updatedRef.isIgnoreDependency());
        } else {
            this.ejbLocalRefs.put(updatedRef.getEjbRefName(), updatedRef);
        }
    }

    public void setAopDomainName(String aopDomainName) {
        this.aopDomainName = aopDomainName;
    }

    public String getAopDomainName() {
        return this.aopDomainName;
    }

    public void setClusterConfig(ClusterConfig clusterConfig) {
        this.clusterConfig = clusterConfig;
    }

    public boolean isClustered() {
        return this.clusterConfig != null;
    }

    public ClusterConfig getClusterConfig() {
        return this.clusterConfig;
    }

    public void setRunAsPrincipal(String principal) {
        if (this.securityIdentity != null) {
            this.securityIdentity.setRunAsPrincipal(principal);
        }
    }

    public void setCallByValue(boolean callByValue) {
        this.callByValue = callByValue;
    }

    public boolean isCallByValue() {
        return this.callByValue;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    @Override
    public Collection<MessageDestinationRef> getMessageDestinationRefs() {
        return this.messageDestinationRefs.values();
    }

    public void addMessageDestinationRef(MessageDestinationRef messageDestinationRef) {
        this.messageDestinationRefs.put(messageDestinationRef.getMessageDestinationRefName(), messageDestinationRef);
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getLocalJndiName() {
        return this.localJndiName;
    }

    public void setLocalJndiName(String localJndiName) {
        this.localJndiName = localJndiName;
    }

    public TransactionManagementType getTransactionManagementType() {
        return this.tmType;
    }

    public void setTransactionManagementType(String transactionType) {
        if (transactionType.equals(BEAN)) {
            this.tmType = TransactionManagementType.BEAN;
        } else if (transactionType.equals(CONTAINER)) {
            this.tmType = TransactionManagementType.CONTAINER;
        }
    }

    public boolean isSessionBean() {
        return this instanceof SessionEnterpriseBean;
    }

    public boolean isConsumer() {
        return this instanceof Consumer;
    }

    public boolean isEntityBean() {
        return this instanceof EntityEnterpriseBean;
    }

    public boolean isMessageDrivenBean() {
        return this instanceof MessageDrivenBean;
    }

    public boolean isService() {
        return this instanceof Service;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public void setEjbName(String ejbName) {
        this.ejbName = ejbName;
    }

    public String getHome() {
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public String getRemote() {
        return this.remote;
    }

    public void setRemote(String remote) {
        this.remote = remote;
    }

    public String getLocalHome() {
        return this.localHome;
    }

    public void setLocalHome(String localHome) {
        this.localHome = localHome;
    }

    public String getLocal() {
        return this.local;
    }

    public void setLocal(String local) {
        this.local = local;
    }

    public String getEjbClass() {
        return this.ejbClass;
    }

    public void setEjbClass(String ejbClass) {
        this.ejbClass = ejbClass;
    }

    @Override
    public Collection<EjbLocalRef> getEjbLocalRefs() {
        return this.ejbLocalRefs.values();
    }

    public void addEjbLocalRef(EjbLocalRef ref) {
        this.ejbLocalRefs.put(ref.getEjbRefName(), ref);
    }

    @Override
    public Collection<EjbRef> getEjbRefs() {
        return this.ejbRefs.values();
    }

    public void addEjbRef(EjbRef ref) {
        this.ejbRefs.put(ref.getEjbRefName(), ref);
    }

    public Collection<EnvEntry> getEnvEntries() {
        return this.envEntries.values();
    }

    public void addEnvEntry(EnvEntry entry) {
        this.envEntries.put(entry.getEnvEntryName(), entry);
    }

    @Override
    public Collection<ResourceEnvRef> getResourceEnvRefs() {
        return this.resourceEnvRefs.values();
    }

    public void addResourceEnvRef(ResourceEnvRef envRef) {
        this.resourceEnvRefs.put(envRef.getResRefName(), envRef);
    }

    @Override
    public Collection<ResourceRef> getResourceRefs() {
        return this.resourceRefs.values();
    }

    public void addResourceRef(ResourceRef envRef) {
        this.resourceRefs.put(envRef.getResRefName(), envRef);
    }

    @Override
    public Collection<WebServiceRef> getWebServiceRefs() {
        return this.webServiceRefs.values();
    }

    public void addWebServiceRef(WebServiceRef ref) {
        this.webServiceRefs.put(ref.getServiceRefName(), ref);
    }

    public SecurityIdentity getSecurityIdentity() {
        return this.securityIdentity;
    }

    public void setSecurityIdentity(SecurityIdentity securityIdentity) {
        this.securityIdentity = securityIdentity;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("ejbName=").append(this.ejbName);
        sb.append(",jndiName=").append(this.jndiName);
        sb.append(",local=").append(this.local);
        sb.append(",remote=").append(this.remote);
        sb.append(",home=").append(this.home);
        sb.append(",localHome=").append(this.localHome);
        sb.append(",ejbClass=").append(this.ejbClass);
        sb.append(",ejbRefs=").append(this.ejbRefs);
        sb.append(",ejbLocalRefs=").append(this.ejbLocalRefs);
        sb.append(",resourceRefs=").append(this.resourceRefs);
        sb.append(",resourceEnvRefs=").append(this.resourceEnvRefs);
        sb.append(",methodAttributes=").append(this.methodAttributes);
        sb.append(",aopDomainName=").append(this.aopDomainName);
        sb.append(",dependencies=").append(this.dependencies);
        return sb.toString();
    }

    @Override
    public List<PersistenceContextRef> getPersistenceContextRefs() {
        return this.persistenceContextRefs;
    }

    @Override
    public List<PersistenceUnitRef> getPersistenceUnitRefs() {
        return this.persistenceUnitRefs;
    }

    public void addPersistenceContextRef(PersistenceContextRef ref) {
        this.persistenceContextRefs.add(ref);
    }

    public void addPersistenceUnitRef(PersistenceUnitRef ref) {
        this.persistenceUnitRefs.add(ref);
    }
}

