/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.dd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jboss.ejb3.dd.ClusterConfig;
import org.jboss.ejb3.dd.EjbLocalRef;
import org.jboss.ejb3.dd.EjbRef;
import org.jboss.ejb3.dd.EnterpriseBean;
import org.jboss.ejb3.dd.InjectionTarget;
import org.jboss.ejb3.dd.MessageDestinationRef;
import org.jboss.ejb3.dd.MessageDrivenBean;
import org.jboss.ejb3.dd.MethodAttributes;
import org.jboss.ejb3.dd.ResourceEnvRef;
import org.jboss.ejb3.dd.ResourceRef;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnterpriseBeans {
    private static final Logger log = Logger.getLogger(EnterpriseBeans.class);
    private HashMap<String, EnterpriseBean> enterpriseBeans = new HashMap();
    private EnterpriseBean currentEjb;

    public void addIgnoreDependency(InjectionTarget ignore) {
        this.currentEjb.addIgnoreDependency(ignore);
    }

    public void addResourceRef(ResourceRef ref) {
        this.currentEjb.mergeResourceRef(ref);
    }

    public void addResourceEnvRef(ResourceEnvRef ref) {
        this.currentEjb.mergeResourceEnvRef(ref);
    }

    public void addMessageDestinationRef(MessageDestinationRef ref) {
        this.currentEjb.mergeMessageDestinationRef(ref);
    }

    public void setMethodAttributes(MethodAttributes attributes) {
        this.currentEjb.setMethodAttributes(attributes);
    }

    public void setCurrentEjbName(String currentEjbName, Class ejbClass) {
        this.currentEjb = this.createEjbByEjbName(currentEjbName, ejbClass);
    }

    public void setInterceptorStack(String stackName) {
        this.currentEjb.setInterceptorStack(stackName);
    }

    public void setProxyFactory(String factory) {
        this.currentEjb.setProxyFactory(factory);
    }

    public void addDependency(String depends) {
        this.currentEjb.addDependency(depends);
    }

    public void updateEjbRef(EjbRef ref) {
        this.currentEjb.updateEjbRef(ref);
    }

    public void updateEjbLocalRef(EjbLocalRef ref) {
        this.currentEjb.updateEjbLocalRef(ref);
    }

    public void setResourceAdapterName(String name) {
        ((MessageDrivenBean)this.currentEjb).setResourceAdaptorName(name);
    }

    public void setDestinationJndiName(String name) {
        ((MessageDrivenBean)this.currentEjb).setDestinationJndiName(name);
    }

    public void setMdbUser(String name) {
        ((MessageDrivenBean)this.currentEjb).setMdbUser(name);
    }

    public void setMdbPassword(String name) {
        ((MessageDrivenBean)this.currentEjb).setMdbPassword(name);
    }

    public void setAopDomainName(String aopDomainName) {
        this.currentEjb.setAopDomainName(aopDomainName);
    }

    public void setRunAsPrincipal(String principal) {
        this.currentEjb.setRunAsPrincipal(principal);
    }

    public void setClusterConfig(ClusterConfig config) {
        this.currentEjb.setClusterConfig(config);
    }

    public void setCallByValue(boolean callByValue) {
        this.currentEjb.setCallByValue(callByValue);
    }

    public void setJndiName(String jndiName) {
        this.currentEjb.setJndiName(jndiName);
    }

    public void setSecurityDomain(String securityDomain) {
        this.currentEjb.setSecurityDomain(securityDomain);
    }

    public void setLocalJndiName(String jndiName) {
        this.currentEjb.setLocalJndiName(jndiName);
    }

    public EnterpriseBean createEjbByEjbName(String ejbName, Class ejbClass) {
        EnterpriseBean ejb = this.enterpriseBeans.get(ejbName);
        if (ejb != null) {
            return ejb;
        }
        try {
            ejb = (EnterpriseBean)ejbClass.newInstance();
            ejb.setEjbName(ejbName);
            this.enterpriseBeans.put(ejbName, ejb);
        }
        catch (Exception e) {
            // empty catch block
        }
        return ejb;
    }

    public EnterpriseBean findEjbByEjbName(String ejbName) {
        return this.enterpriseBeans.get(ejbName);
    }

    public List<EnterpriseBean> findEjbsByClass(String className) {
        ArrayList<EnterpriseBean> result = new ArrayList<EnterpriseBean>();
        for (EnterpriseBean ejb : this.enterpriseBeans.values()) {
            String ejbClassName = ejb.getEjbClass();
            if (ejbClassName == null || !ejbClassName.equals(className)) continue;
            result.add(ejb);
        }
        return result;
    }

    public EnterpriseBean findEjbByRemote(String remote) {
        for (EnterpriseBean ejb : this.enterpriseBeans.values()) {
            if (ejb.getRemote() == null || !ejb.getRemote().equals(remote)) continue;
            return ejb;
        }
        return null;
    }

    public EnterpriseBean findEjbByLocal(String local) {
        for (EnterpriseBean ejb : this.enterpriseBeans.values()) {
            if (ejb.getLocal() == null || !ejb.getLocal().equals(local)) continue;
            return ejb;
        }
        return null;
    }

    public Collection<EnterpriseBean> getEnterpriseBeans() {
        return this.enterpriseBeans.values();
    }

    public void addEnterpriseBean(EnterpriseBean ejb) {
        this.enterpriseBeans.put(ejb.getEjbName(), ejb);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("[");
        sb.append("enterpriseBeans=").append(this.enterpriseBeans);
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnterpriseBeans)) {
            return false;
        }
        EnterpriseBeans ejbs = (EnterpriseBeans)o;
        return !(this.enterpriseBeans != null ? !this.enterpriseBeans.equals(ejbs.enterpriseBeans) : ejbs.enterpriseBeans != null);
    }

    public int hashCode() {
        int result = this.enterpriseBeans != null ? this.enterpriseBeans.hashCode() : 0;
        return result;
    }
}

