/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.injection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import javax.persistence.PersistenceUnits;
import org.hibernate.SessionFactory;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.dd.Injectable;
import org.jboss.ejb3.dd.PersistenceUnitRef;
import org.jboss.ejb3.entity.InjectedEntityManagerFactory;
import org.jboss.ejb3.entity.InjectedSessionFactory;
import org.jboss.ejb3.entity.ManagedEntityManagerFactory;
import org.jboss.ejb3.entity.PersistenceUnitDeployment;
import org.jboss.ejb3.injection.EntityManagerFactoryFieldInjector;
import org.jboss.ejb3.injection.EntityManagerFactoryMethodInjector;
import org.jboss.ejb3.injection.InjectionUtil;
import org.jboss.ejb3.injection.Injector;
import org.jboss.ejb3.injection.JndiFieldInjector;
import org.jboss.ejb3.injection.JndiMethodInjector;
import org.jboss.ejb3.injection.PersistenceContextHandler;
import org.jboss.ejb3.interceptor.InterceptorInjector;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitHandler {
    private static final Logger log = Logger.getLogger(PersistenceContextHandler.class);

    private static void loadXmlPUDependencies(List<PersistenceUnitRef> refs, EJBContainer container) {
        for (PersistenceUnitRef ref : refs) {
            container.getPuEncXmlEntries().put("env/" + ref.getRefName(), ref.getUnitName());
            try {
                PersistenceUnitHandler.addPUDependency(ref.getUnitName(), container);
            }
            catch (NameNotFoundException e) {
                throw new RuntimeException("Illegal <persistence-unit-ref> of " + ref.getRefName() + " :" + e.getMessage());
            }
        }
    }

    private static void loadPersistenceUnitRefXml(List<PersistenceUnitRef> refs, EJBContainer container, Class clazz, HashMap<AccessibleObject, Injector> injectors) {
        for (PersistenceUnitRef ref : refs) {
            Class<?> injectionType = null;
            if (ref.getInjectionTarget() != null) {
                AccessibleObject ao = InjectionUtil.findInjectionTarget(clazz, ref.getInjectionTarget());
                if (ao instanceof Field) {
                    injectionType = ((Field)ao).getType();
                    injectors.put(ao, new JndiFieldInjector((Field)ao, "env/" + ref.getRefName(), container.getEnc()));
                } else {
                    injectionType = ((Method)ao).getParameterTypes()[0];
                    injectors.put(ao, new JndiMethodInjector((Method)ao, "env/" + ref.getRefName(), container.getEnc()));
                }
            }
            Object factory = null;
            try {
                factory = PersistenceUnitHandler.getFactory(injectionType, ref.getUnitName(), container);
            }
            catch (NameNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (factory == null) {
                throw new RuntimeException("Failed to load <persistence-unit-ref> of unit name: " + ref.getUnitName() + " for EJB " + container.getEjbName());
            }
            try {
                Util.bind((Context)container.getEnc(), (String)("env/" + ref.getRefName()), (Object)factory);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load <persistence-unit-ref> of unit name: " + ref.getUnitName() + " ref-name" + ref.getRefName() + container.getEjbName(), e);
            }
        }
    }

    private static void loadPUsAnnotation(EJBContainer container, Class clazz, boolean isContainer) throws Exception {
        PersistenceUnit pu;
        PersistenceUnits resources = (PersistenceUnits)InjectionUtil.getAnnotation(PersistenceUnits.class, container, clazz, isContainer);
        if (resources != null) {
            for (PersistenceUnit ref : resources.value()) {
                String encName = ref.name();
                if (encName == null || encName.equals("")) {
                    throw new RuntimeException("JBoss requires name() for class level @PersistenceUnit");
                }
                if (container.getPuEncXmlEntries().containsKey("env/" + encName)) continue;
                EntityManagerFactory factory = PersistenceUnitHandler.getEntityManagerFactory(ref, container);
                PersistenceUnitHandler.bindEntityManagerFactoryToEnc(container, "env/" + encName, factory);
            }
        }
        if ((pu = (PersistenceUnit)InjectionUtil.getAnnotation(PersistenceUnit.class, container, clazz, isContainer)) != null) {
            String encName = pu.name();
            if (encName == null || encName.equals("")) {
                throw new RuntimeException("JBoss requires name() for class level @PersistenceUnit");
            }
            if (container.getPuEncXmlEntries().containsKey("env/" + encName)) {
                return;
            }
            EntityManagerFactory factory = PersistenceUnitHandler.getEntityManagerFactory(pu, container);
            if (factory == null) {
                throw new RuntimeException("Unable to find @PersistenceUnit: " + pu.unitName() + " on " + clazz.getName());
            }
            PersistenceUnitHandler.bindEntityManagerFactoryToEnc(container, "env/" + encName, factory);
        }
    }

    private static void loadClassPUDependencies(EJBContainer container, Class clazz, boolean isContainer) {
        PersistenceUnit pu;
        PersistenceUnits resources = (PersistenceUnits)InjectionUtil.getAnnotation(PersistenceUnits.class, container, clazz, isContainer);
        if (resources != null) {
            for (PersistenceUnit ref : resources.value()) {
                String encName = ref.name();
                if (encName == null || encName.equals("")) {
                    throw new RuntimeException("JBoss requires name() for class level @PersistenceUnit");
                }
                if (container.getPuEncXmlEntries().containsKey("env/" + encName)) continue;
                try {
                    PersistenceUnitHandler.addPUDependency(ref.unitName(), container);
                }
                catch (NameNotFoundException e) {
                    throw new RuntimeException("Invalid " + clazz.getName() + " annotation @PersistenceUnit: " + e.getMessage());
                }
            }
        }
        if ((pu = (PersistenceUnit)InjectionUtil.getAnnotation(PersistenceUnit.class, container, clazz, isContainer)) != null) {
            String encName = pu.name();
            if (encName == null || encName.equals("")) {
                throw new RuntimeException("JBoss requires name() for class level @PersistenceUnit");
            }
            if (container.getPuEncXmlEntries().containsKey("env/" + encName)) {
                return;
            }
            try {
                PersistenceUnitHandler.addPUDependency(pu.unitName(), container);
            }
            catch (NameNotFoundException e) {
                throw new RuntimeException("Invalid " + clazz.getName() + " annotation @PersistenceUnit: " + e.getMessage());
            }
        }
    }

    public static void addPUDependency(String unitName, EJBContainer container) throws NameNotFoundException {
        PersistenceUnitDeployment deployment = null;
        deployment = container.getDeployment().getPersistenceUnitDeployment(unitName);
        if (deployment != null) {
            container.getDependencyPolicy().addDependency(deployment.getKernelName());
            return;
        }
        container.getDependencyPolicy().addDependency(PersistenceUnitDeployment.getDefaultKernelName(unitName));
    }

    public static ManagedEntityManagerFactory getManagedEntityManagerFactory(EJBContainer container, String unitName) throws NameNotFoundException {
        PersistenceUnitDeployment deployment = container.getDeployment().getPersistenceUnitDeployment(unitName);
        if (deployment == null) {
            throw new NameNotFoundException("Unable to find persistence unit: " + unitName + " for EJB container: " + container.getObjectName());
        }
        ManagedEntityManagerFactory factory = deployment.getManagedFactory();
        return factory;
    }

    private static EntityManagerFactory getEntityManagerFactory(PersistenceUnit ref, EJBContainer container) throws NameNotFoundException {
        return PersistenceUnitHandler.getEntityManagerFactory(ref.unitName(), container);
    }

    private static Object getFactory(Class type, String unitName, EJBContainer container) throws NameNotFoundException {
        if (type != null && type.getName().equals(SessionFactory.class.getName())) {
            return PersistenceUnitHandler.getSessionFactory(unitName, container);
        }
        return PersistenceUnitHandler.getEntityManagerFactory(unitName, container);
    }

    private static EntityManagerFactory getEntityManagerFactory(String unitName, EJBContainer container) throws NameNotFoundException {
        PersistenceUnitDeployment deployment = container.getDeployment().getPersistenceUnitDeployment(unitName);
        if (deployment == null) {
            return null;
        }
        ManagedEntityManagerFactory managedFactory = deployment.getManagedFactory();
        return new InjectedEntityManagerFactory(managedFactory);
    }

    private static SessionFactory getSessionFactory(String ref, EJBContainer container) throws NameNotFoundException {
        PersistenceUnitDeployment deployment = container.getDeployment().getPersistenceUnitDeployment(ref);
        if (deployment == null) {
            return null;
        }
        ManagedEntityManagerFactory managedFactory = deployment.getManagedFactory();
        return new InjectedSessionFactory(managedFactory);
    }

    public static void loadInjectors(EJBContainer ejb) throws Exception {
        Class clazz = ejb.getBeanClass();
        PersistenceUnitHandler.loadInjectors(clazz, ejb.getXml(), ejb, ejb.getEncInjections(), true);
    }

    public static void loadInjectors(InterceptorInjector injector) throws Exception {
        PersistenceUnitHandler.loadInjectors(injector.getClazz(), injector.getXml(), (EJBContainer)injector.getContainer(), injector.getEncInjections(), false);
    }

    private static void loadInjectors(Class clazz, Injectable xml, EJBContainer container, HashMap<AccessibleObject, Injector> encInjections, boolean isContainer) throws Exception {
        if (xml != null) {
            PersistenceUnitHandler.loadPersistenceUnitRefXml(xml.getPersistenceUnitRefs(), container, clazz, encInjections);
        }
        HashSet<String> visitedMethods = new HashSet<String>();
        PersistenceUnitHandler.loadPUsAnnotation(container, clazz, isContainer);
        PersistenceUnitHandler.loadMethodInjectors(visitedMethods, container, clazz, encInjections, isContainer);
        PersistenceUnitHandler.loadFieldInjectors(clazz, container, encInjections, isContainer);
    }

    public static void loadDependencies(Injectable xml, EJBContainer container, Class clazz, boolean isContainer) {
        if (xml != null) {
            PersistenceUnitHandler.loadXmlPUDependencies(xml.getPersistenceUnitRefs(), container);
        }
        PersistenceUnitHandler.loadClassPUDependencies(container, clazz, isContainer);
        HashSet<String> visitedMethods = new HashSet<String>();
        PersistenceUnitHandler.loadMethodDependencies(visitedMethods, container, clazz, isContainer);
        PersistenceUnitHandler.loadFieldDependencies(clazz, container, isContainer);
    }

    private static void bindEntityManagerFactoryToEnc(Container container, String encName, Object factory) throws NamingException {
        try {
            Util.bind((Context)container.getEnc(), (String)encName, (Object)factory);
        }
        catch (Exception e) {
            NamingException namingException = new NamingException("Could not bind entity manager factory for EJB container with ejb name " + container.getEjbName() + " into JNDI under jndiName: " + container.getEnc().getNameInNamespace() + "/" + encName);
            namingException.setRootCause(e);
            throw namingException;
        }
    }

    public static void loadMethodInjectors(HashSet<String> visitedMethods, EJBContainer container, Class clazz, HashMap<AccessibleObject, Injector> injectors, boolean isContainer) throws Exception {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            PersistenceUnit ref = (PersistenceUnit)InjectionUtil.getAnnotation(PersistenceUnit.class, container, methods[i], isContainer);
            try {
                EntityManagerFactory factory;
                if (ref == null) continue;
                if (!Modifier.isPrivate(methods[i].getModifiers())) {
                    if (visitedMethods.contains(methods[i].getName())) continue;
                    visitedMethods.add(methods[i].getName());
                }
                if (!methods[i].getName().startsWith("set")) {
                    throw new RuntimeException("@PersistenceContext can only be used with a set method: " + methods[i]);
                }
                if (methods[i].getParameterTypes().length != 1) {
                    throw new RuntimeException("@PersistenceContext can only be used with a set method of one parameter: " + methods[i]);
                }
                String encName = ref.name();
                encName = encName == null || encName.equals("") ? InjectionUtil.getEncName(methods[i]) : "env/" + ref.name();
                String unitName = container.getPuEncXmlEntries().get(encName);
                boolean bindingExists = false;
                if (unitName == null) {
                    unitName = ref.unitName();
                } else {
                    bindingExists = true;
                }
                if (injectors.containsKey(methods[i])) continue;
                if (methods[i].getParameterTypes()[0].getName().equals(EntityManagerFactory.class.getName())) {
                    factory = PersistenceUnitHandler.getEntityManagerFactory(unitName, container);
                    injectors.put(methods[i], new EntityManagerFactoryMethodInjector(methods[i], container, factory));
                    if (bindingExists) continue;
                    PersistenceUnitHandler.bindEntityManagerFactoryToEnc(container, encName, factory);
                    continue;
                }
                factory = PersistenceUnitHandler.getSessionFactory(unitName, container);
                injectors.put(methods[i], new EntityManagerFactoryMethodInjector(methods[i], container, factory));
                if (bindingExists) continue;
                PersistenceUnitHandler.bindEntityManagerFactoryToEnc(container, encName, factory);
                continue;
            }
            catch (Exception ex) {
                throw new RuntimeException("failed in processing injection annotation on method: " + methods[i].toString(), ex);
            }
        }
        PersistenceUnitHandler.loadMethodInjectors(visitedMethods, container, clazz.getSuperclass(), injectors, isContainer);
    }

    public static void loadMethodDependencies(HashSet<String> visitedMethods, EJBContainer container, Class clazz, boolean isContainer) {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            String encName;
            PersistenceUnit ref = (PersistenceUnit)InjectionUtil.getAnnotation(PersistenceUnit.class, container, methods[i], isContainer);
            if (ref == null) continue;
            if (!Modifier.isPrivate(methods[i].getModifiers())) {
                if (visitedMethods.contains(methods[i].getName())) continue;
                visitedMethods.add(methods[i].getName());
            }
            encName = (encName = ref.name()) == null || encName.equals("") ? InjectionUtil.getEncName(methods[i]) : "env/" + encName;
            if (container.getPuEncXmlEntries().containsKey(encName)) continue;
            try {
                PersistenceUnitHandler.addPUDependency(ref.unitName(), container);
                continue;
            }
            catch (NameNotFoundException e) {
                throw new RuntimeException("Method " + methods[i].toString() + " @PersistenceUnit in error: " + e.getMessage());
            }
        }
        PersistenceUnitHandler.loadMethodDependencies(visitedMethods, container, clazz.getSuperclass(), isContainer);
    }

    private static void loadFieldDependencies(Class clazz, EJBContainer container, boolean isContainer) {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        PersistenceUnitHandler.loadFieldDependencies(clazz.getSuperclass(), container, isContainer);
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            PersistenceUnit ref = (PersistenceUnit)InjectionUtil.getAnnotation(PersistenceUnit.class, container, fields[i], isContainer);
            if (ref == null) continue;
            String encName = ref.name();
            encName = encName == null || encName.equals("") ? InjectionUtil.getEncName(fields[i]) : "env/" + encName;
            if (container.getPuEncXmlEntries().containsKey(encName)) continue;
            try {
                PersistenceUnitHandler.addPUDependency(ref.unitName(), container);
                continue;
            }
            catch (NameNotFoundException e) {
                throw new RuntimeException("Field " + fields[i].toString() + " @PersistenceUnit in error: " + e.getMessage());
            }
        }
    }

    private static void loadFieldInjectors(Class clazz, EJBContainer container, HashMap<AccessibleObject, Injector> injectors, boolean isContainer) throws Exception {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        PersistenceUnitHandler.loadFieldInjectors(clazz.getSuperclass(), container, injectors, isContainer);
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                EntityManagerFactory factory;
                PersistenceUnit ref = (PersistenceUnit)InjectionUtil.getAnnotation(PersistenceUnit.class, container, fields[i], isContainer);
                if (ref == null) continue;
                fields[i].setAccessible(true);
                String encName = ref.name();
                encName = encName == null || encName.equals("") ? InjectionUtil.getEncName(fields[i]) : "env/" + encName;
                String unitName = container.getPuEncXmlEntries().get(encName);
                boolean bindingExists = false;
                if (unitName == null) {
                    unitName = ref.unitName();
                } else {
                    bindingExists = true;
                }
                if (injectors.containsKey(fields[i])) continue;
                if (fields[i].getType().getName().equals(EntityManagerFactory.class.getName())) {
                    factory = PersistenceUnitHandler.getEntityManagerFactory(unitName, container);
                    injectors.put(fields[i], new EntityManagerFactoryFieldInjector(fields[i], container, factory));
                    if (bindingExists) continue;
                    PersistenceUnitHandler.bindEntityManagerFactoryToEnc(container, encName, factory);
                    continue;
                }
                factory = PersistenceUnitHandler.getSessionFactory(unitName, container);
                injectors.put(fields[i], new EntityManagerFactoryFieldInjector(fields[i], container, factory));
                if (bindingExists) continue;
                PersistenceUnitHandler.bindEntityManagerFactoryToEnc(container, encName, factory);
                continue;
            }
            catch (Exception ex) {
                throw new RuntimeException("failed in processing injection annotation on field: " + fields[i].toString(), ex);
            }
        }
    }
}

