/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.Init;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remote;
import javax.ejb.RemoteHome;
import javax.ejb.TimerService;
import org.jboss.annotation.ejb.LocalBinding;
import org.jboss.annotation.ejb.RemoteBinding;
import org.jboss.annotation.ejb.RemoteBindings;
import org.jboss.annotation.ejb.cache.Cache;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aspects.asynch.FutureHolder;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.ProxyUtils;
import org.jboss.ejb3.SessionContainer;
import org.jboss.ejb3.ThreadLocalENCFactory;
import org.jboss.ejb3.cache.StatefulCache;
import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
import org.jboss.ejb3.proxy.EJBMetaDataImpl;
import org.jboss.ejb3.proxy.handle.HomeHandleImpl;
import org.jboss.ejb3.stateful.ForwardId;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainerInvocation;
import org.jboss.ejb3.stateful.StatefulHandleImpl;
import org.jboss.ejb3.stateful.StatefulLocalProxyFactory;
import org.jboss.ejb3.stateful.StatefulRemoteInvocation;
import org.jboss.ejb3.stateful.StatefulRemoteProxyFactory;
import org.jboss.logging.Logger;

public class StatefulContainer
extends SessionContainer {
    private static final Logger log = Logger.getLogger(StatefulContainer.class);
    protected StatefulCache cache;

    public StatefulContainer(ClassLoader cl, String beanClassName, String ejbName, AspectManager manager, Hashtable ctxProperties, InterceptorInfoRepository interceptorRepository, Ejb3Deployment deployment) {
        super(cl, beanClassName, ejbName, manager, ctxProperties, interceptorRepository, deployment);
        this.beanContextClass = StatefulBeanContext.class;
    }

    public void start() throws Exception {
        try {
            super.start();
            Cache cacheConfig = (Cache)this.resolveAnnotation(Cache.class);
            this.cache = (StatefulCache)cacheConfig.value().newInstance();
            this.cache.initialize(this);
            this.cache.start();
        }
        catch (Exception e) {
            try {
                this.stop();
            }
            catch (Exception ignore) {
                log.debug((Object)"Failed to cleanup after start() failure", (Throwable)ignore);
            }
            throw e;
        }
    }

    public void stop() throws Exception {
        super.stop();
        if (this.cache != null) {
            this.cache.stop();
        }
    }

    public StatefulCache getCache() {
        return this.cache;
    }

    public Object localInvoke(Object id, Method method, Object[] args) throws Throwable {
        return this.localInvoke(id, method, args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object localHomeInvoke(Method method, Object[] args) throws Throwable {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        ThreadLocalENCFactory.push(this.enc);
        try {
            long hash = MethodHashing.calculateHash((Method)method);
            MethodInfo info = (MethodInfo)this.methodInterceptors.get(hash);
            if (info == null) {
                throw new RuntimeException("Could not resolve beanClass method from proxy call: " + method.toString());
            }
            Object object = this.invokeLocalHomeMethod(info, args);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
            ThreadLocalENCFactory.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object localInvoke(Object id, Method method, Object[] args, FutureHolder provider) throws Throwable {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        ThreadLocalENCFactory.push(this.enc);
        try {
            long hash = MethodHashing.calculateHash((Method)method);
            MethodInfo info = (MethodInfo)this.methodInterceptors.get(hash);
            if (info == null) {
                throw new RuntimeException("Could not resolve beanClass method from proxy call: " + method.toString());
            }
            if (info.unadvisedMethod != null) {
                this.invokedMethod.put(this, info.unadvisedMethod);
            }
            if (info.unadvisedMethod != null && this.isHomeMethod(info.unadvisedMethod)) {
                Object object = this.invokeLocalHomeMethod(info, args);
                return object;
            }
            if (info.unadvisedMethod != null && this.isEJBObjectMethod(info.unadvisedMethod)) {
                Object object = this.invokeEJBLocalObjectMethod(id, info, args);
                return object;
            }
            if (info.unadvisedMethod != null) {
                this.invokedMethod.put(id, info.unadvisedMethod);
            }
            Interceptor[] aspects = info.interceptors;
            StatefulContainerInvocation nextInvocation = new StatefulContainerInvocation(info, aspects, id);
            nextInvocation.setAdvisor((Advisor)this);
            nextInvocation.setArguments(args);
            ProxyUtils.addLocalAsynchronousInfo(nextInvocation, provider);
            Object object = nextInvocation.invokeNext();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
            ThreadLocalENCFactory.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createSession() {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        ThreadLocalENCFactory.push(this.enc);
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            Object object = this.getCache().create().getId();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
            ThreadLocalENCFactory.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createSession(Class[] initTypes, Object[] initValues) {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        ThreadLocalENCFactory.push(this.enc);
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            Object object = this.getCache().create(initTypes, initValues).getId();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
            ThreadLocalENCFactory.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvocationResponse dynamicInvoke(Object target, Invocation invocation) throws Throwable {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        StatefulContainerInvocation newSi = null;
        ThreadLocalENCFactory.push(this.enc);
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            StatefulRemoteInvocation si = (StatefulRemoteInvocation)invocation;
            MethodInfo info = (MethodInfo)this.methodInterceptors.get(si.getMethodHash());
            if (info == null) {
                throw new RuntimeException("Could not resolve beanClass method from proxy call");
            }
            InvocationResponse response = null;
            if (info != null && info.unadvisedMethod != null && this.isHomeMethod(info.unadvisedMethod)) {
                response = this.invokeHomeMethod(info, si);
            } else if (info != null && info.unadvisedMethod != null && this.isEJBObjectMethod(info.unadvisedMethod)) {
                response = this.invokeEJBObjectMethod(info, si);
            } else {
                Interceptor[] aspects = info.interceptors;
                Object newId = null;
                if (si.getId() == null) {
                    StatefulBeanContext ctx = this.getCache().create();
                    newId = ctx.getId();
                } else {
                    newId = si.getId();
                }
                newSi = new StatefulContainerInvocation(info, aspects, newId);
                newSi.setArguments(si.getArguments());
                newSi.setMetaData(si.getMetaData());
                newSi.setAdvisor((Advisor)this);
                if (info.unadvisedMethod != null) {
                    this.invokedMethod.put(newId, info.unadvisedMethod);
                }
                Object rtn = null;
                try {
                    rtn = newSi.invokeNext();
                }
                catch (Throwable throwable) {
                    Throwable exception = throwable;
                    if (newId != null) {
                        exception = new ForwardId(throwable, newId);
                    }
                    Map responseContext = newSi.getResponseContextInfo();
                    InvocationResponse invocationResponse = response = StatefulContainer.marshallException(invocation, exception, responseContext);
                    Thread.currentThread().setContextClassLoader(oldLoader);
                    ThreadLocalENCFactory.pop();
                    return invocationResponse;
                }
                response = StatefulContainer.marshallResponse(invocation, rtn, newSi.getResponseContextInfo());
                if (newId != null) {
                    response.addAttachment((Object)"NEW_ID", newId);
                }
            }
            InvocationResponse invocationResponse = response;
            return invocationResponse;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
            ThreadLocalENCFactory.pop();
        }
    }

    public TimerService getTimerService() {
        throw new RuntimeException("Illegal operation.  StrictlyPooledSessionBean beans can't access TimerService");
    }

    public void invokePostActivate(BeanContext beanContext) {
        this.callbackHandler.postActivate(beanContext);
    }

    public void invokePrePassivate(BeanContext beanContext) {
        this.callbackHandler.prePassivate(beanContext);
    }

    protected Class[] getHandledCallbacks() {
        return new Class[]{PostConstruct.class, PreDestroy.class, PostActivate.class, PrePassivate.class};
    }

    public void invokeInit(Object bean) {
        try {
            Method[] methods = bean.getClass().getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (methods[i].getParameterTypes().length != 0 || methods[i].getAnnotation(Init.class) == null && this.resolveAnnotation(methods[i], Init.class) == null) continue;
                methods[i].invoke(bean, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void invokeInit(Object bean, Class[] initParameterTypes, Object[] initParameterValues) {
        try {
            Method[] methods = bean.getClass().getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Object[] parameters;
                if (methods[i].getAnnotation(Init.class) == null && this.resolveAnnotation(methods[i], Init.class) == null || (parameters = this.getInitParameters(methods[i], initParameterTypes, initParameterValues)) == null) continue;
                methods[i].invoke(bean, parameters);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Object[] getInitParameters(Method method, Class[] initParameterTypes, Object[] initParameterValues) {
        if (method.getParameterTypes().length == initParameterTypes.length) {
            for (int i = 0; i < initParameterTypes.length; ++i) {
                Class actual;
                Class<?> formal = method.getParameterTypes()[i];
                if (StatefulContainer.isMethodInvocationConvertible(formal, (actual = initParameterTypes[i]) == null ? null : actual)) continue;
                return null;
            }
            return initParameterValues;
        }
        return null;
    }

    private static boolean isMethodInvocationConvertible(Class formal, Class actual) {
        if (actual == null && !formal.isPrimitive()) {
            return true;
        }
        if (actual != null && formal.isAssignableFrom(actual)) {
            return true;
        }
        if (formal.isPrimitive()) {
            if (formal == Boolean.TYPE && actual == Boolean.class) {
                return true;
            }
            if (formal == Character.TYPE && actual == Character.class) {
                return true;
            }
            if (formal == Byte.TYPE && actual == Byte.class) {
                return true;
            }
            if (formal == Short.TYPE && (actual == Short.class || actual == Byte.class)) {
                return true;
            }
            if (formal == Integer.TYPE && (actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                return true;
            }
            if (formal == Long.TYPE && (actual == Long.class || actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                return true;
            }
            if (formal == Float.TYPE && (actual == Float.class || actual == Long.class || actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                return true;
            }
            if (formal == Double.TYPE && (actual == Double.class || actual == Float.class || actual == Long.class || actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                return true;
            }
        }
        return false;
    }

    private Object invokeEJBLocalObjectMethod(Object id, MethodInfo info, Object[] args) throws Exception {
        if (info.unadvisedMethod.getName().equals("remove")) {
            StatefulBeanContext ctx = this.getCache().get(id);
            this.invokePreDestroy(ctx);
            this.getCache().remove(id);
            return null;
        }
        if (info.unadvisedMethod.getName().equals("getEJBLocalHome")) {
            Object bean = this.getCache().get(id).getInstance();
            return bean;
        }
        if (info.unadvisedMethod.getName().equals("getPrimaryKey")) {
            return id;
        }
        if (info.unadvisedMethod.getName().equals("isIdentical")) {
            EJBObject bean = (EJBObject)args[0];
            Object primaryKey = bean.getPrimaryKey();
            boolean isIdentical = id.equals(primaryKey);
            return isIdentical;
        }
        return null;
    }

    private Object invokeLocalHomeMethod(MethodInfo info, Object[] args) throws Exception {
        if (info.unadvisedMethod.getName().equals("create")) {
            Class[] initParameterTypes = new Class[]{};
            Object[] initParameterValues = new Object[]{};
            if (info.unadvisedMethod.getParameterTypes().length > 0) {
                initParameterTypes = info.unadvisedMethod.getParameterTypes();
                initParameterValues = args;
            }
            LocalBinding binding = (LocalBinding)this.resolveAnnotation(LocalBinding.class);
            StatefulLocalProxyFactory factory = new StatefulLocalProxyFactory();
            factory.setContainer(this);
            factory.init();
            Object proxy = factory.createProxy(initParameterTypes, initParameterValues);
            return proxy;
        }
        if (info.unadvisedMethod.getName().equals("remove")) {
            StatefulHandleImpl handle = (StatefulHandleImpl)args[0];
            StatefulBeanContext ctx = this.getCache().get(handle.id);
            this.invokePreDestroy(ctx);
            this.getCache().remove(handle.id);
            return null;
        }
        return null;
    }

    protected InvocationResponse invokeHomeMethod(MethodInfo info, StatefulRemoteInvocation statefulInvocation) throws Throwable {
        if (info.unadvisedMethod.getName().equals("create")) {
            Class[] initParameterTypes = new Class[]{};
            Object[] initParameterValues = new Object[]{};
            if (info.unadvisedMethod.getParameterTypes().length > 0) {
                initParameterTypes = info.unadvisedMethod.getParameterTypes();
                initParameterValues = statefulInvocation.getArguments();
            }
            RemoteBinding binding = null;
            RemoteBindings bindings = (RemoteBindings)this.resolveAnnotation(RemoteBindings.class);
            binding = bindings != null ? bindings.value()[0] : (RemoteBinding)this.resolveAnnotation(RemoteBinding.class);
            StatefulContainerInvocation newStatefulInvocation = this.buildNewInvocation(info, statefulInvocation, initParameterTypes, initParameterValues);
            StatefulRemoteProxyFactory factory = new StatefulRemoteProxyFactory();
            factory.setContainer(this);
            factory.setRemoteBinding(binding);
            factory.init();
            Object proxy = null;
            proxy = newStatefulInvocation.getId() != null ? factory.createProxy(newStatefulInvocation.getId()) : factory.createProxy();
            InvocationResponse response = StatefulContainer.marshallResponse((Invocation)statefulInvocation, proxy, newStatefulInvocation.getResponseContextInfo());
            if (newStatefulInvocation.getId() != null) {
                response.addAttachment((Object)"NEW_ID", newStatefulInvocation.getId());
            }
            return response;
        }
        if (info.unadvisedMethod.getName().equals("remove")) {
            StatefulHandleImpl handle = (StatefulHandleImpl)statefulInvocation.getArguments()[0];
            StatefulBeanContext ctx = this.getCache().get(handle.id);
            this.invokePreDestroy(ctx);
            this.getCache().remove(handle.id);
            InvocationResponse response = new InvocationResponse(null);
            response.setContextInfo(statefulInvocation.getResponseContextInfo());
            return response;
        }
        if (info.unadvisedMethod.getName().equals("getEJBMetaData")) {
            RemoteBinding remoteBindingAnnotation;
            RemoteHome homeAnnotation;
            Class remote = null;
            Class home = null;
            Class<Object> pkClass = Object.class;
            HomeHandleImpl homeHandle = null;
            Remote remoteAnnotation = (Remote)this.resolveAnnotation(Remote.class);
            if (remoteAnnotation != null) {
                remote = remoteAnnotation.value()[0];
            }
            if ((homeAnnotation = (RemoteHome)this.resolveAnnotation(RemoteHome.class)) != null) {
                home = homeAnnotation.value();
            }
            if ((remoteBindingAnnotation = (RemoteBinding)this.resolveAnnotation(RemoteBinding.class)) != null) {
                homeHandle = new HomeHandleImpl(remoteBindingAnnotation.jndiBinding());
            }
            EJBMetaDataImpl metadata = new EJBMetaDataImpl(remote, home, pkClass, true, false, homeHandle);
            InvocationResponse response = StatefulContainer.marshallResponse((Invocation)statefulInvocation, metadata, null);
            return response;
        }
        if (info.unadvisedMethod.getName().equals("getHomeHandle")) {
            HomeHandleImpl homeHandle = null;
            RemoteBinding remoteBindingAnnotation = (RemoteBinding)this.resolveAnnotation(RemoteBinding.class);
            if (remoteBindingAnnotation != null) {
                homeHandle = new HomeHandleImpl(remoteBindingAnnotation.jndiBinding());
            }
            InvocationResponse response = StatefulContainer.marshallResponse((Invocation)statefulInvocation, homeHandle, null);
            return response;
        }
        return null;
    }

    protected InvocationResponse invokeEJBObjectMethod(MethodInfo info, StatefulRemoteInvocation statefulInvocation) throws Throwable {
        if (info.unadvisedMethod.getName().equals("getHandle")) {
            StatefulContainerInvocation newStatefulInvocation = this.buildInvocation(info, statefulInvocation);
            StatefulHandleImpl handle = new StatefulHandleImpl();
            handle.id = newStatefulInvocation.getId();
            RemoteBinding remoteBinding = (RemoteBinding)this.resolveAnnotation(RemoteBinding.class);
            if (remoteBinding != null) {
                handle.jndiName = remoteBinding.jndiBinding();
            }
            InvocationResponse response = StatefulContainer.marshallResponse((Invocation)statefulInvocation, handle, null);
            return response;
        }
        if (info.unadvisedMethod.getName().equals("remove")) {
            StatefulBeanContext ctx = this.getCache().get(statefulInvocation.getId());
            this.invokePreDestroy(ctx);
            this.getCache().remove(statefulInvocation.getId());
            InvocationResponse response = new InvocationResponse(null);
            return response;
        }
        if (info.unadvisedMethod.getName().equals("getEJBHome")) {
            HomeHandleImpl homeHandle = null;
            RemoteBinding remoteBindingAnnotation = (RemoteBinding)this.resolveAnnotation(RemoteBinding.class);
            if (remoteBindingAnnotation != null) {
                homeHandle = new HomeHandleImpl(remoteBindingAnnotation.jndiBinding() + "Home");
            }
            EJBHome ejbHome = homeHandle.getEJBHome();
            InvocationResponse response = StatefulContainer.marshallResponse((Invocation)statefulInvocation, ejbHome, null);
            return response;
        }
        if (info.unadvisedMethod.getName().equals("getPrimaryKey")) {
            Object id = statefulInvocation.getId();
            InvocationResponse response = StatefulContainer.marshallResponse((Invocation)statefulInvocation, id, null);
            return response;
        }
        if (info.unadvisedMethod.getName().equals("isIdentical")) {
            Object id = statefulInvocation.getId();
            EJBObject bean = (EJBObject)statefulInvocation.getArguments()[0];
            Object primaryKey = bean.getPrimaryKey();
            boolean isIdentical = id.equals(primaryKey);
            InvocationResponse response = StatefulContainer.marshallResponse((Invocation)statefulInvocation, isIdentical, null);
            return response;
        }
        return null;
    }

    private StatefulContainerInvocation buildNewInvocation(MethodInfo info, StatefulRemoteInvocation statefulInvocation, Class[] initParameterTypes, Object[] initParameterValues) {
        StatefulContainerInvocation newStatefulInvocation = null;
        Interceptor[] aspects = info.interceptors;
        Object newId = null;
        StatefulBeanContext ctx = null;
        ctx = initParameterTypes.length > 0 ? this.getCache().create(initParameterTypes, initParameterValues) : this.getCache().create();
        newId = ctx.getId();
        newStatefulInvocation = new StatefulContainerInvocation(info, aspects, newId);
        newStatefulInvocation.setArguments(statefulInvocation.getArguments());
        newStatefulInvocation.setMetaData(statefulInvocation.getMetaData());
        newStatefulInvocation.setAdvisor((Advisor)this);
        return newStatefulInvocation;
    }

    private StatefulContainerInvocation buildInvocation(MethodInfo info, StatefulRemoteInvocation statefulInvocation) {
        StatefulContainerInvocation newStatefulInvocation = null;
        Interceptor[] aspects = info.interceptors;
        Object newId = null;
        if (statefulInvocation.getId() == null) {
            StatefulBeanContext ctx = this.getCache().create();
            newId = ctx.getId();
            newStatefulInvocation = new StatefulContainerInvocation(info, aspects, newId);
        } else {
            newStatefulInvocation = new StatefulContainerInvocation(info, aspects, statefulInvocation.getId());
        }
        newStatefulInvocation.setArguments(statefulInvocation.getArguments());
        newStatefulInvocation.setMetaData(statefulInvocation.getMetaData());
        newStatefulInvocation.setAdvisor((Advisor)this);
        return newStatefulInvocation;
    }

    public Object getInvokedBusinessInterface(BeanContext beanContext) throws IllegalStateException {
        Method method = (Method)this.invokedMethod.get(beanContext.getInvokedMethodKey());
        if (method == null) {
            throw new IllegalStateException("No invocation");
        }
        return this.getInvokedInterface(method);
    }

    public Object getBusinessObject(BeanContext beanContext, Class businessInterface) throws IllegalStateException {
        Method method = (Method)this.invokedMethod.get(beanContext.getInvokedMethodKey());
        if (method == null) {
            throw new IllegalStateException("No invocation");
        }
        Object invokedInterface = this.getInvokedInterface(method);
        if (!invokedInterface.equals(businessInterface)) {
            throw new IllegalStateException("Business interface " + businessInterface + " was not invoked interface");
        }
        return invokedInterface;
    }
}

