/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.ejb;

import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.annotations.api.Annotation;
import org.nuxeo.ecm.platform.annotations.api.AnnotationException;
import org.nuxeo.ecm.platform.annotations.api.AnnotationsService;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.runtime.api.Framework;

@Stateless
public class AnnotationServiceBean
implements AnnotationsService {
    private static final Log log = LogFactory.getLog(AnnotationServiceBean.class);
    private AnnotationsService service;

    @PostConstruct
    public void initialise() {
        try {
            this.service = (AnnotationsService)Framework.getLocalService(AnnotationsService.class);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public Annotation addAnnotation(Annotation annotation, NuxeoPrincipal user, String baseUrl) throws AnnotationException {
        return this.service.addAnnotation(annotation, user, baseUrl);
    }

    public void deleteAnnotation(Annotation annotation, NuxeoPrincipal user) throws AnnotationException {
        this.service.deleteAnnotation(annotation, user);
    }

    public void deleteAnnotationFor(URI uri, Annotation annotation, NuxeoPrincipal user) throws AnnotationException {
        this.service.deleteAnnotationFor(uri, annotation, user);
    }

    public Annotation getAnnotation(String annotationId, NuxeoPrincipal user, String baseUrl) throws AnnotationException {
        return this.service.getAnnotation(annotationId, user, baseUrl);
    }

    public List<Annotation> queryAnnotations(URI uri, Map<String, String> filters, NuxeoPrincipal user) throws AnnotationException {
        return this.service.queryAnnotations(uri, filters, user);
    }

    public Annotation updateAnnotation(Annotation annotation, NuxeoPrincipal user, String baseUrl) throws AnnotationException {
        return this.service.updateAnnotation(annotation, user, baseUrl);
    }

    public Graph getAnnotationGraph() throws AnnotationException {
        return this.service.getAnnotationGraph();
    }
}

