/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.bindings;

import java.util.Map;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.chemistry.opencmis.server.impl.webservices.AuthHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.opencmis.bindings.LoginProvider;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class NuxeoCmisAuthHandler
extends AuthHandler
implements LoginProvider {
    private static final Log log = LogFactory.getLog(NuxeoCmisAuthHandler.class);
    public static final String NUXEO_LOGIN_CONTEXT = "nuxeo.opencmis.LoginContext";
    public static final String LOGIN_PROVIDER_PROP = LoginProvider.class.getName();
    protected LoginProvider loginProvider;

    public boolean handleMessage(SOAPMessageContext soapContext) {
        boolean res = super.handleMessage(soapContext);
        Map callContextMap = (Map)soapContext.get((Object)"org.apache.chemistry.opencmis.callcontext");
        if (callContextMap != null) {
            String username = (String)callContextMap.get("useranme");
            String password = (String)callContextMap.get("password");
            try {
                LoginContext loginContext = this.getLoginProvider().login(username, password);
                soapContext.put((Object)NUXEO_LOGIN_CONTEXT, (Object)loginContext);
                soapContext.setScope(NUXEO_LOGIN_CONTEXT, MessageContext.Scope.APPLICATION);
            }
            catch (LoginException e) {
                throw new RuntimeException("Login failed for user '" + username + "'", e);
            }
        }
        return res;
    }

    public void close(MessageContext context) {
        LoginContext loginContext = (LoginContext)context.get((Object)NUXEO_LOGIN_CONTEXT);
        if (loginContext != null) {
            try {
                loginContext.logout();
            }
            catch (LoginException e) {
                log.error((Object)"Cannot logout", (Throwable)e);
            }
        }
        super.close(context);
    }

    protected LoginProvider getLoginProvider() {
        if (this.loginProvider == null) {
            this.loginProvider = this;
            String className = Framework.getProperty((String)LOGIN_PROVIDER_PROP);
            if (className != null) {
                try {
                    Object instance = Class.forName(className).newInstance();
                    if (instance instanceof LoginProvider) {
                        this.loginProvider = (LoginProvider)instance;
                    } else {
                        log.error((Object)(className + " is not an instance of " + LoginProvider.class.getName()));
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        }
        return this.loginProvider;
    }

    @Override
    public LoginContext login(String username, String password) {
        try {
            if (!this.getUserManager().checkUsernamePassword(username, password)) {
                throw new RuntimeException("Authentication failed for user '" + username + "'");
            }
            return Framework.login((String)username, (Object)password);
        }
        catch (ClientException e) {
            throw new RuntimeException("Cannot authenticate", e);
        }
        catch (LoginException e) {
            throw new RuntimeException("Login failed for user '" + username + "'", e);
        }
    }

    protected UserManager getUserManager() {
        UserManager userManager;
        try {
            userManager = (UserManager)Framework.getService(UserManager.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get UserManager service", e);
        }
        if (userManager == null) {
            throw new RuntimeException("Cannot get UserManager service");
        }
        return userManager;
    }
}

