/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.core.im;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandAvailability;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.core.ImageUtils;
import org.nuxeo.ecm.platform.picture.core.mistral.MistralImageUtils;
import org.nuxeo.ecm.platform.picture.magick.utils.ImageCropper;
import org.nuxeo.ecm.platform.picture.magick.utils.ImageIdentifier;
import org.nuxeo.ecm.platform.picture.magick.utils.ImageResizer;
import org.nuxeo.ecm.platform.picture.magick.utils.ImageRotater;
import org.nuxeo.runtime.api.Framework;

public class IMImageUtils
implements ImageUtils {
    private static final Log log = LogFactory.getLog(IMImageUtils.class);

    @Override
    @Deprecated
    public InputStream crop(InputStream in, int x, int y, int width, int height) {
        try {
            CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getLocalService(CommandLineExecutorService.class);
            CommandAvailability commandAvailability = cles.getCommandAvailability("crop");
            if (commandAvailability.isAvailable()) {
                FileBlob fb = new FileBlob(in);
                String path = fb.getFile().getAbsolutePath();
                ImageInfo imageInfo = ImageIdentifier.getInfo(path);
                File img2 = File.createTempFile("target", "." + imageInfo.getFormat());
                ImageCropper.crop(path, img2.getAbsolutePath(), width, height, x, y);
                FileInputStream is = new FileInputStream(img2);
                img2.delete();
                return is;
            }
            MistralImageUtils miu = new MistralImageUtils();
            return miu.crop(in, x, y, width, height);
        }
        catch (Exception e) {
            log.error((Object)"Crop with ImageMagick failed", (Throwable)e);
            return null;
        }
    }

    @Override
    @Deprecated
    public InputStream resize(InputStream in, int width, int height) {
        try {
            CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getLocalService(CommandLineExecutorService.class);
            CommandAvailability commandAvailability = cles.getCommandAvailability("resizer");
            if (commandAvailability.isAvailable()) {
                FileBlob fb = new FileBlob(in);
                String path = fb.getFile().getAbsolutePath();
                ImageInfo imageInfo = ImageIdentifier.getInfo(path);
                File img2 = File.createTempFile("target", "." + imageInfo.getFormat());
                ImageResizer.resize(path, img2.getAbsolutePath(), width, height, imageInfo.getDepth());
                FileInputStream is = new FileInputStream(img2);
                img2.delete();
                return is;
            }
            MistralImageUtils miu = new MistralImageUtils();
            return miu.resize(in, width, height);
        }
        catch (Exception e) {
            log.error((Object)"Resizing with ImageMagick failed", (Throwable)e);
            return null;
        }
    }

    @Override
    @Deprecated
    public InputStream rotate(InputStream in, int angle) {
        try {
            CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getLocalService(CommandLineExecutorService.class);
            CommandAvailability commandAvailability = cles.getCommandAvailability("rotate");
            if (commandAvailability.isAvailable()) {
                FileBlob fb = new FileBlob(in);
                String path = fb.getFile().getAbsolutePath();
                ImageInfo imageInfo = ImageIdentifier.getInfo(path);
                File img2 = File.createTempFile("target", "." + imageInfo.getFormat());
                ImageRotater.rotate(path, img2.getAbsolutePath(), angle);
                FileInputStream is = new FileInputStream(img2);
                img2.delete();
                return is;
            }
            MistralImageUtils miu = new MistralImageUtils();
            return miu.rotate(in, angle);
        }
        catch (Exception e) {
            log.error((Object)"Rotation with ImageMagick failed", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob crop(Blob blob, int x, int y, int width, int height) {
        block6: {
            FileBlob fileBlob;
            block7: {
                CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getLocalService(CommandLineExecutorService.class);
                CommandAvailability commandAvailability = cles.getCommandAvailability("resizer");
                if (!commandAvailability.isAvailable()) break block6;
                File sourceFile = File.createTempFile("source", blob.getFilename());
                try {
                    blob.transferTo(sourceFile);
                    String suffix = this.getTempSuffix(blob, sourceFile);
                    File targetFile = File.createTempFile("target", suffix);
                    ImageCropper.crop(sourceFile.getAbsolutePath(), targetFile.getAbsolutePath(), width, height, x, y);
                    FileBlob targetBlob = new FileBlob(targetFile);
                    Framework.trackFile((File)targetFile, (Object)targetBlob);
                    fileBlob = targetBlob;
                    if (sourceFile == null) break block7;
                    sourceFile.delete();
                }
                catch (Throwable throwable) {
                    try {
                        if (sourceFile != null) {
                            sourceFile.delete();
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        log.error((Object)"Resizing with ImageMagick failed", (Throwable)e);
                    }
                }
            }
            return fileBlob;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob resize(Blob blob, String finalFormat, int width, int height, int depth) {
        block6: {
            FileBlob fileBlob;
            block7: {
                CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getLocalService(CommandLineExecutorService.class);
                CommandAvailability commandAvailability = cles.getCommandAvailability("resizer");
                if (!commandAvailability.isAvailable()) break block6;
                File sourceFile = File.createTempFile("source", blob.getFilename());
                try {
                    blob.transferTo(sourceFile);
                    String suffix = finalFormat != null ? "." + finalFormat : this.getTempSuffix(blob, sourceFile);
                    File targetFile = File.createTempFile("target", suffix);
                    ImageResizer.resize(sourceFile.getAbsolutePath(), targetFile.getAbsolutePath(), width, height, depth);
                    FileBlob targetBlob = new FileBlob(targetFile);
                    Framework.trackFile((File)targetFile, (Object)targetBlob);
                    fileBlob = targetBlob;
                    if (sourceFile == null) break block7;
                    sourceFile.delete();
                }
                catch (Throwable throwable) {
                    try {
                        if (sourceFile != null) {
                            sourceFile.delete();
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        log.error((Object)"Resizing with ImageMagick failed", (Throwable)e);
                    }
                }
            }
            return fileBlob;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob rotate(Blob blob, int angle) {
        block6: {
            FileBlob fileBlob;
            block7: {
                CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getLocalService(CommandLineExecutorService.class);
                CommandAvailability commandAvailability = cles.getCommandAvailability("rotate");
                if (!commandAvailability.isAvailable()) break block6;
                File sourceFile = File.createTempFile("source", blob.getFilename());
                try {
                    blob.transferTo(sourceFile);
                    String suffix = this.getTempSuffix(blob, sourceFile);
                    File targetFile = File.createTempFile("target", suffix);
                    ImageRotater.rotate(sourceFile.getAbsolutePath(), targetFile.getAbsolutePath(), angle);
                    FileBlob targetBlob = new FileBlob(targetFile);
                    Framework.trackFile((File)targetFile, (Object)targetBlob);
                    fileBlob = targetBlob;
                    if (sourceFile == null) break block7;
                    sourceFile.delete();
                }
                catch (Throwable throwable) {
                    try {
                        if (sourceFile != null) {
                            sourceFile.delete();
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        log.error((Object)"Rotation with ImageMagick failed", (Throwable)e);
                    }
                }
            }
            return fileBlob;
        }
        return null;
    }

    protected String getTempSuffix(Blob blob, File file) throws CommandNotAvailable {
        String suffix = blob.getFilename();
        if (suffix == null) {
            ImageInfo imageInfo = ImageIdentifier.getInfo(file.getAbsolutePath());
            suffix = "." + imageInfo.getFormat();
        }
        return suffix;
    }

    @Override
    public boolean isAvailable() {
        CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getLocalService(CommandLineExecutorService.class);
        CommandAvailability commandAvailability = cles.getCommandAvailability("identify");
        return commandAvailability.isAvailable();
    }
}

