/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.core.mistral;

import it.tidalwave.image.EditableImage;
import it.tidalwave.image.Quality;
import it.tidalwave.image.jai.ImplementationFactoryJAI;
import it.tidalwave.image.java2d.ImplementationFactoryJ2D;
import it.tidalwave.image.op.ConvertToBufferedImageOp;
import it.tidalwave.image.op.CropOp;
import it.tidalwave.image.op.Operation;
import it.tidalwave.image.op.ReadOp;
import it.tidalwave.image.op.RotateQuadrantOp;
import it.tidalwave.image.op.ScaleOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.platform.picture.core.ImageUtils;
import org.nuxeo.runtime.api.Framework;

public class MistralImageUtils
implements ImageUtils {
    private static final Log log = LogFactory.getLog(MistralImageUtils.class);
    private static final double QUALITY_SCALE = 0.25;

    @Override
    @Deprecated
    public InputStream crop(InputStream in, int x, int y, int width, int height) {
        try {
            ImplementationFactoryJAI.getInstance();
            ImplementationFactoryJ2D.getInstance().unregisterImplementation(ScaleOp.class);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            EditableImage image = EditableImage.create((ReadOp)new ReadOp((Object)in, ReadOp.Type.IMAGE));
            image = image.execute2((Operation)new CropOp(x, y, width, height));
            File resultFile = this.writeJpegFile(image);
            if (resultFile != null) {
                FileInputStream fis = new FileInputStream(resultFile);
                Framework.trackFile((File)resultFile, (Object)fis);
                return fis;
            }
        }
        catch (IOException e) {
            log.error((Object)"Fail to crop image", (Throwable)e);
        }
        return null;
    }

    @Override
    @Deprecated
    public InputStream resize(InputStream in, int width, int height) {
        try {
            ImplementationFactoryJAI.getInstance();
            ImplementationFactoryJ2D.getInstance().unregisterImplementation(ScaleOp.class);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            EditableImage image = EditableImage.create((ReadOp)new ReadOp((Object)in, ReadOp.Type.IMAGE));
            int imageWidth = image.getWidth();
            int imageHeight = image.getHeight();
            if (imageWidth <= width && imageHeight <= height) {
                return null;
            }
            double scale = imageWidth * height >= imageHeight * width ? (double)width / (double)imageWidth : (double)height / (double)imageHeight;
            while (scale < 0.25) {
                imageWidth = (image = image.execute2((Operation)new ScaleOp(0.25, Quality.BEST))).getWidth();
                if (imageWidth * height >= (imageHeight = image.getHeight()) * width) {
                    scale = (double)width / (double)imageWidth;
                    continue;
                }
                scale = (double)height / (double)imageHeight;
            }
            File resultFile = this.writeJpegFile(image = image.execute2((Operation)new ScaleOp(scale, Quality.BEST)));
            if (resultFile != null) {
                FileInputStream fis = new FileInputStream(resultFile);
                Framework.trackFile((File)resultFile, (Object)fis);
                return fis;
            }
        }
        catch (IOException e) {
            log.error((Object)"Fail to resize image", (Throwable)e);
        }
        return null;
    }

    @Override
    @Deprecated
    public InputStream rotate(InputStream in, int angle) {
        try {
            EditableImage image = EditableImage.create((ReadOp)new ReadOp((Object)in, ReadOp.Type.IMAGE));
            image = image.execute2((Operation)new RotateQuadrantOp(angle));
            File resultFile = this.writeJpegFile(image);
            if (resultFile != null) {
                FileInputStream fis = new FileInputStream(resultFile);
                Framework.trackFile((File)resultFile, (Object)fis);
                return fis;
            }
        }
        catch (IOException e) {
            log.error((Object)"Fail to rotate image", (Throwable)e);
        }
        return null;
    }

    @Override
    public Blob crop(Blob blob, int x, int y, int width, int height) {
        try {
            ImplementationFactoryJAI.getInstance();
            ImplementationFactoryJ2D.getInstance().unregisterImplementation(ScaleOp.class);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            EditableImage image = EditableImage.create((ReadOp)new ReadOp((Object)blob.getStream(), ReadOp.Type.IMAGE));
            image = image.execute2((Operation)new CropOp(x, y, width, height));
            File resultFile = this.writeJpegFile(image);
            if (resultFile != null) {
                FileBlob resultBlob = new FileBlob(resultFile);
                Framework.trackFile((File)resultFile, (Object)resultBlob);
                return resultBlob;
            }
        }
        catch (IOException e) {
            log.error((Object)"Fail to crop image", (Throwable)e);
        }
        return null;
    }

    @Override
    public Blob resize(Blob blob, String finalFormat, int width, int height, int depth) {
        try {
            ImplementationFactoryJAI.getInstance();
            ImplementationFactoryJ2D.getInstance().unregisterImplementation(ScaleOp.class);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            EditableImage image = EditableImage.create((ReadOp)new ReadOp((Object)blob.getStream(), ReadOp.Type.IMAGE));
            int imageWidth = image.getWidth();
            int imageHeight = image.getHeight();
            if (imageWidth <= width && imageHeight <= height) {
                return null;
            }
            double scale = imageWidth * height >= imageHeight * width ? (double)width / (double)imageWidth : (double)height / (double)imageHeight;
            while (scale < 0.25) {
                imageWidth = (image = image.execute2((Operation)new ScaleOp(0.25, Quality.BEST))).getWidth();
                if (imageWidth * height >= (imageHeight = image.getHeight()) * width) {
                    scale = (double)width / (double)imageWidth;
                    continue;
                }
                scale = (double)height / (double)imageHeight;
            }
            File resultFile = this.writeJpegFile(image = image.execute2((Operation)new ScaleOp(scale, Quality.BEST)));
            if (resultFile != null) {
                FileBlob resultBlob = new FileBlob(resultFile);
                Framework.trackFile((File)resultFile, (Object)resultBlob);
                return resultBlob;
            }
        }
        catch (IOException e) {
            log.error((Object)"Fail to resize image", (Throwable)e);
        }
        return null;
    }

    @Override
    public Blob rotate(Blob blob, int angle) {
        try {
            EditableImage image = EditableImage.create((ReadOp)new ReadOp((Object)blob.getStream(), ReadOp.Type.IMAGE));
            image = image.execute2((Operation)new RotateQuadrantOp(angle));
            File resultFile = this.writeJpegFile(image);
            if (resultFile != null) {
                FileBlob resultBlob = new FileBlob(resultFile);
                Framework.trackFile((File)resultFile, (Object)resultBlob);
                return resultBlob;
            }
        }
        catch (IOException e) {
            log.error((Object)"Fail to rotate image", (Throwable)e);
        }
        return null;
    }

    private File writeJpegFile(EditableImage image) {
        BufferedImage bimage = ((ConvertToBufferedImageOp)image.execute((Operation)new ConvertToBufferedImageOp())).getBufferedImage();
        if (bimage != null) {
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType("image/jpeg");
            while (iterator.hasNext()) {
                try {
                    ImageWriter writer = iterator.next();
                    ImageWriteParam writerParams = writer.getDefaultWriteParam();
                    if (writerParams.canWriteCompressed()) {
                        writerParams.setCompressionMode(2);
                        writerParams.setCompressionQuality(1.0f);
                    }
                    File resultFile = File.createTempFile("tmp", ".jpeg");
                    writer.setOutput(ImageIO.createImageOutputStream(resultFile));
                    writer.write(null, new IIOImage(bimage, null, null), writerParams);
                    return resultFile;
                }
                catch (IOException e) {
                }
            }
        }
        return null;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }
}

