/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl.dataobjects;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractExtensionData;

public class ContentStreamImpl
extends AbstractExtensionData
implements ContentStream {
    private String filename;
    private BigInteger length;
    private String mimeType;
    private InputStream stream;

    public ContentStreamImpl() {
    }

    public ContentStreamImpl(String filename, BigInteger length, String mimetype, InputStream stream) {
        this.setLength(length);
        this.setMimeType(mimetype);
        this.setFileName(filename);
        this.setStream(stream);
    }

    public ContentStreamImpl(String filename, String mimetype, String string) {
        byte[] bytes;
        try {
            bytes = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            bytes = string.getBytes();
        }
        this.setLength(BigInteger.valueOf(bytes.length));
        this.setMimeType(mimetype);
        this.setFileName(filename);
        this.setStream(new ByteArrayInputStream(bytes));
    }

    public String getFileName() {
        return this.filename;
    }

    public void setFileName(String filename) {
        this.filename = filename;
    }

    public long getLength() {
        return this.length == null ? -1L : this.length.longValue();
    }

    public BigInteger getBigLength() {
        return this.length;
    }

    public void setLength(BigInteger length) {
        this.length = length;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public void setStream(InputStream stream) {
        this.stream = stream;
    }

    public String toString() {
        return "ContentStream [filename=" + this.filename + ", length=" + this.length + ", MIME type=" + this.mimeType + ", has stream=" + (this.stream != null) + "]" + super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            super.finalize();
        }
    }
}

