/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.ContrastEnhancer;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Rectangle;

public class RankFilters
implements ExtendedPlugInFilter,
DialogListener {
    public static final int MEAN = 0;
    public static final int MIN = 1;
    public static final int MAX = 2;
    public static final int VARIANCE = 3;
    public static final int MEDIAN = 4;
    public static final int OUTLIERS = 5;
    public static final int DESPECKLE = 6;
    private static final int BRIGHT_OUTLIERS = 0;
    private static final int DARK_OUTLIERS = 1;
    private static final String[] outlierStrings = new String[]{"Bright", "Dark"};
    private static double radius = 2.0;
    private static double threshold = 50.0;
    private static int whichOutliers = 0;
    private int filterType = 4;
    int flags = 16834655;
    private ImagePlus imp;
    private int nPasses = 1;
    private int pass;
    protected int kRadius;
    protected int kNPoints;
    protected int[] lineRadius;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        if (arg.equals("mean")) {
            this.filterType = 0;
        } else if (arg.equals("min")) {
            this.filterType = 1;
        } else if (arg.equals("max")) {
            this.filterType = 2;
        } else if (arg.equals("variance")) {
            this.filterType = 3;
        } else if (arg.equals("median")) {
            this.filterType = 4;
        } else if (arg.equals("outliers")) {
            this.filterType = 5;
        } else if (arg.equals("despeckle")) {
            this.filterType = 6;
        } else {
            if (arg.equals("masks")) {
                this.showMasks();
                return 4096;
            }
            IJ.error("RankFilters", "Argument missing or undefined: " + arg);
            return 4096;
        }
        return this.flags;
    }

    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        if (this.filterType == 6) {
            this.filterType = 4;
            this.makeKernel(1.0);
        } else {
            int digits;
            GenericDialog gd = new GenericDialog(command + "...");
            gd.addNumericField("Radius", radius, 1, 6, "pixels");
            int n = digits = imp.getType() == 2 ? 2 : 0;
            if (this.filterType == 5) {
                gd.addNumericField("Threshold", threshold, digits);
                gd.addChoice("Which Outliers", outlierStrings, outlierStrings[whichOutliers]);
            }
            gd.addPreviewCheckbox(pfr);
            gd.addDialogListener(this);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return 4096;
            }
            IJ.register(this.getClass());
        }
        return IJ.setupDialog(imp, this.flags);
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        radius = gd.getNextNumber();
        if (this.filterType == 5) {
            threshold = gd.getNextNumber();
            whichOutliers = gd.getNextChoiceIndex();
        }
        if (gd.invalidNumber() || radius < 0.0 || radius > 1000.0 || this.filterType == 5 && threshold < 0.0) {
            return false;
        }
        this.makeKernel(radius);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ImageProcessor ip) {
        int kRadius;
        int[] lineRadius;
        RankFilters rankFilters = this;
        synchronized (rankFilters) {
            lineRadius = (int[])this.lineRadius.clone();
            kRadius = this.kRadius;
            int kNPoints = this.kNPoints;
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        ++this.pass;
        this.doFiltering((FloatProcessor)ip, kRadius, lineRadius, this.filterType, whichOutliers, (float)threshold);
        if (this.imp != null && this.imp.getBitDepth() != 24 && this.imp.getRoi() == null && this.filterType == 3) {
            new ContrastEnhancer().stretchHistogram(this.imp.getProcessor(), 0.5);
        }
    }

    public void doFiltering(FloatProcessor ip, int kRadius, int[] lineRadius, int filterType, int whichOutliers, float threshold) {
        float sign;
        if (this.imp != null && IJ.escapePressed()) {
            return;
        }
        boolean minOrMax = filterType == 1 || filterType == 2;
        boolean minOrMaxOrOutliers = minOrMax || filterType == 5;
        boolean sumFilter = filterType == 0 || filterType == 3;
        boolean medianFilter = filterType == 4 || filterType == 5;
        double[] sums = sumFilter ? new double[2] : null;
        float[] medianBuf1 = medianFilter ? new float[this.kNPoints] : null;
        float[] medianBuf2 = medianFilter ? new float[this.kNPoints] : null;
        float f = sign = filterType == 1 ? -1.0f : 1.0f;
        if (filterType == 5) {
            sign = ip.isInvertedLut() == (whichOutliers == 1) ? -1.0f : 1.0f;
        }
        float[] pixels = (float[])ip.getPixels();
        int width = ip.getWidth();
        int height = ip.getHeight();
        Rectangle roi = ip.getRoi();
        int xmin = roi.x - kRadius;
        int xEnd = roi.x + roi.width;
        int xmax = xEnd + kRadius;
        int kSize = 2 * kRadius + 1;
        int cacheWidth = xmax - xmin;
        int xminInside = xmin > 0 ? xmin : 0;
        int xmaxInside = xmax < width ? xmax : width;
        int widthInside = xmaxInside - xminInside;
        boolean smallKernel = kRadius < 2;
        float[] cache = new float[cacheWidth * kSize];
        int iCache = 0;
        for (int y = roi.y - kRadius; y < roi.y + kRadius; ++y) {
            int x = xmin;
            while (x < xmax) {
                cache[iCache] = pixels[(x < 0 ? 0 : (x >= width ? width - 1 : x)) + width * (y < 0 ? 0 : (y >= height ? height - 1 : y))];
                ++x;
                ++iCache;
            }
        }
        int nextLineInCache = 2 * kRadius;
        float median = cache[0];
        Thread thread = Thread.currentThread();
        long lastTime = System.currentTimeMillis();
        for (int y = roi.y; y < roi.y + roi.height; ++y) {
            int ynext;
            long time = System.currentTimeMillis();
            if (time - lastTime > 100L) {
                lastTime = time;
                if (thread.isInterrupted()) {
                    return;
                }
                this.showProgress((double)y / (double)roi.height);
                if (this.imp != null && IJ.escapePressed()) {
                    ip.reset();
                    ImageProcessor originalIp = this.imp.getProcessor();
                    if (originalIp.getNChannels() > 1) {
                        originalIp.reset();
                    }
                    return;
                }
            }
            if ((ynext = y + kRadius) >= height) {
                ynext = height - 1;
            }
            float leftpxl = pixels[width * ynext];
            float rightpxl = pixels[width - 1 + width * ynext];
            int iCache2 = cacheWidth * nextLineInCache;
            int x = xmin;
            while (x < 0) {
                cache[iCache2] = leftpxl;
                ++x;
                ++iCache2;
            }
            System.arraycopy(pixels, xminInside + width * ynext, cache, iCache2, widthInside);
            iCache2 += widthInside;
            x = width;
            while (x < xmax) {
                cache[iCache2] = rightpxl;
                ++x;
                ++iCache2;
            }
            nextLineInCache = (nextLineInCache + 1) % kSize;
            float max = 0.0f;
            boolean fullCalculation = true;
            int x2 = roi.x;
            int p = x2 + y * width;
            int xCache0 = kRadius;
            while (x2 < xEnd) {
                if (fullCalculation) {
                    fullCalculation = smallKernel;
                    if (minOrMaxOrOutliers) {
                        max = this.getAreaMax(cache, cacheWidth, xCache0, lineRadius, kSize, 0, -3.4028235E38f, sign);
                    }
                    if (minOrMax) {
                        pixels[p] = max * sign;
                    } else if (sumFilter) {
                        this.getAreaSums(cache, cacheWidth, xCache0, lineRadius, kSize, sums);
                    }
                } else if (minOrMaxOrOutliers) {
                    float newPointsMax = this.getSideMax(cache, cacheWidth, xCache0, lineRadius, kSize, true, sign);
                    if (newPointsMax >= max) {
                        max = newPointsMax;
                    } else {
                        float removedPointsMax = this.getSideMax(cache, cacheWidth, xCache0, lineRadius, kSize, false, sign);
                        if (removedPointsMax >= max) {
                            max = this.getAreaMax(cache, cacheWidth, xCache0, lineRadius, kSize, 1, newPointsMax, sign);
                        }
                    }
                    if (minOrMax) {
                        pixels[p] = max * sign;
                    }
                } else if (sumFilter) {
                    this.addSideSums(cache, cacheWidth, xCache0, lineRadius, kSize, sums);
                }
                if (medianFilter) {
                    if (filterType == 4 || pixels[p] * sign + threshold < max) {
                        median = this.getMedian(cache, cacheWidth, xCache0, lineRadius, kSize, medianBuf1, medianBuf2, median);
                        if (filterType == 4 || pixels[p] * sign + threshold < median * sign) {
                            pixels[p] = median;
                        }
                    }
                } else if (sumFilter) {
                    pixels[p] = filterType == 0 ? (float)(sums[0] / (double)this.kNPoints) : (float)((sums[1] - sums[0] * sums[0] / (double)this.kNPoints) / (double)this.kNPoints);
                }
                ++x2;
                ++p;
                ++xCache0;
            }
            int newLineRadius0 = lineRadius[kSize - 1];
            System.arraycopy(lineRadius, 0, lineRadius, 1, kSize - 1);
            lineRadius[0] = newLineRadius0;
        }
    }

    public void rank(ImageProcessor ip, double radius, int rankType) {
        this.makeKernel(radius);
        FloatProcessor fp = ip.toFloat(0, null);
        this.doFiltering(fp, this.kRadius, this.lineRadius, rankType, 0, 50.0f);
        ip.setPixels(0, fp);
    }

    private float getAreaMax(float[] cache, int cacheWidth, int xCache0, int[] lineRadius, int kSize, int ignoreRight, float max, float sign) {
        for (int y = 0; y < kSize; ++y) {
            int x = xCache0 - lineRadius[y];
            int iCache = y * cacheWidth + x;
            while (x <= xCache0 + lineRadius[y] - ignoreRight) {
                float v = cache[iCache] * sign;
                if (max < v) {
                    max = v;
                }
                ++x;
                ++iCache;
            }
        }
        return max;
    }

    private float getSideMax(float[] cache, int cacheWidth, int xCache0, int[] lineRadius, int kSize, boolean isRight, float sign) {
        float max = -3.4028235E38f;
        for (int y = 0; y < kSize; ++y) {
            int x = isRight ? xCache0 + lineRadius[y] : xCache0 - lineRadius[y] - 1;
            int iCache = y * cacheWidth + x;
            float v = cache[iCache] * sign;
            if (!(max < v)) continue;
            max = v;
        }
        return max;
    }

    private void getAreaSums(float[] cache, int cacheWidth, int xCache0, int[] lineRadius, int kSize, double[] sums) {
        double sum = 0.0;
        double sum2 = 0.0;
        for (int y = 0; y < kSize; ++y) {
            int x = xCache0 - lineRadius[y];
            int iCache = y * cacheWidth + x;
            while (x <= xCache0 + lineRadius[y]) {
                float v = cache[iCache];
                sum += (double)v;
                sum2 += (double)(v * v);
                ++x;
                ++iCache;
            }
        }
        sums[0] = sum;
        sums[1] = sum2;
    }

    private void addSideSums(float[] cache, int cacheWidth, int xCache0, int[] lineRadius, int kSize, double[] sums) {
        double sum = 0.0;
        double sum2 = 0.0;
        for (int y = 0; y < kSize; ++y) {
            int iCache0 = y * cacheWidth + xCache0;
            float v = cache[iCache0 + lineRadius[y]];
            sum += (double)v;
            sum2 += (double)(v * v);
            v = cache[iCache0 - lineRadius[y] - 1];
            sum -= (double)v;
            sum2 -= (double)(v * v);
        }
        sums[0] = sums[0] + sum;
        sums[1] = sums[1] + sum2;
    }

    private float getMedian(float[] cache, int cacheWidth, int xCache0, int[] lineRadius, int kSize, float[] aboveBuf, float[] belowBuf, float guess) {
        int half = this.kNPoints / 2;
        int nAbove = 0;
        int nBelow = 0;
        for (int y = 0; y < kSize; ++y) {
            int x = xCache0 - lineRadius[y];
            int iCache = y * cacheWidth + x;
            while (x <= xCache0 + lineRadius[y]) {
                float v = cache[iCache];
                if (v > guess) {
                    aboveBuf[nAbove] = v;
                    ++nAbove;
                } else if (v < guess) {
                    belowBuf[nBelow] = v;
                    ++nBelow;
                }
                ++x;
                ++iCache;
            }
        }
        if (nAbove > half) {
            return RankFilters.findNthLowestNumber(aboveBuf, nAbove, nAbove - half - 1);
        }
        if (nBelow > half) {
            return RankFilters.findNthLowestNumber(belowBuf, nBelow, half);
        }
        return guess;
    }

    public static float findNthLowestNumber(float[] buf, int bufLength, int n) {
        int l = 0;
        int m = bufLength - 1;
        float med = buf[n];
        while (l < m) {
            int i = l;
            int j = m;
            while (true) {
                if (buf[i] < med) {
                    ++i;
                    continue;
                }
                while (med < buf[j]) {
                    --j;
                }
                float dum = buf[j];
                buf[j] = buf[i];
                buf[i] = dum;
                if (--j < n || ++i > n) break;
            }
            if (j < n) {
                l = i;
            }
            if (n < i) {
                m = j;
            }
            med = buf[n];
        }
        return med;
    }

    public synchronized void makeKernel(double radius) {
        if (radius >= 1.5 && radius < 1.75) {
            radius = 1.75;
        } else if (radius >= 2.5 && radius < 2.85) {
            radius = 2.85;
        }
        int r2 = (int)(radius * radius) + 1;
        this.kRadius = (int)Math.sqrt((double)r2 + 1.0E-10);
        this.lineRadius = new int[2 * this.kRadius + 1];
        this.lineRadius[this.kRadius] = this.kRadius;
        this.kNPoints = 2 * this.kRadius + 1;
        for (int y = 1; y <= this.kRadius; ++y) {
            int dx;
            this.lineRadius[this.kRadius + y] = dx = (int)Math.sqrt((double)(r2 - y * y) + 1.0E-10);
            this.lineRadius[this.kRadius - y] = dx;
            this.kNPoints += 4 * dx + 2;
        }
    }

    void showMasks() {
        int w = 150;
        int h = 150;
        ImageStack stack = new ImageStack(w, h);
        for (double r = 0.5; r < 50.0; r += 0.5) {
            FloatProcessor ip = new FloatProcessor(w, h, new int[w * h]);
            float[] pixels = (float[])((ImageProcessor)ip).getPixels();
            this.makeKernel(r);
            int i = 0;
            int y = h / 2 - this.kRadius;
            while (i < 2 * this.kRadius + 1) {
                int x = w / 2 - this.lineRadius[i];
                int p = x + y * w;
                while (x <= w / 2 + this.lineRadius[i]) {
                    pixels[p] = 1.0f;
                    ++x;
                    ++p;
                }
                ++i;
                ++y;
            }
            stack.addSlice("radius=" + r + ", size=" + (2 * this.kRadius + 1), ip);
        }
        new ImagePlus("Masks", stack).show();
    }

    public void setNPasses(int nPasses) {
        this.nPasses = nPasses;
        this.pass = 0;
    }

    private void showProgress(double percent) {
        percent = (double)(this.pass - 1) / (double)this.nPasses + percent / (double)this.nPasses;
        IJ.showProgress(percent);
    }
}

