/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.virtualnavigation.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.nuxeo.ecm.virtualnavigation.action.NavTreeDescriptor;
import org.nuxeo.ecm.webapp.directory.DirectoryTreeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class NavTreeService
extends DefaultComponent {
    public static String NAVTREE_EP = "navigationTree";
    protected List<NavTreeDescriptor> descriptors;
    protected boolean directoryTreesFetched;

    public List<NavTreeDescriptor> getTreeDescriptors() {
        this.maybeFetchDirectoryTrees();
        return this.descriptors;
    }

    protected synchronized void maybeFetchDirectoryTrees() {
        if (this.directoryTreesFetched) {
            return;
        }
        DirectoryTreeService directoryTreeService = (DirectoryTreeService)Framework.getRuntime().getComponent(DirectoryTreeService.NAME);
        if (directoryTreeService == null) {
            return;
        }
        List treeNames = directoryTreeService.getNavigationDirectoryTrees();
        for (String dTreeName : treeNames) {
            this.descriptors.add(new NavTreeDescriptor(dTreeName, "label." + dTreeName, true));
        }
        this.directoryTreesFetched = true;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (NAVTREE_EP.equals(extensionPoint)) {
            this.descriptors.add((NavTreeDescriptor)contribution);
            Collections.sort(this.descriptors, NavTreeDescriptorOrderComparator.INSTANCE);
        }
    }

    public void activate(ComponentContext context) throws Exception {
        this.directoryTreesFetched = false;
        this.descriptors = new ArrayList<NavTreeDescriptor>();
    }

    public static class NavTreeDescriptorOrderComparator
    implements Comparator<NavTreeDescriptor> {
        public static final NavTreeDescriptorOrderComparator INSTANCE = new NavTreeDescriptorOrderComparator();

        @Override
        public int compare(NavTreeDescriptor descriptor1, NavTreeDescriptor descriptor2) {
            return descriptor1.getOrder() - descriptor2.getOrder();
        }
    }
}

