/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl.plugins;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.io.DocumentTranslationMap;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.AbstractDocumentWriter;
import org.nuxeo.ecm.core.io.impl.DWord;
import org.nuxeo.ecm.core.io.impl.DocumentTranslationMapImpl;

public class NuxeoArchiveWriter
extends AbstractDocumentWriter {
    protected ZipOutputStream out;

    public NuxeoArchiveWriter(File destination) throws IOException {
        this(new BufferedOutputStream(new FileOutputStream(destination)), -1);
    }

    public NuxeoArchiveWriter(File destination, int compressionLevel) throws IOException {
        this(new BufferedOutputStream(new FileOutputStream(destination)), compressionLevel);
    }

    public NuxeoArchiveWriter(OutputStream out) throws IOException {
        this(new ZipOutputStream(out), -1);
    }

    public NuxeoArchiveWriter(OutputStream out, int compressionLevel) throws IOException {
        this(new ZipOutputStream(out), compressionLevel);
    }

    public NuxeoArchiveWriter(ZipOutputStream out) throws IOException {
        this(out, -1);
    }

    public NuxeoArchiveWriter(ZipOutputStream out, int compressionLevel) throws IOException {
        this.out = out;
        this.out.setLevel(compressionLevel);
        this.setComment("");
        this.writeMarker();
    }

    public void setComment(String comment) {
        if (this.out != null) {
            this.out.setComment("=========== Nuxeo ECM Archive v. 1.0.0 ===========\r\n\r\n" + comment);
        }
    }

    @Override
    public DocumentTranslationMap write(ExportedDocument doc) throws IOException {
        String path = doc.getPath().toString();
        this.writeDocument(path, doc);
        DocumentLocation oldLoc = doc.getSourceLocation();
        String oldServerName = oldLoc.getServerName();
        DocumentRef oldDocRef = oldLoc.getDocRef();
        DocumentTranslationMapImpl map = new DocumentTranslationMapImpl(oldServerName, oldServerName);
        map.put(oldDocRef, oldDocRef);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.out = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDocument(String path, ExportedDocument doc) throws IOException {
        ZipEntry entry;
        if (path.equals("/") || path.length() == 0) {
            path = "";
        } else {
            path = path + '/';
            entry = new ZipEntry(path);
            entry.setExtra(new DWord(doc.getFilesCount()).getBytes());
            this.out.putNextEntry(entry);
            this.out.closeEntry();
        }
        entry = new ZipEntry(path + "document.xml");
        this.out.putNextEntry(entry);
        try {
            NuxeoArchiveWriter.writeXML(doc.getDocument(), this.out);
        }
        finally {
            this.out.closeEntry();
        }
        for (Map.Entry<String, Document> ext : doc.getDocuments().entrySet()) {
            String fileName = ext.getKey() + ".xml";
            entry = new ZipEntry(path + fileName);
            this.out.putNextEntry(entry);
            try {
                NuxeoArchiveWriter.writeXML(ext.getValue(), this.out);
            }
            finally {
                this.out.closeEntry();
            }
        }
        Map<String, Blob> blobs = doc.getBlobs();
        for (Map.Entry<String, Blob> blobEntry : blobs.entrySet()) {
            String fileName = blobEntry.getKey();
            entry = new ZipEntry(path + fileName);
            this.out.putNextEntry(entry);
            InputStream in = null;
            try {
                in = blobEntry.getValue().getStream();
                FileUtils.copy((InputStream)in, (OutputStream)this.out);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                this.out.closeEntry();
            }
        }
    }

    protected static void writeXML(Document doc, OutputStream out) throws IOException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        XMLWriter writer = new XMLWriter(out, format);
        writer.write(doc);
    }

    private void writeMarker() throws IOException {
        ZipEntry entry = new ZipEntry(".nuxeo-archive");
        this.out.putNextEntry(entry);
        this.out.closeEntry();
    }
}

