/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.formats;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.elements.ElementType;
import org.nuxeo.theme.engines.EngineType;
import org.nuxeo.theme.formats.Format;
import org.nuxeo.theme.formats.FormatType;
import org.nuxeo.theme.fragments.Fragment;
import org.nuxeo.theme.models.Model;
import org.nuxeo.theme.models.ModelType;
import org.nuxeo.theme.rendering.AbstractFilter;
import org.nuxeo.theme.rendering.FilterTypeFamily;
import org.nuxeo.theme.rendering.RenderingInfo;
import org.nuxeo.theme.resources.ResourceManager;
import org.nuxeo.theme.templates.TemplateEngineType;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.types.TypeRegistry;
import org.nuxeo.theme.views.View;
import org.nuxeo.theme.views.ViewType;

public class FormatFilter
extends AbstractFilter {
    private static final Log log = LogFactory.getLog(FormatFilter.class);
    private FormatType formatType;
    private final TypeRegistry typeRegistry = Manager.getTypeRegistry();

    @Override
    public FilterTypeFamily getFilterTypeFamily() {
        return FilterTypeFamily.FORMAT;
    }

    public FormatType getFormatType() {
        return this.formatType;
    }

    public void setFormatType(FormatType formatType) {
        this.formatType = formatType;
    }

    @Override
    public RenderingInfo process(RenderingInfo info, boolean cache) {
        EngineType engine = info.getEngine();
        TemplateEngineType templateEngineType = info.getTemplateEngine();
        String viewMode = info.getViewMode();
        Element element = info.getElement();
        ElementType elementType = element.getElementType();
        Model model = info.getModel();
        ModelType modelType = model == null ? null : model.getModelType();
        Format format = info.getFormat();
        View view = this.getView(format.getName(), engine, viewMode, elementType, modelType, this.formatType, templateEngineType);
        if (view == null) {
            if (model == null) {
                Fragment fragment;
                ModelType expectedModelType;
                if (element instanceof Fragment && (expectedModelType = (fragment = (Fragment)element).getFragmentType().getModelType()) != null) {
                    log.warn((Object)String.format("Fragment %s should have returned a model of type: %s", fragment.computeXPath(), expectedModelType.getTypeName()));
                }
            } else {
                log.warn((Object)String.format("No %s view named '%s' found for element %s (theme URL is: %s)", this.formatType.getTypeName(), format.getName(), element.computeXPath(), info.getThemeUrl().toString()));
            }
        } else {
            String markup = view.render(info);
            info.setMarkup(markup);
            URL themeUrl = info.getThemeUrl();
            ResourceManager resourceManager = Manager.getResourceManager();
            for (String resource : view.getViewType().getResources()) {
                resourceManager.addResource(resource, themeUrl);
            }
        }
        return info;
    }

    private View getView(String viewName, EngineType engine, String viewMode, ElementType elementType, ModelType modelType, FormatType formatType, TemplateEngineType templateEngineType) {
        String templateEngineName;
        String effectiveViewMode;
        String engineName;
        String modelTypeName;
        String effectiveViewName;
        String elementTypeName;
        String formatTypeName = formatType == null ? "*" : formatType.getTypeName();
        View view = this.getViewFor(formatTypeName, elementTypeName = elementType == null ? "*" : elementType.getTypeName(), effectiveViewName = viewName == null || viewName.equals("") ? "*" : viewName, modelTypeName = modelType == null ? "*" : modelType.getTypeName(), engineName = engine == null ? "default" : engine.getName(), effectiveViewMode = viewMode == null ? "*" : viewMode, templateEngineName = templateEngineType == null ? null : templateEngineType.getName());
        if (view == null && !"*".equals(elementTypeName)) {
            view = this.getViewFor(formatTypeName, "*", effectiveViewName, modelTypeName, engineName, effectiveViewMode, templateEngineName);
        }
        if (view == null && !"*".equals(modelTypeName)) {
            view = this.getViewFor(formatTypeName, elementTypeName, effectiveViewName, "*", engineName, effectiveViewMode, templateEngineName);
        }
        if (view == null && !"*".equals(elementTypeName) && !"*".equals(modelTypeName)) {
            view = this.getViewFor(formatTypeName, "*", effectiveViewName, "*", engineName, effectiveViewMode, templateEngineName);
        }
        if (view == null && !"*".equals(effectiveViewName)) {
            view = this.getViewFor(formatTypeName, elementTypeName, "*", "*", engineName, effectiveViewMode, templateEngineName);
        }
        return view;
    }

    private View getViewFor(String formatTypeName, String elementTypeName, String viewName, String modelTypeName, String engineName, String viewMode, String templateEngineName) {
        ViewType viewType = (ViewType)this.typeRegistry.lookup(TypeFamily.VIEW, ViewType.computeName(formatTypeName, elementTypeName, viewName, modelTypeName, engineName, viewMode, templateEngineName));
        if (viewType == null && !"*".equals(viewMode)) {
            viewType = (ViewType)this.typeRegistry.lookup(TypeFamily.VIEW, ViewType.computeName(formatTypeName, elementTypeName, viewName, modelTypeName, engineName, "*", templateEngineName));
        }
        if (viewType == null && !"default".equals(engineName)) {
            viewType = (ViewType)this.typeRegistry.lookup(TypeFamily.VIEW, ViewType.computeName(formatTypeName, elementTypeName, viewName, modelTypeName, "default", "*", templateEngineName));
        }
        return viewType == null ? null : viewType.getView();
    }
}

