/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.presets;

import org.nuxeo.theme.Manager;
import org.nuxeo.theme.Preview;
import org.nuxeo.theme.PreviewType;
import org.nuxeo.theme.presets.PresetType;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.types.TypeRegistry;

public class PresetInfo {
    final PresetType preset;

    public PresetInfo(PresetType preset) {
        this.preset = preset;
    }

    public String getName() {
        return this.preset.getName();
    }

    public String getEffectiveName() {
        return this.preset.getEffectiveName();
    }

    public String getId() {
        return this.preset.getTypeName();
    }

    public String getPreview() {
        String category = this.preset.getCategory();
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        PreviewType previewType = (PreviewType)typeRegistry.lookup(TypeFamily.PREVIEW, category);
        String previewClassName = previewType.getClassName();
        if (previewClassName == null) {
            return "";
        }
        Preview preview = null;
        try {
            preview = (Preview)Class.forName(previewClassName).newInstance();
        }
        catch (Exception e) {
            e.getStackTrace();
        }
        if (preview == null) {
            return "";
        }
        return preview.render(this.preset.getValue());
    }

    public String getValue() {
        return this.preset.getValue();
    }

    public String getCategory() {
        return this.preset.getCategory();
    }

    public String getLabel() {
        return this.preset.getLabel();
    }

    public String getDescription() {
        return this.preset.getDescription();
    }
}

