/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.presets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.elements.ThemeElement;
import org.nuxeo.theme.formats.styles.Style;
import org.nuxeo.theme.presets.CustomPresetType;
import org.nuxeo.theme.presets.PaletteParser;
import org.nuxeo.theme.presets.PresetType;
import org.nuxeo.theme.resources.ResourceManager;
import org.nuxeo.theme.themes.ThemeDescriptor;
import org.nuxeo.theme.themes.ThemeException;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.types.Type;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.types.TypeRegistry;

public class PresetManager {
    private static final Pattern manyPresetNamePattern = Pattern.compile(".*?\"(.*?)\".*?", 32);
    private static final Pattern presetNamePattern = Pattern.compile("^\"(.*?)\"$", 32);
    private static final Pattern globalPresetNamePattern = Pattern.compile("^\".*?\\((.*?)\\)\"$", 32);
    private static final Pattern customPresetNamePattern = Pattern.compile("^\"(.*?)\"$", 32);
    private static final Pattern remotePresetNamePattern = Pattern.compile("(.*?)\\s\\((.*?)\\s(\\w*?)\\)$", 32);
    private static final List<String> PRESET_CATEGORIES = Arrays.asList("color", "background", "font", "border");

    public static String extractPresetName(String themeName, String str) {
        Matcher customPresetNameMatcher;
        String s = str.trim();
        Matcher globalPresetNameMatcher = globalPresetNamePattern.matcher(s);
        if (globalPresetNameMatcher.find()) {
            Matcher presetMatcher = presetNamePattern.matcher(s);
            if (presetMatcher.find()) {
                return presetMatcher.group(1);
            }
        } else if (themeName != null && (customPresetNameMatcher = customPresetNamePattern.matcher(s)).find()) {
            return String.format("%s/%s", themeName, customPresetNameMatcher.group(1));
        }
        return null;
    }

    public static PresetType getPresetByName(String name) {
        return (PresetType)Manager.getTypeRegistry().lookup(TypeFamily.PRESET, name);
    }

    public static List<Type> getAllPresets() {
        return Manager.getTypeRegistry().getTypes(TypeFamily.PRESET);
    }

    public static List<PresetType> getGlobalPresets(String group, String category) {
        ArrayList<PresetType> presets = new ArrayList<PresetType>();
        for (Type type : PresetManager.getAllPresets()) {
            PresetType preset = (PresetType)type;
            if (category != null && !preset.getCategory().equals(category) || group != null && !preset.getGroup().equals(group) || preset instanceof CustomPresetType) continue;
            presets.add(preset);
        }
        return presets;
    }

    public static PresetType getCustomPreset(String themeName, String presetName) {
        return PresetManager.getPresetByName(String.format("%s/%s", themeName, presetName));
    }

    public static List<PresetType> getCustomPresets(String themeName) {
        return PresetManager.getCustomPresets(themeName, null);
    }

    public static List<PresetType> getCustomPresets(String themeName, String category) {
        ArrayList<PresetType> presets = new ArrayList<PresetType>();
        for (Type type : PresetManager.getAllPresets()) {
            PresetType preset = (PresetType)type;
            if (!(preset instanceof CustomPresetType) || category != null && !preset.getCategory().equals(category) || themeName != null && !preset.getGroup().equals(themeName)) continue;
            presets.add(preset);
        }
        return presets;
    }

    public static String resolvePresets(String themeName, String str) {
        String resourceBankName = null;
        ThemeDescriptor themeDescriptor = ThemeManager.getThemeDescriptorByThemeName(themeName);
        if (themeDescriptor != null) {
            resourceBankName = themeDescriptor.getResourceBankName();
        }
        Matcher m = manyPresetNamePattern.matcher(str.trim());
        StringBuilder sb = new StringBuilder();
        int end = 0;
        while (m.find()) {
            end = m.end(1) + 1;
            sb.append(str.substring(m.start(), m.start(1) - 1));
            String presetStr = String.format("\"%s\"", m.group(1));
            String presetName = PresetManager.extractPresetName(themeName, presetStr);
            if (presetName == null) {
                sb.append(presetStr);
                continue;
            }
            PresetType preset = PresetManager.getPresetByName(presetName);
            if (preset == null) {
                PresetManager.loadPaletteOf(resourceBankName, presetName);
            }
            if ((preset = PresetManager.getPresetByName(presetName)) == null) {
                sb.append(presetStr);
                continue;
            }
            sb.append(preset.getValue());
        }
        sb.append(str.substring(end));
        return sb.toString();
    }

    public static void loadPresetsUsedInStyle(String resourceBankName, Style style) {
        Properties properties = style.getAllProperties();
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            String propertyValue = (String)property.getValue();
            Matcher m = manyPresetNamePattern.matcher(propertyValue);
            while (m.find()) {
                PresetType preset;
                String presetStr = String.format("\"%s\"", m.group(1));
                String presetName = PresetManager.extractPresetName(null, presetStr);
                if (presetName == null || (preset = PresetManager.getPresetByName(presetName)) != null) continue;
                PresetManager.loadPaletteOf(resourceBankName, presetName);
            }
        }
    }

    public static void loadPaletteOf(String resourceBankName, String presetName) {
        if (resourceBankName == null) {
            return;
        }
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        Matcher resourceNameMatcher = remotePresetNamePattern.matcher(presetName);
        if (resourceNameMatcher.find()) {
            String content;
            String category = resourceNameMatcher.group(3);
            if (!PRESET_CATEGORIES.contains(category)) {
                return;
            }
            String collectionName = resourceNameMatcher.group(2);
            String resourceId = category;
            try {
                content = ResourceManager.getBankResource(resourceBankName, collectionName, "preset", resourceId);
            }
            catch (ThemeException e) {
                return;
            }
            String paletteName = String.format("%s %s", collectionName, category);
            Map<String, String> paletteEntries = PaletteParser.parseCsv(content);
            for (Map.Entry<String, String> entry : paletteEntries.entrySet()) {
                String value = PresetManager.resolvePresets(null, entry.getValue());
                PresetType preset = new PresetType(entry.getKey(), value, paletteName, category, "", "");
                typeRegistry.register(preset);
            }
        }
    }

    public static void createCustomPreset(String themeName, String presetName, String category, String value, String label, String description) {
        CustomPresetType preset = new CustomPresetType(presetName, value, themeName, category, label, description);
        Manager.getTypeRegistry().register(preset);
    }

    public static void editPreset(String themeName, String presetName, String value) {
        PresetType preset = PresetManager.getCustomPreset(themeName, presetName);
        preset.setValue(value);
    }

    public static void setPresetCategory(String themeName, String presetName, String category) {
        PresetType preset = PresetManager.getCustomPreset(themeName, presetName);
        preset.setCategory(category);
    }

    public static void renamePreset(String themeName, String oldName, String newName) throws ThemeException {
        if (newName.equals("")) {
            throw new ThemeException("Preset name cannot be empty");
        }
        PresetType preset = PresetManager.getCustomPreset(themeName, oldName);
        if (PresetManager.getCustomPreset(themeName, newName) != null) {
            throw new ThemeException("Preset name already taken: " + newName);
        }
        Manager.getTypeRegistry().unregister(preset);
        preset.setName(newName);
        Manager.getTypeRegistry().register(preset);
    }

    public static void deletePreset(String themeName, String presetName) throws ThemeException {
        PresetType preset = PresetManager.getCustomPreset(themeName, presetName);
        if (PresetManager.getCustomPreset(themeName, presetName) == null) {
            throw new ThemeException("Preset unknown: " + presetName);
        }
        Manager.getTypeRegistry().unregister(preset);
    }

    public static void clearCustomPresets(String themeName) {
        for (PresetType preset : PresetManager.getCustomPresets(themeName)) {
            Manager.getTypeRegistry().unregister(preset);
        }
    }

    public static List<String> getUnidentifiedPresetNames(String themeName) {
        ArrayList<String> names = new ArrayList<String>();
        ThemeManager themeManager = Manager.getThemeManager();
        for (Style style : themeManager.getStyles()) {
            ThemeElement theme;
            if (style.isNamed() ? !themeName.equals(themeManager.getThemeNameOfNamedObject(style)) : (theme = ThemeManager.getThemeOfFormat(style)) == null || !themeName.equals(theme.getName())) continue;
            for (Map.Entry<Object, Object> entry : style.getAllProperties().entrySet()) {
                String value = (String)entry.getValue();
                String s = value.trim();
                Matcher m = manyPresetNamePattern.matcher(value.trim());
                while (m.find()) {
                    PresetType preset;
                    String name = m.group(1);
                    String presetStr = String.format("\"%s\"", name);
                    String presetName = PresetManager.extractPresetName(themeName, presetStr);
                    if (presetName == null || globalPresetNamePattern.matcher(s).find() || (preset = PresetManager.getPresetByName(presetName)) != null || names.contains(name)) continue;
                    names.add(name);
                }
            }
        }
        return names;
    }
}

