/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.resources;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.theme.Utils;
import org.nuxeo.theme.resources.SkinInfo;
import org.nuxeo.theme.types.Type;
import org.nuxeo.theme.types.TypeFamily;

@XObject(value="bank")
public class ResourceBank
implements Type {
    private static final Log log = LogFactory.getLog(ResourceBank.class);
    @XNode(value="@name")
    public String name;
    private String connectionUrl;

    @XNode(value="@url")
    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = Framework.expandVars((String)connectionUrl);
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Override
    public String getTypeName() {
        return this.name;
    }

    @Override
    public TypeFamily getTypeFamily() {
        return TypeFamily.RESOURCE_BANK;
    }

    public boolean checkStatus() {
        byte[] status;
        String src = String.format("%s/status", this.connectionUrl);
        try {
            status = Utils.fetchUrl(new URL(src));
        }
        catch (Exception e) {
            return false;
        }
        return status != null && "OK".equals(new String(status));
    }

    public byte[] getResourceContent(String collectionName, String typeName, String resourceId) {
        String src = String.format("%s/%s/%s/%s", this.connectionUrl, URIUtils.quoteURIPathComponent((String)collectionName, (boolean)true), URIUtils.quoteURIPathComponent((String)typeName, (boolean)true), URIUtils.quoteURIPathComponent((String)resourceId, (boolean)true));
        log.debug((Object)("Loading THEME " + typeName + " from: " + src));
        try {
            return Utils.fetchUrl(new URL(src));
        }
        catch (Exception e) {
            log.error((Object)("Could not retrieve RESOURCE: " + src + " from THEME BANK: " + this.name));
            return null;
        }
    }

    public List<String> getImages() {
        ArrayList<String> paths = new ArrayList<String>();
        String src = String.format("%s/json/images", this.connectionUrl);
        String list = "";
        try {
            list = new String(Utils.fetchUrl(new URL(src)));
        }
        catch (Exception e) {
            log.error((Object)("Could not retrieve image list: " + src + " from THEME BANK: " + this.name));
            return paths;
        }
        for (Object path : JSONArray.fromObject((Object)list)) {
            paths.add((String)path);
        }
        return paths;
    }

    public List<String> getCollections() {
        ArrayList<String> paths = new ArrayList<String>();
        String src = String.format("%s/json/collections", this.connectionUrl);
        String list = "";
        try {
            list = new String(Utils.fetchUrl(new URL(src)));
        }
        catch (Exception e) {
            log.error((Object)("Could not retrieve collection list: " + src + " from THEME BANK: " + this.name));
            return paths;
        }
        for (Object path : JSONArray.fromObject((Object)list)) {
            paths.add((String)path);
        }
        return paths;
    }

    public List<SkinInfo> getSkins() {
        ArrayList<SkinInfo> skins = new ArrayList<SkinInfo>();
        String src = String.format("%s/json/skins", this.connectionUrl);
        String list = "";
        try {
            list = new String(Utils.fetchUrl(new URL(src)));
        }
        catch (Exception e) {
            log.error((Object)("Could not retrieve skin list: " + src + " from THEME BANK: " + this.name));
            return skins;
        }
        for (Object object : JSONArray.fromObject((Object)list)) {
            JSONObject skin = JSONObject.fromObject(object);
            skins.add(new SkinInfo((String)skin.get("name"), (String)skin.get("bank"), (String)skin.get("collection"), (String)skin.get("resource"), (String)skin.get("preview"), (Boolean)skin.get("base")));
        }
        return skins;
    }

    public String getName() {
        return this.name;
    }
}

