/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.themes;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.elements.ElementFactory;
import org.nuxeo.theme.elements.ElementFormatter;
import org.nuxeo.theme.elements.ThemeElement;
import org.nuxeo.theme.formats.Format;
import org.nuxeo.theme.formats.FormatFactory;
import org.nuxeo.theme.formats.styles.Style;
import org.nuxeo.theme.fragments.Fragment;
import org.nuxeo.theme.fragments.FragmentFactory;
import org.nuxeo.theme.nodes.NodeException;
import org.nuxeo.theme.perspectives.PerspectiveType;
import org.nuxeo.theme.presets.CustomPresetType;
import org.nuxeo.theme.presets.PresetManager;
import org.nuxeo.theme.properties.FieldIO;
import org.nuxeo.theme.themes.ThemeDescriptor;
import org.nuxeo.theme.themes.ThemeException;
import org.nuxeo.theme.themes.ThemeIOException;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.types.TypeRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ThemeParser {
    private static final Log log = LogFactory.getLog(ThemeParser.class);
    private static final String DOCROOT_NAME = "theme";
    private static final XPath xpath = XPathFactory.newInstance().newXPath();

    public static void registerTheme(ThemeDescriptor themeDescriptor, boolean preload) throws ThemeIOException {
        ThemeParser.registerTheme(themeDescriptor, null, preload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void registerTheme(ThemeDescriptor themeDescriptor, String xmlSource, boolean preload) throws ThemeIOException {
        String src = themeDescriptor.getSrc();
        InputStream in = null;
        try {
            if (xmlSource == null) {
                URL url = null;
                try {
                    url = new URL(src);
                }
                catch (MalformedURLException e) {
                    url = themeDescriptor.getContext() != null ? themeDescriptor.getContext().getResource(src) : Thread.currentThread().getContextClassLoader().getResource(src);
                }
                if (url == null) {
                    throw new ThemeIOException("Incorrect theme URL: " + src);
                }
                in = url.openStream();
            } else {
                in = new ByteArrayInputStream(xmlSource.getBytes());
            }
            ThemeParser.registerThemeFromInputStream(themeDescriptor, in, preload);
            return;
        }
        catch (FileNotFoundException e) {
            throw new ThemeIOException("File not found: " + src, e);
        }
        catch (IOException e) {
            throw new ThemeIOException("Could not open file: " + src, e);
        }
        catch (ThemeException e) {
            throw new ThemeIOException("Parsing error: " + src, e);
        }
        finally {
            if (in != null) {
                try {
                    try {
                        in.close();
                        in = null;
                    }
                    catch (IOException e) {
                        log.error((Object)e);
                        in = null;
                    }
                }
                catch (Throwable throwable) {
                    in = null;
                    throw throwable;
                }
            }
        }
    }

    private static void registerThemeFromInputStream(ThemeDescriptor themeDescriptor, InputStream in, boolean preload) throws ThemeIOException, ThemeException {
        Document document;
        DocumentBuilder db;
        String themeName = null;
        InputSource is = new InputSource(in);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setFeature("http://xml.org/sax/features/validation", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            log.debug((Object)"Could not set DTD non-validation feature");
        }
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ThemeIOException(e);
        }
        try {
            document = db.parse(is);
        }
        catch (SAXException e) {
            throw new ThemeIOException(e);
        }
        catch (IOException e) {
            throw new ThemeIOException(e);
        }
        Element docElem = document.getDocumentElement();
        if (!docElem.getNodeName().equals(DOCROOT_NAME)) {
            throw new ThemeIOException("No <theme> document tag found in " + in.toString() + ", ignoring the resource.");
        }
        themeName = docElem.getAttributes().getNamedItem("name").getNodeValue();
        if (!ThemeManager.validateThemeName(themeName)) {
            throw new ThemeIOException("Theme names may only contain lower-case alpha-numeric characters, underscores and hyphens: " + themeName);
        }
        themeDescriptor.setName(themeName);
        ThemeParser.loadTheme(themeDescriptor, docElem, preload);
    }

    private static void loadTheme(ThemeDescriptor themeDescriptor, Element docElem, boolean preload) throws ThemeException, ThemeIOException {
        Node templateEngines;
        String themeName;
        ThemeManager themeManager = Manager.getThemeManager();
        ThemeElement oldTheme = themeManager.getThemeByName(themeName = themeDescriptor.getName());
        if (oldTheme != null) {
            try {
                themeManager.destroyElement(oldTheme);
            }
            catch (NodeException e) {
                throw new ThemeIOException("Failed to destroy theme: " + themeName, e);
            }
        }
        Node baseNode = ThemeParser.getBaseNode(docElem);
        HashMap<Integer, String> inheritanceMap = new HashMap<Integer, String>();
        LinkedHashMap<Style, Map<String, Properties>> commonStyles = new LinkedHashMap<Style, Map<String, Properties>>();
        ThemeElement theme = (ThemeElement)ElementFactory.create(DOCROOT_NAME);
        theme.setName(themeName);
        Node description = docElem.getAttributes().getNamedItem("description");
        if (description != null) {
            theme.setDescription(description.getNodeValue());
        }
        String resourceBankName = null;
        Node resourceBankNode = docElem.getAttributes().getNamedItem("resource-bank");
        if (resourceBankNode != null) {
            resourceBankName = resourceBankNode.getNodeValue();
            themeDescriptor.setResourceBankName(resourceBankName);
        }
        if ((templateEngines = docElem.getAttributes().getNamedItem("template-engines")) != null) {
            themeDescriptor.setTemplateEngines(Arrays.asList(templateEngines.getNodeValue().split(",")));
        }
        if (preload) {
            ThemeParser.registerThemePages(theme, baseNode);
        } else {
            for (Node node : ThemeParser.getChildElementsByTagName(docElem, "presets")) {
                ThemeParser.parsePresets(theme, node);
            }
            for (Node node : ThemeParser.getChildElementsByTagName(docElem, "formats")) {
                ThemeParser.parseFormats(theme, docElem, commonStyles, inheritanceMap, node);
            }
            for (Map.Entry entry : inheritanceMap.entrySet()) {
                Integer styleUid = (Integer)entry.getKey();
                String inheritedStyleName = (String)entry.getValue();
                Format style = ThemeManager.getFormatById(styleUid);
                Format inheritedStyle = (Format)themeManager.getNamedObject(themeName, "style", inheritedStyleName);
                if (inheritedStyle == null) {
                    log.warn((Object)("Cannot make style inherit from unknown style : " + inheritedStyleName));
                    continue;
                }
                themeManager.makeFormatInherit(style, inheritedStyle);
            }
            ThemeParser.createCommonStyles(themeName, commonStyles);
            for (Node node : ThemeParser.getChildElementsByTagName(docElem, "properties")) {
                ThemeParser.parseProperties(docElem, node);
            }
            ThemeParser.parseLayout(theme, baseNode);
            for (Style style : themeManager.getNamedStyles(themeName)) {
                PresetManager.loadPresetsUsedInStyle(resourceBankName, style);
            }
            for (Style style : themeManager.getStyles(themeName)) {
                PresetManager.loadPresetsUsedInStyle(resourceBankName, style);
            }
        }
        if (preload) {
            log.info((Object)("Pre-loaded THEME: " + themeName));
            themeDescriptor.setLastLoaded(null);
        } else {
            log.info((Object)("Loaded THEME: " + themeName));
            themeDescriptor.setLastLoaded(new Date());
        }
        themeManager.registerTheme(theme);
    }

    public static void checkElementName(String name) throws ThemeIOException {
        if (!name.matches("[a-z0-9_\\-]+")) {
            throw new ThemeIOException("Element names may only contain lower-case alpha-numeric characters, digits, underscores and dashes.");
        }
    }

    public static void registerThemePages(org.nuxeo.theme.elements.Element parent, Node node) throws ThemeIOException, ThemeException {
        for (Node n : ThemeParser.getChildElements(node)) {
            String nodeName = n.getNodeName();
            NamedNodeMap attributes = n.getAttributes();
            if (!"page".equals(nodeName)) continue;
            org.nuxeo.theme.elements.Element elem = ElementFactory.create(nodeName);
            Node nameAttr = attributes.getNamedItem("name");
            if (nameAttr != null) {
                String elementName = nameAttr.getNodeValue();
                ThemeParser.checkElementName(elementName);
                elem.setName(elementName);
            }
            try {
                parent.addChild(elem);
            }
            catch (NodeException e) {
                throw new ThemeIOException("Failed to parse layout.", e);
            }
        }
    }

    public static void parseLayout(org.nuxeo.theme.elements.Element parent, Node node) throws ThemeIOException, ThemeException {
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        ThemeManager themeManager = Manager.getThemeManager();
        for (String formatName : typeRegistry.getTypeNames(TypeFamily.FORMAT)) {
            Format format = (Format)node.getUserData(formatName);
            if (format == null) continue;
            if (ElementFormatter.getElementsFor(format).isEmpty()) {
                ElementFormatter.setFormat(parent, format);
                continue;
            }
            Format duplicatedFormat = themeManager.duplicateFormat(format);
            ElementFormatter.setFormat(parent, duplicatedFormat);
        }
        Properties properties = (Properties)node.getUserData("properties");
        if (properties != null) {
            FieldIO.updateFieldsFromProperties(parent, properties);
        }
        for (Node n : ThemeParser.getChildElements(node)) {
            String description;
            org.nuxeo.theme.elements.Element elem;
            String nodeName = n.getNodeName();
            NamedNodeMap attributes = n.getAttributes();
            if ("fragment".equals(nodeName)) {
                String fragmentType = attributes.getNamedItem("type").getNodeValue();
                elem = FragmentFactory.create(fragmentType);
                if (elem == null) {
                    log.error((Object)("Could not create fragment: " + fragmentType));
                    continue;
                }
                Fragment fragment = (Fragment)elem;
                Node perspectives = attributes.getNamedItem("perspectives");
                if (perspectives != null) {
                    for (String perspectiveName : perspectives.getNodeValue().split(",")) {
                        PerspectiveType perspective = (PerspectiveType)typeRegistry.lookup(TypeFamily.PERSPECTIVE, perspectiveName);
                        if (perspective == null) {
                            log.warn((Object)("Could not find perspective: " + perspectiveName));
                            continue;
                        }
                        fragment.setVisibleInPerspective(perspective);
                    }
                }
            } else {
                elem = ElementFactory.create(nodeName);
            }
            if (elem == null) {
                throw new ThemeIOException("Could not parse node: " + nodeName);
            }
            Node nameAttr = attributes.getNamedItem("name");
            if (nameAttr != null) {
                String elementName = nameAttr.getNodeValue();
                if (!elementName.matches("[a-z0-9_\\-]+")) {
                    throw new ThemeIOException("Element names may only contain lower-case alpha-numeric characters, digits, underscores and dashes.");
                }
                elem.setName(elementName);
            }
            if ((description = ThemeParser.getCommentAssociatedTo(n)) != null) {
                elem.setDescription(description);
            }
            try {
                parent.addChild(elem);
            }
            catch (NodeException e) {
                throw new ThemeIOException("Failed to parse layout.", e);
            }
            ThemeParser.parseLayout(elem, n);
        }
    }

    public static void parsePresets(ThemeElement theme, Node node) {
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        String themeName = theme.getName();
        PresetManager.clearCustomPresets(themeName);
        for (Node n : ThemeParser.getChildElements(node)) {
            NamedNodeMap attrs = n.getAttributes();
            String name = attrs.getNamedItem("name").getNodeValue();
            String category = attrs.getNamedItem("category").getNodeValue();
            String value = PresetManager.resolvePresets(themeName, n.getTextContent());
            String group = themeName;
            Node labelAttr = attrs.getNamedItem("label");
            String label = "";
            if (labelAttr != null) {
                label = labelAttr.getNodeValue();
            }
            Node descriptionAttr = attrs.getNamedItem("description");
            String description = "";
            if (descriptionAttr != null) {
                description = descriptionAttr.getNodeValue();
            }
            CustomPresetType preset = new CustomPresetType(name, value, group, category, label, description);
            typeRegistry.register(preset);
        }
    }

    public static void parseFormats(ThemeElement theme, Element doc, Map<Style, Map<String, Properties>> commonStyles, Map<Integer, String> inheritanceMap, Node node) throws ThemeIOException, ThemeException {
        Node baseNode = ThemeParser.getBaseNode(doc);
        String themeName = theme.getName();
        String resourceBankName = null;
        ThemeDescriptor themeDescriptor = ThemeManager.getThemeDescriptorByThemeName(themeName);
        if (themeDescriptor != null) {
            resourceBankName = themeDescriptor.getResourceBankName();
        }
        ThemeManager themeManager = Manager.getThemeManager();
        for (Node n : ThemeParser.getChildElements(node)) {
            Format format;
            String nodeName = n.getNodeName();
            NamedNodeMap attributes = n.getAttributes();
            Node elementItem = attributes.getNamedItem("element");
            String elementXPath = null;
            if (elementItem != null) {
                elementXPath = elementItem.getNodeValue();
            }
            try {
                format = FormatFactory.create(nodeName);
            }
            catch (ThemeException e) {
                throw new ThemeIOException(e);
            }
            format.setProperties(ThemeParser.getPropertiesFromNode(n));
            String description = ThemeParser.getCommentAssociatedTo(n);
            if (description != null) {
                format.setDescription(description);
            }
            if ("widget".equals(nodeName)) {
                List<Node> viewNodes = ThemeParser.getChildElementsByTagName(n, "view");
                if (!viewNodes.isEmpty()) {
                    format.setName(viewNodes.get(0).getTextContent());
                }
            } else if (!"layout".equals(nodeName) && "style".equals(nodeName)) {
                Node remoteAttr;
                Node inheritedAttr;
                Node nameAttr = attributes.getNamedItem("name");
                String styleName = null;
                Style style = (Style)format;
                if (nameAttr != null) {
                    styleName = nameAttr.getNodeValue();
                    style.setName(styleName);
                    themeManager.setNamedObject(themeName, "style", style);
                }
                if ((inheritedAttr = attributes.getNamedItem("inherit")) != null) {
                    String inheritedName = inheritedAttr.getNodeValue();
                    if ("".equals(inheritedName)) continue;
                    inheritanceMap.put(style.getUid(), inheritedName);
                }
                if ((remoteAttr = attributes.getNamedItem("remote")) != null) {
                    Boolean remote = Boolean.valueOf(remoteAttr.getNodeValue());
                    if (style.isNamed()) {
                        style.setRemote(remote);
                    } else {
                        log.warn((Object)("Only named styles can be remote, ignoring remote attribute on" + style.getUid()));
                    }
                }
                if (styleName != null && elementXPath != null) {
                    log.warn((Object)("Style parser: named style '" + styleName + "' cannot have an 'element' attribute: '" + elementXPath + "'."));
                    continue;
                }
                List<Node> selectorNodes = ThemeParser.getChildElementsByTagName(n, "selector");
                if (style.isRemote() && resourceBankName != null) {
                    ThemeManager.loadRemoteStyle(resourceBankName, style);
                    if (!selectorNodes.isEmpty()) {
                        style.setCustomized(true);
                    }
                }
                for (Node selectorNode : selectorNodes) {
                    String selectorDescription;
                    NamedNodeMap attrs = selectorNode.getAttributes();
                    Node pathAttr = attrs.getNamedItem("path");
                    if (pathAttr == null) {
                        log.warn((Object)String.format("Style parser: named style '%s' has a selector with no path: ignored", styleName));
                        continue;
                    }
                    String path = pathAttr.getNodeValue();
                    String viewName = null;
                    Node viewAttr = attrs.getNamedItem("view");
                    if (viewAttr != null) {
                        viewName = viewAttr.getNodeValue();
                    }
                    if ((selectorDescription = ThemeParser.getCommentAssociatedTo(selectorNode)) != null) {
                        style.setSelectorDescription(path, viewName, selectorDescription);
                    }
                    if (elementXPath != null && (viewName == null || viewName.equals("*"))) {
                        log.warn((Object)("Style parser: trying to guess the view name for: " + elementXPath));
                        viewName = ThemeParser.guessViewNameFor(doc, elementXPath);
                        if (viewName == null) {
                            if (!commonStyles.containsKey(style)) {
                                commonStyles.put(style, new LinkedHashMap());
                            }
                            commonStyles.get(style).put(path, ThemeParser.getPropertiesFromNode(selectorNode));
                        }
                    }
                    if (styleName != null) {
                        if (viewName != null) {
                            log.info((Object)("Style parser: ignoring view name '" + viewName + "' in named style '" + styleName + "'."));
                        }
                        viewName = "*";
                    }
                    if (viewName == null) continue;
                    style.setPropertiesFor(viewName, path, ThemeParser.getPropertiesFromNode(selectorNode));
                }
            }
            themeManager.registerFormat(format);
            if (elementXPath == null) continue;
            if ("".equals(elementXPath)) {
                baseNode.setUserData(nodeName, format, null);
                continue;
            }
            for (Node element : ThemeParser.getNodesByXPath(baseNode, elementXPath)) {
                element.setUserData(nodeName, format, null);
            }
        }
    }

    public static void createCommonStyles(String themeName, Map<Style, Map<String, Properties>> commonStyles) throws ThemeException {
        ThemeManager themeManager = Manager.getThemeManager();
        int count = 1;
        for (Style parent : commonStyles.keySet()) {
            Style s = (Style)FormatFactory.create("style");
            String name = "";
            while (themeManager.getNamedObject(themeName, "style", name = String.format("common style %s", count)) != null) {
                ++count;
            }
            s.setName(name);
            themeManager.registerFormat(s);
            themeManager.setNamedObject(themeName, "style", s);
            Map<String, Properties> map = commonStyles.get(parent);
            for (Map.Entry<String, Properties> entry : map.entrySet()) {
                s.setPropertiesFor("*", entry.getKey(), entry.getValue());
            }
            Style ancestor = (Style)ThemeManager.getAncestorFormatOf(parent);
            if (ancestor != null) {
                themeManager.makeFormatInherit(s, ancestor);
            }
            themeManager.makeFormatInherit(parent, s);
            log.info((Object)("Created extra style: " + s.getName()));
        }
    }

    public static void parseProperties(Element doc, Node node) throws ThemeIOException {
        NamedNodeMap attributes = node.getAttributes();
        Node elementAttr = attributes.getNamedItem("element");
        if (elementAttr == null) {
            throw new ThemeIOException("<properties> node has no 'element' attribute.");
        }
        String elementXPath = elementAttr.getNodeValue();
        Node baseNode = ThemeParser.getBaseNode(doc);
        Node element = null;
        try {
            element = (Node)xpath.evaluate(elementXPath, baseNode, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new ThemeIOException(e);
        }
        if (element == null) {
            throw new ThemeIOException("Could not find the element associated to: " + elementXPath);
        }
        Properties properties = ThemeParser.getPropertiesFromNode(node);
        if (properties != null) {
            element.setUserData("properties", properties, null);
        }
    }

    private static Properties getPropertiesFromNode(Node node) {
        Properties properties = new Properties();
        for (Node n : ThemeParser.getChildElements(node)) {
            String presetName;
            String textContent = n.getTextContent();
            Node presetAttr = n.getAttributes().getNamedItem("preset");
            if (presetAttr != null && (presetName = presetAttr.getNodeValue()) != null) {
                textContent = String.format("\"%s\"", presetName);
            }
            properties.setProperty(n.getNodeName(), Framework.expandVars((String)textContent));
        }
        return properties;
    }

    private static List<Node> getChildElements(Node node) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (n.getNodeType() != 1) continue;
            nodes.add(n);
        }
        return nodes;
    }

    public static List<Node> getChildElementsByTagName(Node node, String tagName) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (n.getNodeType() != 1 || !tagName.equals(n.getNodeName())) continue;
            nodes.add(n);
        }
        return nodes;
    }

    public static Node getBaseNode(Element doc) throws ThemeIOException {
        Node baseNode = null;
        try {
            baseNode = (Node)xpath.evaluate("/theme/layout", doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new ThemeIOException(e);
        }
        if (baseNode == null) {
            throw new ThemeIOException("No <layout> section found.");
        }
        return baseNode;
    }

    private static String getCommentAssociatedTo(Node node) {
        Node n = node;
        while ((n = n.getPreviousSibling()) != null && n.getNodeType() != 1) {
            if (n.getNodeType() != 8) continue;
            return n.getNodeValue().trim();
        }
        return null;
    }

    private static String guessViewNameFor(Element doc, String elementXPath) {
        NodeList widgetNodes = doc.getElementsByTagName("widget");
        HashSet<String> candidates = new HashSet<String>();
        String[] elements = elementXPath.split("\\|");
        for (int i = 0; i < widgetNodes.getLength(); ++i) {
            Node node = widgetNodes.item(i);
            NamedNodeMap attributes = node.getAttributes();
            Node elementAttr = attributes.getNamedItem("element");
            if (elementAttr == null) continue;
            String[] widgetElements = elementAttr.getNodeValue().split("\\|");
            for (String element : elements) {
                for (String widgetElement : widgetElements) {
                    List<Node> viewNodes;
                    if (!element.equals(widgetElement) || (viewNodes = ThemeParser.getChildElementsByTagName(node, "view")).isEmpty()) continue;
                    candidates.add(viewNodes.get(0).getTextContent());
                }
            }
        }
        if (candidates.size() == 1) {
            return (String)candidates.iterator().next();
        }
        return null;
    }

    private static List<Node> getNodesByXPath(Node baseNode, String elementXPath) throws ThemeIOException {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (elementXPath != null) {
            try {
                NodeList elementNodes = (NodeList)xpath.evaluate(elementXPath, baseNode, XPathConstants.NODESET);
                for (int i = 0; i < elementNodes.getLength(); ++i) {
                    nodes.add(elementNodes.item(i));
                }
            }
            catch (XPathExpressionException e) {
                throw new ThemeIOException(e);
            }
        }
        return nodes;
    }
}

