/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.impl.task;

import java.io.File;
import java.util.Map;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.impl.task.CommandsTask;
import org.nuxeo.runtime.api.Framework;

public class InstallTask
extends CommandsTask {
    @Override
    public boolean isInstallTask() {
        return true;
    }

    @Override
    protected File getCommandsFile() throws PackageException {
        return this.pkg.getInstallFile();
    }

    @Override
    protected void doRun(Map<String, String> params) throws PackageException {
        super.doRun(params);
        File file = this.pkg.getData().getEntry("uninstall.xml");
        this.writeLog(file);
    }

    @Override
    protected void rollbackDone() throws PackageException {
        PackageUpdateService service = (PackageUpdateService)Framework.getLocalService(PackageUpdateService.class);
        service.setPackageState(this.pkg, 2);
    }

    @Override
    protected void taskDone() throws PackageException {
        PackageUpdateService service = (PackageUpdateService)Framework.getLocalService(PackageUpdateService.class);
        if (this.isRestartRequired()) {
            service.setPackageState(this.pkg, 4);
        } else {
            service.setPackageState(this.pkg, 5);
        }
    }
}

