/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.connector.http;

import org.nuxeo.connect.NuxeoConnectClient;

public class ConnectUrlConfig {
    public static final String CONNECT_DEFAULT_BASEURL = "https://connect.nuxeo.com/nuxeo/site/";
    public static final String CONNECT_URL_PROPERTY = "org.nuxeo.connect.url";
    public static final String CONNECT_PROXY_HOST_PROPERTY = "org.nuxeo.connect.proxy.host";
    public static final String CONNECT_PROXY_PORT_PROPERTY = "org.nuxeo.connect.proxy.port";
    public static final String CONNECT_PROXY_LOGIN_PROPERTY = "org.nuxeo.connect.proxy.login";
    public static final String CONNECT_PROXY_PASSWORD_PROPERTY = "org.nuxeo.connect.proxy.password";
    public static final String CONNECT_ROOT_PATH = "connect-gateway/";
    public static final String CONNECT_REGISTRED_ROOT_PATH = "registred/";
    protected static Boolean useProxy = null;

    public static String getBaseUrl() {
        if (NuxeoConnectClient.isTestModeSet()) {
            return "http://127.0.0.1:8082/";
        }
        return NuxeoConnectClient.getProperty(CONNECT_URL_PROPERTY, CONNECT_DEFAULT_BASEURL);
    }

    public static String getDownloadBaseUrl() {
        return ConnectUrlConfig.getBaseUrl().replace("/site/", "");
    }

    public static String getRegistrationBaseUrl() {
        return ConnectUrlConfig.getBaseUrl() + CONNECT_ROOT_PATH;
    }

    public static String getRegistredBaseUrl() {
        return ConnectUrlConfig.getRegistrationBaseUrl() + CONNECT_REGISTRED_ROOT_PATH;
    }

    public static boolean useProxy() {
        if (useProxy == null) {
            useProxy = ConnectUrlConfig.getProxyHost() != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return useProxy;
    }

    public static String getProxyHost() {
        return NuxeoConnectClient.getProperty(CONNECT_PROXY_HOST_PROPERTY, null);
    }

    public static int getProxyPort() {
        String portAsString = NuxeoConnectClient.getProperty(CONNECT_PROXY_PORT_PROPERTY, null);
        if (portAsString == null) {
            return 80;
        }
        return Integer.parseInt(portAsString);
    }

    public static String getProxyLogin() {
        return NuxeoConnectClient.getProperty(CONNECT_PROXY_LOGIN_PROPERTY, null);
    }

    public static String getProxyPassword() {
        return NuxeoConnectClient.getProperty(CONNECT_PROXY_PASSWORD_PROPERTY, null);
    }
}

