/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment.preprocessor;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.TextTemplate;
import org.nuxeo.runtime.deployment.preprocessor.ConfigurationGenerator;

public abstract class ServerConfigurator {
    protected static final Log log = LogFactory.getLog(ServerConfigurator.class);
    protected final ConfigurationGenerator generator;

    public ServerConfigurator(ConfigurationGenerator configurationGenerator) {
        this.generator = configurationGenerator;
    }

    abstract boolean isConfigured();

    protected void parseAndCopy(Properties config) throws IOException {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !"nuxeo.defaults".equals(name);
            }
        };
        TextTemplate templateParser = new TextTemplate(config);
        templateParser.setTrim(true);
        templateParser.setParsingExtensions(config.getProperty("nuxeo.templates.parsing.extensions", "xml,properties"));
        for (File includedTemplate : this.generator.getIncludedTemplates()) {
            if (includedTemplate.listFiles(filter) == null) continue;
            String outputDirectoryStr = config.getProperty(includedTemplate.getName() + ".target");
            File outputDirectory = outputDirectoryStr != null ? new File(this.generator.getNuxeoHome(), outputDirectoryStr) : this.getOutputDirectory();
            for (File in : includedTemplate.listFiles(filter)) {
                templateParser.processDirectory(in, new File(outputDirectory, in.getName()));
            }
        }
    }

    protected abstract File getOutputDirectory();
}

