/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.types.ContentViews;
import org.nuxeo.ecm.platform.types.FieldWidget;
import org.nuxeo.ecm.platform.types.Layouts;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeView;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.ExtensionRegistry;

public class TypeRegistry
extends ExtensionRegistry<Type> {
    private static final Log log = LogFactory.getLog(TypeRegistry.class);
    protected volatile Map<String, Type> types = new HashMap<String, Type>();

    public void removeContributions() {
        this.types = new HashMap<String, Type>();
    }

    public void addContribution(Type contrib, Extension extension) {
        Type type = contrib;
        String typeId = type.getId();
        if (type.getRemove()) {
            log.debug((Object)("Removing type with id " + typeId));
            this.removeType(typeId);
        } else {
            if (this.hasType(typeId)) {
                type = TypeRegistry.mergeTypes(this.getType(typeId), type);
                this.removeType(typeId);
                log.debug((Object)("Merging type with id " + typeId));
            }
            this.addType(type);
            log.info((Object)("Registered platform document type: " + typeId));
        }
    }

    public synchronized void addType(Type type) {
        String id;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering type: " + type));
        }
        if (!this.types.containsKey(id = type.getId())) {
            this.types.put(id, type);
        }
    }

    public synchronized boolean hasType(String id) {
        return this.types.containsKey(id);
    }

    public synchronized Type removeType(String id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unregistering type: " + id));
        }
        return this.types.remove(id);
    }

    public synchronized Collection<Type> getTypes() {
        return Collections.unmodifiableCollection(this.types.values());
    }

    public Type getType(String id) {
        return this.types.get(id);
    }

    public static Type mergeTypes(Type oldType, Type newType) {
        Map contentViews;
        Map layouts;
        String editView;
        String createView;
        Map newTypeAllowedSubTypes;
        String category;
        String description;
        String label;
        String bigIconExpanded;
        String bigIcon;
        String iconExpanded;
        String icon = newType.getIcon();
        if (icon != null) {
            oldType.setIcon(icon);
        }
        if ((iconExpanded = newType.getIconExpanded()) != null) {
            oldType.setIconExpanded(iconExpanded);
        }
        if ((bigIcon = newType.getBigIcon()) != null) {
            oldType.setBigIcon(bigIcon);
        }
        if ((bigIconExpanded = newType.getBigIconExpanded()) != null) {
            oldType.setBigIconExpanded(bigIconExpanded);
        }
        if ((label = newType.getLabel()) != null) {
            oldType.setLabel(label);
        }
        if ((description = newType.getDescription()) != null) {
            oldType.setDescription(description);
        }
        if ((category = newType.getCategory()) != null) {
            oldType.setCategory(category);
        }
        if ((newTypeAllowedSubTypes = newType.getAllowedSubTypes()) != null) {
            Set newTypeKeySet = newTypeAllowedSubTypes.keySet();
            Map oldTypeAllowedSubTypes = oldType.getAllowedSubTypes();
            for (String newTypeKey : newTypeKeySet) {
                oldTypeAllowedSubTypes.put(newTypeKey, newTypeAllowedSubTypes.get(newTypeKey));
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        String[] deniedSubTypes = newType.getDeniedSubTypes();
        Map oldTypeAllowedSubTypes = oldType.getAllowedSubTypes();
        boolean toAdd = true;
        if (oldTypeAllowedSubTypes != null) {
            Set oldTypeKeySet = oldTypeAllowedSubTypes.keySet();
            for (String allowedSubType : oldTypeKeySet) {
                for (String deniedSubType : deniedSubTypes) {
                    if (!deniedSubType.equals(allowedSubType)) continue;
                    toAdd = false;
                    break;
                }
                if (toAdd) {
                    result.add(allowedSubType);
                }
                toAdd = true;
            }
        }
        HashMap mapResult = new HashMap();
        for (String resultTypeName : result) {
            mapResult.put(resultTypeName, oldTypeAllowedSubTypes.get(resultTypeName));
        }
        oldType.setAllowedSubTypes(mapResult);
        String defaultView = newType.getDefaultView();
        if (defaultView != null) {
            oldType.setDefaultView(defaultView);
        }
        if ((createView = newType.getCreateView()) != null) {
            oldType.setCreateView(createView);
        }
        if ((editView = newType.getEditView()) != null) {
            oldType.setEditView(editView);
        }
        for (TypeView view : newType.getViews()) {
            oldType.setView(view);
        }
        FieldWidget[] layout = newType.getLayout();
        if (layout != null && layout.length != 0) {
            oldType.setLayout(layout);
        }
        if ((layouts = newType.getLayouts()) != null) {
            HashMap<String, Layouts> layoutsMerged = new HashMap<String, Layouts>(oldType.getLayouts());
            for (Map.Entry entry : layouts.entrySet()) {
                String key = (String)entry.getKey();
                Layouts newLayouts = (Layouts)entry.getValue();
                if (layoutsMerged.containsKey(key) && newLayouts.getAppend()) {
                    ArrayList<String> allLayouts = new ArrayList<String>();
                    for (String layoutName : ((Layouts)layoutsMerged.get(key)).getLayouts()) {
                        allLayouts.add(layoutName);
                    }
                    for (String layoutName : newLayouts.getLayouts()) {
                        allLayouts.add(layoutName);
                    }
                    Layouts mergedLayouts = new Layouts();
                    mergedLayouts.layouts = allLayouts.toArray(new String[allLayouts.size()]);
                    layoutsMerged.put(key, mergedLayouts);
                    continue;
                }
                layoutsMerged.put(key, newLayouts);
            }
            oldType.setLayouts(layoutsMerged);
        }
        if ((contentViews = newType.getContentViews()) != null) {
            HashMap<String, ContentViews> cvMerged = new HashMap<String, ContentViews>(oldType.getContentViews());
            for (Map.Entry entry : contentViews.entrySet()) {
                String key = (String)entry.getKey();
                ContentViews newContentViews = (ContentViews)entry.getValue();
                if (cvMerged.containsKey(key) && newContentViews.getAppend()) {
                    ArrayList<String> allContentViews = new ArrayList<String>();
                    for (String layoutName : ((ContentViews)cvMerged.get(key)).getContentViews()) {
                        allContentViews.add(layoutName);
                    }
                    for (String layoutName : newContentViews.getContentViews()) {
                        allContentViews.add(layoutName);
                    }
                    ContentViews mergedContentViews = new ContentViews();
                    mergedContentViews.contentViews = allContentViews.toArray(new String[allContentViews.size()]);
                    cvMerged.put(key, mergedContentViews);
                    continue;
                }
                cvMerged.put(key, newContentViews);
            }
            oldType.setContentViews(cvMerged);
        }
        return oldType;
    }
}

