/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.extension;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.core.convert.service.ConversionServiceImpl;
import org.nuxeo.ecm.core.convert.service.MimeTypeTranslationHelper;

public class ChainedConverter
implements Converter {
    protected boolean subConvertersBased = false;
    protected List<String> steps = new ArrayList<String>();
    protected List<String> subConverters = new ArrayList<String>();

    public ChainedConverter() {
        this.subConvertersBased = false;
        this.subConverters = null;
    }

    public ChainedConverter(List<String> subConverters) {
        this.subConvertersBased = true;
        this.subConverters = subConverters;
        this.steps = null;
    }

    @Override
    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        if (this.subConvertersBased) {
            return this.convertBasedSubConverters(blobHolder, parameters);
        }
        return this.convertBasedOnMimeTypes(blobHolder, parameters);
    }

    protected BlobHolder convertBasedSubConverters(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        try {
            String srcMT = blobHolder.getBlob().getMimeType();
            BlobHolder result = blobHolder;
            for (String converterName : this.subConverters) {
                ConverterDescriptor desc = ConversionServiceImpl.getConverterDesciptor(converterName);
                if (!desc.getSourceMimeTypes().contains(srcMT)) {
                    throw new ConversionException("Conversion Chain is not well defined");
                }
                Converter converter = ConversionServiceImpl.getConverter(converterName);
                result = converter.convert(result, parameters);
                srcMT = desc.getDestinationMimeType();
            }
            return result;
        }
        catch (ClientException e) {
            throw new ConversionException("error while trying to executre converters chain", (Exception)((Object)e));
        }
    }

    protected BlobHolder convertBasedOnMimeTypes(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        try {
            String srcMT = blobHolder.getBlob().getMimeType();
            BlobHolder result = blobHolder;
            for (String dstMT : this.steps) {
                String converterName = MimeTypeTranslationHelper.getConverterName(srcMT, dstMT);
                if (converterName == null) {
                    throw new ConversionException("Chained conversion error : unable to find converter between " + srcMT + " and " + dstMT);
                }
                Converter converter = ConversionServiceImpl.getConverter(converterName);
                result = converter.convert(result, parameters);
                srcMT = dstMT;
            }
            return result;
        }
        catch (ClientException e) {
            throw new ConversionException("error while trying to determine converter name", (Exception)((Object)e));
        }
    }

    @Override
    public void init(ConverterDescriptor descriptor) {
        if (!this.subConvertersBased) {
            this.steps.addAll(descriptor.getSteps());
            this.steps.add(descriptor.getDestinationMimeType());
        } else {
            ConverterDescriptor fconv = ConversionServiceImpl.getConverterDesciptor(this.subConverters.get(0));
            ConverterDescriptor lconv = ConversionServiceImpl.getConverterDesciptor(this.subConverters.get(this.subConverters.size() - 1));
            descriptor.sourceMimeTypes = fconv.sourceMimeTypes;
            descriptor.destinationMimeType = lconv.destinationMimeType;
        }
    }

    public List<String> getSteps() {
        return this.steps;
    }
}

