/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.extension;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.convert.extension.ChainedConverter;
import org.nuxeo.ecm.core.convert.extension.Converter;

@XObject(value="converter")
public class ConverterDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CUSTOM_CONVERTER_TYPE = "Custom";
    public static final String CHAINED_CONVERTER_TYPE = "Chain";
    protected Converter instance;
    @XNode(value="@name")
    protected String converterName;
    @XNodeList(value="sourceMimeType", type=ArrayList.class, componentType=String.class)
    protected List<String> sourceMimeTypes = new ArrayList<String>();
    @XNode(value="destinationMimeType")
    protected String destinationMimeType;
    @XNode(value="@class")
    protected Class className;
    @XNode(value="@type")
    protected String converterType = "Custom";
    protected boolean wrappedTransformer = false;
    @XNodeMap(value="parameters/parameter", key="@name", type=HashMap.class, componentType=String.class)
    protected Map<String, String> parameters = new HashMap<String, String>();
    @XNodeList(value="conversionSteps/step", type=ArrayList.class, componentType=String.class)
    protected List<String> steps = new ArrayList<String>();
    @XNodeList(value="conversionSteps/subconverter", type=ArrayList.class, componentType=String.class)
    protected List<String> subConverters = new ArrayList<String>();

    public String getConverterName() {
        return this.converterName;
    }

    public List<String> getSourceMimeTypes() {
        return this.sourceMimeTypes;
    }

    public List<String> getSteps() {
        return this.steps;
    }

    public String getDestinationMimeType() {
        return this.destinationMimeType;
    }

    public void initConverter() throws Exception {
        if (this.instance == null) {
            if (this.className == null || this.converterType.equals(CHAINED_CONVERTER_TYPE)) {
                this.instance = this.subConverters == null || this.subConverters.size() == 0 ? new ChainedConverter() : new ChainedConverter(this.subConverters);
                this.converterType = CHAINED_CONVERTER_TYPE;
            } else {
                this.instance = (Converter)this.className.newInstance();
            }
            this.instance.init(this);
        }
    }

    public Converter getConverterInstance() {
        try {
            this.initConverter();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.instance;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public ConverterDescriptor merge(ConverterDescriptor other) {
        if (!other.getConverterName().equals(this.converterName)) {
            throw new UnsupportedOperationException("Can not merge ConverterDesciptors with different names");
        }
        if (this.wrappedTransformer) {
            return other;
        }
        if (other.parameters != null) {
            this.parameters.putAll(other.parameters);
        }
        if (other.className != null) {
            this.instance = null;
            this.className = other.className;
        }
        if (other.sourceMimeTypes != null) {
            for (String mt : other.sourceMimeTypes) {
                if (this.sourceMimeTypes.contains(mt)) continue;
                this.sourceMimeTypes.add(mt);
            }
        }
        if (other.destinationMimeType != null) {
            this.destinationMimeType = other.destinationMimeType;
        }
        if (other.converterType != null) {
            this.converterType = other.converterType;
        }
        if (other.steps != null && other.steps.size() > 0) {
            this.steps = other.steps;
        }
        return this;
    }

    public String getConverterType() {
        return this.converterType;
    }
}

