/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.html;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.owasp.validator.html.scan.AntiSamyDOMScanner;

public class AntiSamy {
    private String inputEncoding = "UTF-8";
    private String outputEncoding = "UTF-8";
    private Policy policy = null;

    public AntiSamy() {
    }

    public AntiSamy(Policy policy) {
        this.policy = policy;
    }

    public CleanResults scan(String taintedHTML) throws ScanException, PolicyException {
        if (this.policy == null) {
            throw new PolicyException("No policy loaded");
        }
        return this.scan(taintedHTML, this.policy);
    }

    public CleanResults scan(String taintedHTML, Policy policy) throws ScanException, PolicyException {
        return new AntiSamyDOMScanner(policy).scan(taintedHTML, this.inputEncoding, this.outputEncoding);
    }

    public CleanResults scan(String taintedHTML, String filename) throws ScanException, PolicyException {
        Policy policy = null;
        policy = Policy.getInstance(filename);
        return this.scan(taintedHTML, policy);
    }

    public CleanResults scan(String taintedHTML, File policyFile) throws ScanException, PolicyException {
        Policy policy = null;
        policy = Policy.getInstance(policyFile);
        return this.scan(taintedHTML, policy);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Please specify a URL or file name to filter - thanks!");
            return;
        }
        try {
            String inputLine;
            StringBuffer buff = new StringBuffer();
            URL httpUrl = null;
            FileReader fileUrl = null;
            BufferedReader in = null;
            try {
                httpUrl = new URL(args[0]);
                in = new BufferedReader(new InputStreamReader(httpUrl.openStream()));
            }
            catch (MalformedURLException e) {
                try {
                    fileUrl = new FileReader(new File(args[0]));
                }
                catch (FileNotFoundException e1) {
                    System.err.println("Please specify a URL or file name to filter - thanks!");
                    return;
                }
                in = new BufferedReader(fileUrl);
            }
            catch (IOException e) {
                System.err.println("Encountered an IOException while reading URL: ");
                e.printStackTrace();
            }
            while ((inputLine = in.readLine()) != null) {
                buff.append(inputLine);
            }
            in.close();
            AntiSamy as = new AntiSamy();
            CleanResults test = as.scan(buff.toString(), Policy.getInstance("/antisamy.xml"));
            System.out.println("[1] Finished scan [" + test.getCleanHTML().length() + " bytes] in " + test.getScanTime() + " seconds");
            System.out.println("\n[2] Clean HTML fragment:\n" + test.getCleanHTML());
            System.out.println("[3] Error Messages (" + test.getNumberOfErrors() + "):");
            for (int i = 0; i < test.getErrorMessages().size(); ++i) {
                String s = (String)test.getErrorMessages().get(i);
                System.out.println(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public void setInputEncoding(String inputEncoding) {
        this.inputEncoding = inputEncoding;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public void setPolicy(Policy policy) {
        this.policy = policy;
    }
}

