/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.client.api.Rendition;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.client.runtime.PersistentRelationshipImpl;
import org.apache.chemistry.opencmis.client.runtime.PersistentSessionImpl;
import org.apache.chemistry.opencmis.client.runtime.util.AbstractPageFetcher;
import org.apache.chemistry.opencmis.client.runtime.util.CollectionIterable;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.ExtensionLevel;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.commons.spi.RelationshipService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPersistentCmisObject
implements CmisObject {
    private PersistentSessionImpl session;
    private ObjectType objectType;
    private Map<String, Property<?>> properties;
    private AllowableActions allowableActions;
    private List<Rendition> renditions;
    private Acl acl;
    private List<Policy> policies;
    private List<Relationship> relationships;
    private Map<ExtensionLevel, List<CmisExtensionElement>> extensions;
    private OperationContext creationContext;
    private boolean isChanged = false;
    private long refreshTimestamp;
    private final ReentrantReadWriteLock fLock = new ReentrantReadWriteLock();

    protected void initialize(PersistentSessionImpl session, ObjectType objectType, ObjectData objectData, OperationContext context) {
        if (session == null) {
            throw new IllegalArgumentException("Session must be set!");
        }
        if (objectType == null) {
            throw new IllegalArgumentException("Object type must be set!");
        }
        if (objectType.getPropertyDefinitions() == null || objectType.getPropertyDefinitions().size() < 9) {
            throw new IllegalArgumentException("Object type must have property defintions!");
        }
        this.session = session;
        this.objectType = objectType;
        this.extensions = new HashMap<ExtensionLevel, List<CmisExtensionElement>>();
        this.creationContext = new OperationContextImpl(context);
        this.refreshTimestamp = System.currentTimeMillis();
        ObjectFactory of = this.getObjectFactory();
        if (objectData != null) {
            if (objectData.getProperties() != null) {
                this.properties = of.convertProperties(objectType, objectData.getProperties());
                this.extensions.put(ExtensionLevel.PROPERTIES, objectData.getProperties().getExtensions());
            }
            if (objectData.getAllowableActions() != null) {
                this.allowableActions = objectData.getAllowableActions();
                this.extensions.put(ExtensionLevel.ALLOWABLE_ACTIONS, objectData.getAllowableActions().getExtensions());
            }
            if (objectData.getRenditions() != null) {
                this.renditions = new ArrayList<Rendition>();
                for (RenditionData rd : objectData.getRenditions()) {
                    this.renditions.add(of.convertRendition(this.getId(), rd));
                }
            }
            if (objectData.getAcl() != null) {
                this.acl = objectData.getAcl();
                this.extensions.put(ExtensionLevel.ACL, objectData.getAcl().getExtensions());
            }
            if (objectData.getPolicyIds() != null && objectData.getPolicyIds().getPolicyIds() != null) {
                this.policies = new ArrayList<Policy>();
                for (String pid : objectData.getPolicyIds().getPolicyIds()) {
                    CmisObject policy = session.getObject(this.getSession().createObjectId(pid));
                    if (!(policy instanceof Policy)) continue;
                    this.policies.add((Policy)policy);
                }
                this.extensions.put(ExtensionLevel.POLICIES, objectData.getPolicyIds().getExtensions());
            }
            if (objectData.getRelationships() != null) {
                this.relationships = new ArrayList<Relationship>();
                for (ObjectData rod : objectData.getRelationships()) {
                    CmisObject relationship = of.convertObject(rod, this.creationContext);
                    if (!(relationship instanceof Relationship)) continue;
                    this.relationships.add((Relationship)relationship);
                }
            }
            this.extensions.put(ExtensionLevel.OBJECT, objectData.getExtensions());
        }
        this.isChanged = false;
    }

    protected void writeLock() {
        this.fLock.writeLock().lock();
    }

    protected void writeUnlock() {
        this.fLock.writeLock().unlock();
    }

    protected void readLock() {
        this.fLock.readLock().lock();
    }

    protected void readUnlock() {
        this.fLock.readLock().unlock();
    }

    protected PersistentSessionImpl getSession() {
        return this.session;
    }

    protected String getRepositoryId() {
        return this.getSession().getRepositoryId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectType getObjectType() {
        this.readLock();
        try {
            ObjectType objectType = this.objectType;
            return objectType;
        }
        finally {
            this.readUnlock();
        }
    }

    protected CmisBinding getBinding() {
        return this.getSession().getBinding();
    }

    protected ObjectFactory getObjectFactory() {
        return this.getSession().getObjectFactory();
    }

    protected String getObjectId() {
        String objectId = this.getId();
        if (objectId == null) {
            throw new IllegalStateException("Object Id is unknown!");
        }
        return objectId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPropertyQueryName(String propertyId) {
        this.readLock();
        try {
            PropertyDefinition propDef = (PropertyDefinition)this.objectType.getPropertyDefinitions().get(propertyId);
            if (propDef == null) {
                String string = null;
                return string;
            }
            String string = propDef.getQueryName();
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    public void delete(boolean allVersions) {
        String objectId = this.getObjectId();
        this.getBinding().getObjectService().deleteObject(this.getRepositoryId(), objectId, Boolean.valueOf(allVersions), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectId updateProperties() {
        this.readLock();
        try {
            String objectId = this.getObjectId();
            Holder objectIdHolder = new Holder((Object)objectId);
            String changeToken = this.getChangeToken();
            Holder changeTokenHolder = new Holder((Object)changeToken);
            HashSet<Updatability> updatebility = new HashSet<Updatability>();
            updatebility.add(Updatability.READWRITE);
            Boolean isCheckedOut = (Boolean)this.getPropertyValue("cmis:isVersionSeriesCheckedOut");
            if (isCheckedOut != null && isCheckedOut.booleanValue()) {
                updatebility.add(Updatability.WHENCHECKEDOUT);
            }
            this.getBinding().getObjectService().updateProperties(this.getRepositoryId(), objectIdHolder, changeTokenHolder, this.getObjectFactory().convertProperties(this.properties, this.objectType, updatebility), null);
            if (objectIdHolder.getValue() == null) {
                ObjectId objectId2 = null;
                return objectId2;
            }
            ObjectId objectId3 = this.getSession().createObjectId((String)objectIdHolder.getValue());
            return objectId3;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectId updateProperties(Map<String, ?> properties) {
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Properties must not be empty!");
        }
        this.readLock();
        try {
            String objectId = this.getObjectId();
            Holder objectIdHolder = new Holder((Object)objectId);
            String changeToken = this.getChangeToken();
            Holder changeTokenHolder = new Holder((Object)changeToken);
            HashSet<Updatability> updatebility = new HashSet<Updatability>();
            updatebility.add(Updatability.READWRITE);
            Boolean isCheckedOut = (Boolean)this.getPropertyValue("cmis:isVersionSeriesCheckedOut");
            if (isCheckedOut != null && isCheckedOut.booleanValue()) {
                updatebility.add(Updatability.WHENCHECKEDOUT);
            }
            this.getBinding().getObjectService().updateProperties(this.getRepositoryId(), objectIdHolder, changeTokenHolder, this.getObjectFactory().convertProperties(properties, this.objectType, updatebility), null);
            if (objectIdHolder.getValue() == null) {
                ObjectId objectId2 = null;
                return objectId2;
            }
            ObjectId objectId3 = this.getSession().createObjectId((String)objectIdHolder.getValue());
            return objectId3;
        }
        finally {
            this.readUnlock();
        }
    }

    public ObjectType getBaseType() {
        BaseTypeId baseTypeId = this.getBaseTypeId();
        if (baseTypeId == null) {
            return null;
        }
        return this.getSession().getTypeDefinition(baseTypeId.value());
    }

    public BaseTypeId getBaseTypeId() {
        String baseType = (String)this.getPropertyValue("cmis:baseTypeId");
        if (baseType == null) {
            return null;
        }
        return BaseTypeId.fromValue((String)baseType);
    }

    public String getChangeToken() {
        return (String)this.getPropertyValue("cmis:changeToken");
    }

    public String getCreatedBy() {
        return (String)this.getPropertyValue("cmis:createdBy");
    }

    public GregorianCalendar getCreationDate() {
        return (GregorianCalendar)this.getPropertyValue("cmis:creationDate");
    }

    public String getId() {
        return (String)this.getPropertyValue("cmis:objectId");
    }

    public GregorianCalendar getLastModificationDate() {
        return (GregorianCalendar)this.getPropertyValue("cmis:lastModificationDate");
    }

    public String getLastModifiedBy() {
        return (String)this.getPropertyValue("cmis:lastModifiedBy");
    }

    public String getName() {
        return (String)this.getPropertyValue("cmis:name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Property<?>> getProperties() {
        this.readLock();
        try {
            ArrayList arrayList = new ArrayList(this.properties.values());
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Property<T> getProperty(String id) {
        this.readLock();
        try {
            Property<?> property = this.properties.get(id);
            return property;
        }
        finally {
            this.readUnlock();
        }
    }

    public <T> T getPropertyValue(String id) {
        Property<T> property = this.getProperty(id);
        if (property == null) {
            return null;
        }
        return (T)property.getValue();
    }

    public void setName(String name) {
        this.setProperty("cmis:name", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setProperty(String id, Object value) {
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getObjectType().getPropertyDefinitions().get(id);
        if (propertyDefinition == null) {
            throw new IllegalArgumentException("Unknown property '" + id + "'!");
        }
        if (propertyDefinition.getUpdatability() == Updatability.READONLY) {
            throw new IllegalArgumentException("Property is read-only!");
        }
        List<T> values = this.checkProperty(propertyDefinition, value);
        Property newProperty = this.getObjectFactory().createProperty(propertyDefinition, values);
        this.writeLock();
        try {
            this.setChanged();
            this.properties.put(id, newProperty);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectType getType() {
        this.readLock();
        try {
            ObjectType objectType = this.objectType;
            return objectType;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AllowableActions getAllowableActions() {
        this.readLock();
        try {
            AllowableActions allowableActions = this.allowableActions;
            return allowableActions;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Rendition> getRenditions() {
        this.readLock();
        try {
            List<Rendition> list = this.renditions;
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    public Acl getAcl(boolean onlyBasicPermissions) {
        String objectId = this.getObjectId();
        return this.getBinding().getAclService().getAcl(this.getRepositoryId(), objectId, Boolean.valueOf(onlyBasicPermissions), null);
    }

    public Acl applyAcl(List<Ace> addAces, List<Ace> removeAces, AclPropagation aclPropagation) {
        String objectId = this.getObjectId();
        ObjectFactory of = this.getObjectFactory();
        return this.getBinding().getAclService().applyAcl(this.getRepositoryId(), objectId, of.convertAces(addAces), of.convertAces(removeAces), aclPropagation, null);
    }

    public void addAcl(List<Ace> addAces, AclPropagation aclPropagation) {
        this.applyAcl(addAces, null, aclPropagation);
    }

    public void removeAcl(List<Ace> removeAces, AclPropagation aclPropagation) {
        this.applyAcl(null, removeAces, aclPropagation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Acl getAcl() {
        this.readLock();
        try {
            Acl acl = this.acl;
            return acl;
        }
        finally {
            this.readUnlock();
        }
    }

    public void applyPolicy(ObjectId policyId) {
        if (policyId == null || policyId.getId() == null) {
            throw new IllegalArgumentException("Policy Id is not set!");
        }
        String objectId = this.getObjectId();
        this.getBinding().getPolicyService().applyPolicy(this.getRepositoryId(), policyId.getId(), objectId, null);
    }

    public void removePolicy(ObjectId policyId) {
        if (policyId == null || policyId.getId() == null) {
            throw new IllegalArgumentException("Policy Id is not set!");
        }
        String objectId = this.getObjectId();
        this.getBinding().getPolicyService().removePolicy(this.getRepositoryId(), policyId.getId(), objectId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Policy> getPolicies() {
        this.readLock();
        try {
            List<Policy> list = this.policies;
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Relationship> getRelationships() {
        this.readLock();
        try {
            List<Relationship> list = this.relationships;
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    public ItemIterable<Relationship> getRelationships(final boolean includeSubRelationshipTypes, final RelationshipDirection relationshipDirection, ObjectType type, OperationContext context) {
        final String objectId = this.getObjectId();
        final String typeId = type == null ? null : type.getId();
        final RelationshipService relationshipService = this.getBinding().getRelationshipService();
        final OperationContextImpl ctxt = new OperationContextImpl(context);
        return new CollectionIterable<Relationship>(new AbstractPageFetcher<Relationship>((long)ctxt.getMaxItemsPerPage()){

            @Override
            protected AbstractPageFetcher.Page<Relationship> fetchPage(long skipCount) {
                ObjectList relList = relationshipService.getObjectRelationships(AbstractPersistentCmisObject.this.getRepositoryId(), objectId, Boolean.valueOf(includeSubRelationshipTypes), relationshipDirection, typeId, ctxt.getFilterString(), Boolean.valueOf(ctxt.isIncludeAllowableActions()), BigInteger.valueOf(this.maxNumItems), BigInteger.valueOf(skipCount), null);
                ArrayList<PersistentRelationshipImpl> page = new ArrayList<PersistentRelationshipImpl>();
                if (relList.getObjects() != null) {
                    for (ObjectData rod : relList.getObjects()) {
                        PersistentRelationshipImpl relationship = new PersistentRelationshipImpl(AbstractPersistentCmisObject.this.getSession(), AbstractPersistentCmisObject.this.getObjectFactory().getTypeFromObjectData(rod), rod, ctxt);
                        page.add(relationship);
                    }
                }
                return new AbstractPageFetcher.Page<Relationship>(page, relList.getNumItems(), relList.hasMoreItems());
            }
        });
    }

    public List<CmisExtensionElement> getExtensions(ExtensionLevel level) {
        List<CmisExtensionElement> ext = this.extensions.get(level);
        if (ext == null) {
            return null;
        }
        return Collections.unmodifiableList(ext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChanged() {
        this.readLock();
        try {
            boolean bl = this.isChanged;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setChanged() {
        this.writeLock();
        try {
            this.isChanged = true;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRefreshTimestamp() {
        this.readLock();
        try {
            long l = this.refreshTimestamp;
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.writeLock();
        try {
            String objectId = this.getObjectId();
            ObjectData objectData = this.getSession().getBinding().getObjectService().getObject(this.getRepositoryId(), objectId, this.creationContext.getFilterString(), Boolean.valueOf(this.creationContext.isIncludeAllowableActions()), this.creationContext.getIncludeRelationships(), this.creationContext.getRenditionFilterString(), Boolean.valueOf(this.creationContext.isIncludePolicies()), Boolean.valueOf(this.creationContext.isIncludeAcls()), null);
            this.initialize(this.getSession(), this.getObjectType(), objectData, this.creationContext);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshIfOld(long durationInMillis) {
        this.writeLock();
        try {
            if (this.refreshTimestamp < System.currentTimeMillis() - durationInMillis) {
                this.refresh();
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private <T> List<T> checkProperty(PropertyDefinition<T> propertyDefinition, Object value) {
        if (value == null) {
            return null;
        }
        List<Object> values = null;
        if (value instanceof List) {
            if (propertyDefinition.getCardinality() != Cardinality.MULTI) {
                throw new IllegalArgumentException("Property '" + propertyDefinition.getId() + "' is not a multi value property!");
            }
            values = (List<Object>)value;
            if (values.isEmpty()) {
                return values;
            }
        } else {
            if (propertyDefinition.getCardinality() != Cardinality.SINGLE) {
                throw new IllegalArgumentException("Property '" + propertyDefinition.getId() + "' is not a single value property!");
            }
            values = Collections.singletonList(value);
        }
        for (Object o : values) {
            if (o != null) continue;
            throw new IllegalArgumentException("Property '" + propertyDefinition.getId() + "' contains null values!");
        }
        boolean typeMatch = false;
        Object firstValue = values.get(0);
        switch (propertyDefinition.getPropertyType()) {
            case STRING: 
            case ID: 
            case URI: 
            case HTML: {
                typeMatch = firstValue instanceof String;
                break;
            }
            case INTEGER: {
                typeMatch = firstValue instanceof BigInteger;
                break;
            }
            case DECIMAL: {
                typeMatch = firstValue instanceof BigDecimal;
                break;
            }
            case BOOLEAN: {
                typeMatch = firstValue instanceof Boolean;
                break;
            }
            case DATETIME: {
                typeMatch = firstValue instanceof GregorianCalendar;
            }
        }
        if (!typeMatch) {
            throw new IllegalArgumentException("Value of property '" + propertyDefinition.getId() + "' does not match property type!");
        }
        return values;
    }
}

