/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.chemistry.opencmis.client.api.ChangeEvents;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.ExtensionHandler;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.Tree;
import org.apache.chemistry.opencmis.client.runtime.CmisBindingHelper;
import org.apache.chemistry.opencmis.client.runtime.ObjectIdImpl;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.client.runtime.cache.Cache;
import org.apache.chemistry.opencmis.client.runtime.cache.CacheImpl;
import org.apache.chemistry.opencmis.client.runtime.repository.PersistentObjectFactoryImpl;
import org.apache.chemistry.opencmis.client.runtime.util.AbstractPageFetcher;
import org.apache.chemistry.opencmis.client.runtime.util.CollectionIterable;
import org.apache.chemistry.opencmis.client.runtime.util.TreeImpl;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;
import org.apache.chemistry.opencmis.commons.spi.DiscoveryService;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.commons.spi.NavigationService;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentSessionImpl
implements Session,
Serializable {
    private static final OperationContext DEFAULT_CONTEXT = new OperationContextImpl(null, false, true, false, IncludeRelationships.NONE, null, true, null, true, 100);
    private static final Set<Updatability> CREATE_UPDATABILITY = new HashSet<Updatability>();
    private static Log log;
    private final ReentrantReadWriteLock fLock = new ReentrantReadWriteLock();
    private OperationContext context = DEFAULT_CONTEXT;
    private Map<String, String> parameters = null;
    private CmisBinding binding = null;
    private Locale locale = null;
    private Cache cache = null;
    private RepositoryInfo repositoryInfo;
    private final ObjectFactory objectFactory = PersistentObjectFactoryImpl.newInstance(this);
    private static final long serialVersionUID = -4287481628831198383L;

    public PersistentSessionImpl(Map<String, String> parameters) {
        this.parameters = parameters;
        log.info((Object)("Session Parameters: " + parameters));
        this.locale = this.determineLocale(parameters);
        log.info((Object)("Session Locale: " + this.locale.toString()));
        int cacheSize = this.determineCacheSize(parameters);
        this.cache = cacheSize == -1 ? CacheImpl.newInstance() : CacheImpl.newInstance(cacheSize);
        log.info((Object)("Session Cache Size: " + this.cache.getCacheSize()));
    }

    private int determineCacheSize(Map<String, String> parameters) {
        int size = -1;
        return size;
    }

    private String determineRepositoryId(Map<String, String> parameters) {
        String repositoryId = parameters.get("org.apache.chemistry.opencmis.session.repository.id");
        return repositoryId;
    }

    private Locale determineLocale(Map<String, String> parameters) {
        Locale locale = null;
        String language = parameters.get("org.apache.chemistry.opencmis.locale.iso639");
        String country = parameters.get("org.apache.chemistry.opencmis.locale.iso3166");
        String variant = parameters.get("org.apache.chemistry.opencmis.locale.variant");
        locale = variant != null ? new Locale(language, country, variant) : (country != null ? new Locale(language, country) : (language != null ? new Locale(language) : Locale.getDefault()));
        return locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.fLock.writeLock().lock();
        try {
            int cacheSize = this.determineCacheSize(this.parameters);
            this.cache = cacheSize == -1 ? CacheImpl.newInstance() : CacheImpl.newInstance(cacheSize);
            log.info((Object)("Session Cache Size: " + this.cache.getCacheSize()));
            this.getBinding().clearAllCaches();
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    public void save() {
    }

    public void cancel() {
        throw new UnsupportedOperationException("cancel");
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public ItemIterable<Document> getCheckedOutDocs() {
        return this.getCheckedOutDocs(this.getDefaultContext());
    }

    public ItemIterable<Document> getCheckedOutDocs(OperationContext context) {
        final NavigationService navigationService = this.getBinding().getNavigationService();
        final ObjectFactory objectFactory = this.getObjectFactory();
        final OperationContextImpl ctxt = new OperationContextImpl(context);
        return new CollectionIterable<Document>(new AbstractPageFetcher<Document>((long)ctxt.getMaxItemsPerPage()){

            @Override
            protected AbstractPageFetcher.Page<Document> fetchPage(long skipCount) {
                ObjectList checkedOutDocs = navigationService.getCheckedOutDocs(PersistentSessionImpl.this.getRepositoryId(), null, ctxt.getFilterString(), ctxt.getOrderBy(), Boolean.valueOf(ctxt.isIncludeAllowableActions()), ctxt.getIncludeRelationships(), ctxt.getRenditionFilterString(), BigInteger.valueOf(this.maxNumItems), BigInteger.valueOf(skipCount), null);
                ArrayList<Document> page = new ArrayList<Document>();
                if (checkedOutDocs.getObjects() != null) {
                    for (ObjectData objectData : checkedOutDocs.getObjects()) {
                        CmisObject doc = objectFactory.convertObject(objectData, ctxt);
                        if (!(doc instanceof Document)) continue;
                        page.add((Document)doc);
                    }
                }
                return new AbstractPageFetcher.Page<Document>(page, checkedOutDocs.getNumItems(), checkedOutDocs.hasMoreItems());
            }
        });
    }

    public ChangeEvents getContentChanges(String changeLogToken, boolean includeProperties, long maxNumItems) {
        return this.getContentChanges(changeLogToken, includeProperties, maxNumItems, this.getDefaultContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeEvents getContentChanges(String changeLogToken, boolean includeProperties, long maxNumItems, OperationContext context) {
        this.fLock.readLock().lock();
        try {
            Holder changeLogTokenHolder = new Holder((Object)changeLogToken);
            ObjectList objectList = this.getBinding().getDiscoveryService().getContentChanges(this.getRepositoryInfo().getId(), changeLogTokenHolder, Boolean.valueOf(includeProperties), context.getFilterString(), Boolean.valueOf(context.isIncludePolicies()), Boolean.valueOf(context.isIncludeAcls()), BigInteger.valueOf(maxNumItems), null);
            ChangeEvents changeEvents = this.objectFactory.convertChangeEvents((String)changeLogTokenHolder.getValue(), objectList);
            return changeEvents;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationContext getDefaultContext() {
        this.fLock.readLock().lock();
        try {
            OperationContext operationContext = this.context;
            return operationContext;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultContext(OperationContext context) {
        this.fLock.writeLock().lock();
        try {
            this.context = context == null ? DEFAULT_CONTEXT : context;
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    public OperationContext createOperationContext(Set<String> filter, boolean includeAcls, boolean includeAllowableActions, boolean includePolicies, IncludeRelationships includeRelationships, Set<String> renditionFilter, boolean includePathSegments, String orderBy, boolean cacheEnabled, int maxItemsPerPage) {
        return new OperationContextImpl(filter, includeAcls, includeAllowableActions, includePolicies, includeRelationships, renditionFilter, includePathSegments, orderBy, cacheEnabled, maxItemsPerPage);
    }

    public OperationContext createOperationContext() {
        return new OperationContextImpl();
    }

    public ObjectId createObjectId(String id) {
        return new ObjectIdImpl(id);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public CmisObject getObject(ObjectId objectId) {
        return this.getObject(objectId, this.getDefaultContext());
    }

    public CmisObject getObject(ObjectId objectId, OperationContext context) {
        if (objectId == null || objectId.getId() == null) {
            throw new IllegalArgumentException("Object Id must be set!");
        }
        if (context == null) {
            throw new IllegalArgumentException("Operation context must be set!");
        }
        CmisObject result = null;
        if (context.isCacheEnabled() && (result = this.cache.getById(objectId.getId(), context.getCacheKey())) != null) {
            return result;
        }
        ObjectData objectData = this.binding.getObjectService().getObject(this.getRepositoryId(), objectId.getId(), context.getFilterString(), Boolean.valueOf(context.isIncludeAllowableActions()), context.getIncludeRelationships(), context.getRenditionFilterString(), Boolean.valueOf(context.isIncludePolicies()), Boolean.valueOf(context.isIncludeAcls()), null);
        result = this.getObjectFactory().convertObject(objectData, context);
        if (context.isCacheEnabled()) {
            this.cache.put(result, context.getCacheKey());
        }
        return result;
    }

    public CmisObject getObjectByPath(String path) {
        return this.getObjectByPath(path, this.getDefaultContext());
    }

    public CmisObject getObjectByPath(String path, OperationContext context) {
        if (path == null) {
            throw new IllegalArgumentException("Path must be set!");
        }
        if (context == null) {
            throw new IllegalArgumentException("Operation context must be set!");
        }
        CmisObject result = null;
        if (context.isCacheEnabled() && (result = this.cache.getByPath(path, context.getCacheKey())) != null) {
            return result;
        }
        ObjectData objectData = this.binding.getObjectService().getObjectByPath(this.getRepositoryId(), path, context.getFilterString(), Boolean.valueOf(context.isIncludeAllowableActions()), context.getIncludeRelationships(), context.getRenditionFilterString(), Boolean.valueOf(context.isIncludePolicies()), Boolean.valueOf(context.isIncludeAcls()), null);
        result = this.getObjectFactory().convertObject(objectData, context);
        if (context.isCacheEnabled()) {
            this.cache.putPath(path, result, context.getCacheKey());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryInfo getRepositoryInfo() {
        this.fLock.readLock().lock();
        try {
            RepositoryInfo repositoryInfo = this.repositoryInfo;
            return repositoryInfo;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    public Folder getRootFolder() {
        return this.getRootFolder(this.getDefaultContext());
    }

    public Folder getRootFolder(OperationContext context) {
        String rootFolderId = this.getRepositoryInfo().getRootFolderId();
        CmisObject rootFolder = this.getObject(this.createObjectId(rootFolderId), context);
        if (!(rootFolder instanceof Folder)) {
            throw new CmisRuntimeException("Root folder object is not a folder!");
        }
        return (Folder)rootFolder;
    }

    public ItemIterable<ObjectType> getTypeChildren(final String typeId, final boolean includePropertyDefinitions) {
        final RepositoryService repositoryService = this.getBinding().getRepositoryService();
        final ObjectFactory objectFactory = this.getObjectFactory();
        return new CollectionIterable<ObjectType>(new AbstractPageFetcher<ObjectType>((long)this.getDefaultContext().getMaxItemsPerPage()){

            @Override
            protected AbstractPageFetcher.Page<ObjectType> fetchPage(long skipCount) {
                TypeDefinitionList tdl = repositoryService.getTypeChildren(PersistentSessionImpl.this.getRepositoryId(), typeId, Boolean.valueOf(includePropertyDefinitions), BigInteger.valueOf(this.maxNumItems), BigInteger.valueOf(skipCount), null);
                ArrayList<ObjectType> page = new ArrayList<ObjectType>(tdl.getList().size());
                for (TypeDefinition typeDefinition : tdl.getList()) {
                    page.add(objectFactory.convertTypeDefinition(typeDefinition));
                }
                return new AbstractPageFetcher.Page<ObjectType>(page, tdl.getNumItems(), tdl.hasMoreItems()){};
            }
        });
    }

    public ObjectType getTypeDefinition(String typeId) {
        TypeDefinition typeDefinition = this.getBinding().getRepositoryService().getTypeDefinition(this.getRepositoryId(), typeId, null);
        return this.objectFactory.convertTypeDefinition(typeDefinition);
    }

    public List<Tree<ObjectType>> getTypeDescendants(String typeId, int depth, boolean includePropertyDefinitions) {
        List descendants = this.getBinding().getRepositoryService().getTypeDescendants(this.getRepositoryId(), typeId, BigInteger.valueOf(depth), Boolean.valueOf(includePropertyDefinitions), null);
        return this.convertTypeDescendants(descendants);
    }

    private List<Tree<ObjectType>> convertTypeDescendants(List<TypeDefinitionContainer> descendantsList) {
        ArrayList<Tree<ObjectType>> result = new ArrayList<Tree<ObjectType>>();
        for (TypeDefinitionContainer container : descendantsList) {
            ObjectType objectType = this.objectFactory.convertTypeDefinition(container.getTypeDefinition());
            List children = this.convertTypeDescendants(container.getChildren());
            result.add(new TreeImpl<ObjectType>(objectType, children));
        }
        return result;
    }

    public ItemIterable<QueryResult> query(String statement, boolean searchAllVersions) {
        return this.query(statement, searchAllVersions, this.getDefaultContext());
    }

    public ItemIterable<QueryResult> query(final String statement, final boolean searchAllVersions, OperationContext context) {
        final DiscoveryService discoveryService = this.getBinding().getDiscoveryService();
        final ObjectFactory objectFactory = this.getObjectFactory();
        final OperationContextImpl ctxt = new OperationContextImpl(context);
        return new CollectionIterable<QueryResult>(new AbstractPageFetcher<QueryResult>((long)ctxt.getMaxItemsPerPage()){

            @Override
            protected AbstractPageFetcher.Page<QueryResult> fetchPage(long skipCount) {
                ObjectList resultList = discoveryService.query(PersistentSessionImpl.this.getRepositoryId(), statement, Boolean.valueOf(searchAllVersions), Boolean.valueOf(ctxt.isIncludeAllowableActions()), ctxt.getIncludeRelationships(), ctxt.getRenditionFilterString(), BigInteger.valueOf(this.maxNumItems), BigInteger.valueOf(skipCount), null);
                ArrayList<QueryResult> page = new ArrayList<QueryResult>();
                if (resultList.getObjects() != null) {
                    for (ObjectData objectData : resultList.getObjects()) {
                        if (objectData == null) continue;
                        page.add(objectFactory.convertQueryResult(objectData));
                    }
                }
                return new AbstractPageFetcher.Page<QueryResult>(page, resultList.getNumItems(), resultList.hasMoreItems());
            }
        });
    }

    public String setExtensionContext(String context) {
        throw new CmisRuntimeException("not implemented");
    }

    public ExtensionHandler setExtensionHandler(String context, ExtensionHandler extensionHandler) {
        throw new CmisRuntimeException("not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        this.fLock.writeLock().lock();
        try {
            this.binding = CmisBindingHelper.createProvider(this.parameters);
            String repositoryId = this.determineRepositoryId(this.parameters);
            if (repositoryId == null) {
                throw new IllegalStateException("Repository Id is not set!");
            }
            this.repositoryInfo = this.getBinding().getRepositoryService().getRepositoryInfo(repositoryId, null);
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmisBinding getBinding() {
        this.fLock.readLock().lock();
        try {
            CmisBinding cmisBinding = this.binding;
            return cmisBinding;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getCache() {
        this.fLock.readLock().lock();
        try {
            Cache cache = this.cache;
            return cache;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    public String getRepositoryId() {
        return this.getRepositoryInfo().getId();
    }

    public ObjectId createDocument(Map<String, ?> properties, ObjectId folderId, ContentStream contentStream, VersioningState versioningState, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        if (folderId != null && folderId.getId() == null) {
            throw new IllegalArgumentException("Folder Id must be set!");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Properties must not be empty!");
        }
        String newId = this.getBinding().getObjectService().createDocument(this.getRepositoryId(), this.objectFactory.convertProperties(properties, null, CREATE_UPDATABILITY), folderId == null ? null : folderId.getId(), this.objectFactory.convertContentStream(contentStream), versioningState, this.objectFactory.convertPolicies(policies), this.objectFactory.convertAces(addAces), this.objectFactory.convertAces(removeAces), null);
        if (newId == null) {
            return null;
        }
        return this.createObjectId(newId);
    }

    public ObjectId createDocumentFromSource(ObjectId source, Map<String, ?> properties, ObjectId folderId, VersioningState versioningState, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        ObjectType type = null;
        if (source instanceof CmisObject) {
            type = ((CmisObject)source).getBaseType();
        } else {
            CmisObject sourceObj = this.getObject(source);
            type = sourceObj.getType();
        }
        if (type.getBaseTypeId() != BaseTypeId.CMIS_DOCUMENT) {
            throw new IllegalArgumentException("Source object must be a document!");
        }
        String newId = this.getBinding().getObjectService().createDocumentFromSource(this.getRepositoryId(), source.getId(), this.objectFactory.convertProperties(properties, type, CREATE_UPDATABILITY), folderId == null ? null : folderId.getId(), versioningState, this.objectFactory.convertPolicies(policies), this.objectFactory.convertAces(addAces), this.objectFactory.convertAces(removeAces), null);
        if (newId == null) {
            return null;
        }
        return this.createObjectId(newId);
    }

    public ObjectId createFolder(Map<String, ?> properties, ObjectId folderId, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        if (folderId != null && folderId.getId() == null) {
            throw new IllegalArgumentException("Folder Id must be set!");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Properties must not be empty!");
        }
        String newId = this.getBinding().getObjectService().createFolder(this.getRepositoryId(), this.objectFactory.convertProperties(properties, null, CREATE_UPDATABILITY), folderId == null ? null : folderId.getId(), this.objectFactory.convertPolicies(policies), this.objectFactory.convertAces(addAces), this.objectFactory.convertAces(removeAces), null);
        if (newId == null) {
            return null;
        }
        return this.createObjectId(newId);
    }

    public ObjectId createPolicy(Map<String, ?> properties, ObjectId folderId, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        if (folderId != null && folderId.getId() == null) {
            throw new IllegalArgumentException("Folder Id must be set!");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Properties must not be empty!");
        }
        String newId = this.getBinding().getObjectService().createPolicy(this.getRepositoryId(), this.objectFactory.convertProperties(properties, null, CREATE_UPDATABILITY), folderId == null ? null : folderId.getId(), this.objectFactory.convertPolicies(policies), this.objectFactory.convertAces(addAces), this.objectFactory.convertAces(removeAces), null);
        if (newId == null) {
            return null;
        }
        return this.createObjectId(newId);
    }

    public ObjectId createRelationship(Map<String, ?> properties, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Properties must not be empty!");
        }
        String newId = this.getBinding().getObjectService().createRelationship(this.getRepositoryId(), this.objectFactory.convertProperties(properties, null, CREATE_UPDATABILITY), this.objectFactory.convertPolicies(policies), this.objectFactory.convertAces(addAces), this.objectFactory.convertAces(removeAces), null);
        if (newId == null) {
            return null;
        }
        return this.createObjectId(newId);
    }

    public ObjectId createDocument(Map<String, ?> properties, ObjectId folderId, ContentStream contentStream, VersioningState versioningState) {
        return this.createDocument(properties, folderId, contentStream, versioningState, null, null, null);
    }

    public ObjectId createDocumentFromSource(ObjectId source, Map<String, ?> properties, ObjectId folderId, VersioningState versioningState) {
        return this.createDocumentFromSource(source, properties, folderId, versioningState, null, null, null);
    }

    public ObjectId createFolder(Map<String, ?> properties, ObjectId folderId) {
        return this.createFolder(properties, folderId, null, null, null);
    }

    public ObjectId createPolicy(Map<String, ?> properties, ObjectId folderId) {
        return this.createPolicy(properties, folderId, null, null, null);
    }

    public ObjectId createRelationship(Map<String, ?> properties) {
        return this.createRelationship(properties, null, null, null);
    }

    static {
        CREATE_UPDATABILITY.add(Updatability.ONCREATE);
        CREATE_UPDATABILITY.add(Updatability.READWRITE);
        log = LogFactory.getLog(PersistentSessionImpl.class);
    }
}

