/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.math.BigInteger;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Rendition;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RenditionDataImpl;

public class RenditionImpl
extends RenditionDataImpl
implements Rendition {
    private Session session;
    private String objectId;

    public RenditionImpl(Session session, String objectId, String streamId, String renditionDocumentId, String kind, long length, String mimeType, String title, int height, int width) {
        super(streamId, mimeType, BigInteger.valueOf(length), kind, title, BigInteger.valueOf(width), BigInteger.valueOf(height), renditionDocumentId);
        this.session = session;
        this.objectId = objectId;
    }

    public long getLength() {
        return this.fLength == null ? -1L : this.fLength.longValue();
    }

    public long getHeight() {
        return this.fHeight == null ? -1L : this.fHeight.longValue();
    }

    public long getWidth() {
        return this.fWidth == null ? -1L : this.fWidth.longValue();
    }

    public Document getRenditionDocument() {
        return this.getRenditionDocument(this.session.getDefaultContext());
    }

    public Document getRenditionDocument(OperationContext context) {
        if (this.fRenditionDocumentId == null) {
            return null;
        }
        CmisObject rendDoc = this.session.getObject(this.session.createObjectId(this.fRenditionDocumentId), context);
        if (!(rendDoc instanceof Document)) {
            return null;
        }
        return (Document)rendDoc;
    }

    public ContentStream getContentStream() {
        if (this.objectId == null || this.fStreamId == null) {
            return null;
        }
        ContentStream contentStream = this.session.getBinding().getObjectService().getContentStream(this.session.getRepositoryInfo().getId(), this.objectId, this.fStreamId, null, null, null);
        if (contentStream == null) {
            return null;
        }
        long length = contentStream.getBigLength() == null ? -1L : contentStream.getBigLength().longValue();
        return this.session.getObjectFactory().createContentStream(contentStream.getFileName(), length, contentStream.getMimeType(), contentStream.getStream());
    }
}

