/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime.cache;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.runtime.cache.Cache;

public class CacheImpl
implements Cache,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final float HASHTABLE_LOAD_FACTOR = 0.75f;
    private int cacheSize;
    private LinkedHashMap<String, Map<String, CmisObject>> objectMap;
    private Map<String, String> pathToIdMap;
    private final ReentrantReadWriteLock fLock = new ReentrantReadWriteLock();

    public static Cache newInstance() {
        return new CacheImpl();
    }

    public static Cache newInstance(int cacheSize) {
        return new CacheImpl(cacheSize);
    }

    protected CacheImpl() {
        this(1000);
    }

    protected CacheImpl(int cacheSize) {
        this.cacheSize = cacheSize;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        this.fLock.writeLock().lock();
        try {
            int hashTableCapacity = (int)Math.ceil((float)this.cacheSize / 0.75f) + 1;
            final int cs = this.cacheSize;
            this.objectMap = new LinkedHashMap<String, Map<String, CmisObject>>(hashTableCapacity, 0.75f){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, Map<String, CmisObject>> eldest) {
                    return this.size() > cs;
                }
            };
            this.resetPathCache();
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    public void clear() {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetPathCache() {
        this.fLock.writeLock().lock();
        try {
            this.pathToIdMap = new HashMap<String, String>();
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsId(String objectId, String cacheKey) {
        this.fLock.readLock().lock();
        try {
            if (!this.objectMap.containsKey(objectId)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.objectMap.get(objectId).containsKey(cacheKey);
            return bl;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsPath(String path, String cacheKey) {
        this.fLock.readLock().lock();
        try {
            if (!this.pathToIdMap.containsKey(path)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.containsId(this.pathToIdMap.get(path), cacheKey);
            return bl;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmisObject getById(String objectId, String cacheKey) {
        this.fLock.readLock().lock();
        try {
            Map<String, CmisObject> cacheKeyMap = this.objectMap.get(objectId);
            if (cacheKeyMap == null) {
                CmisObject cmisObject = null;
                return cmisObject;
            }
            CmisObject cmisObject = cacheKeyMap.get(cacheKey);
            return cmisObject;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmisObject getByPath(String path, String cacheKey) {
        this.fLock.readLock().lock();
        try {
            String id = this.pathToIdMap.get(path);
            if (id == null) {
                CmisObject cmisObject = null;
                return cmisObject;
            }
            CmisObject object = this.getById(id, cacheKey);
            if (object == null && !this.objectMap.containsKey(id)) {
                this.fLock.readLock().unlock();
                this.fLock.writeLock().lock();
                try {
                    this.pathToIdMap.remove(path);
                }
                finally {
                    this.fLock.writeLock().unlock();
                    this.fLock.readLock().lock();
                }
            }
            CmisObject cmisObject = object;
            return cmisObject;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(CmisObject object, String cacheKey) {
        if (object == null || cacheKey == null) {
            return;
        }
        if (object.getId() == null) {
            return;
        }
        this.fLock.writeLock().lock();
        try {
            Map<String, CmisObject> cacheKeyMap = this.objectMap.get(object.getId());
            if (cacheKeyMap == null) {
                cacheKeyMap = new HashMap<String, CmisObject>();
                this.objectMap.put(object.getId(), cacheKeyMap);
            }
            cacheKeyMap.put(cacheKey, object);
            String path = (String)object.getPropertyValue("cmis:path");
            if (path != null) {
                this.pathToIdMap.put(path, object.getId());
            }
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putPath(String path, CmisObject object, String cacheKey) {
        this.fLock.writeLock().lock();
        try {
            this.put(object, cacheKey);
            if (object != null && object.getId() != null && cacheKey != null) {
                this.pathToIdMap.put(path, object.getId());
            }
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    public int getCacheSize() {
        return this.cacheSize;
    }
}

