/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime.objecttype;

import java.util.List;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTypeHelper {
    private Session session;
    private ObjectType objectType;
    private ObjectType baseType;
    private ObjectType parentType;

    public ObjectTypeHelper(Session session, ObjectType objectType) {
        this.session = session;
        this.objectType = objectType;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isBaseType() {
        return this.objectType.getParentTypeId() == null;
    }

    public ObjectType getBaseType() {
        if (this.isBaseType()) {
            return null;
        }
        if (this.baseType != null) {
            return this.baseType;
        }
        if (this.objectType.getBaseTypeId() == null) {
            return null;
        }
        this.baseType = this.session.getTypeDefinition(this.objectType.getBaseTypeId().value());
        return this.baseType;
    }

    public ObjectType getParentType() {
        if (this.parentType != null) {
            return this.parentType;
        }
        if (this.objectType.getParentTypeId() == null) {
            return null;
        }
        this.parentType = this.session.getTypeDefinition(this.objectType.getParentTypeId());
        return this.parentType;
    }

    public ItemIterable<ObjectType> getChildren() {
        return this.session.getTypeChildren(this.objectType.getId(), true);
    }

    public List<Tree<ObjectType>> getDescendants(int depth) {
        return this.session.getTypeDescendants(this.objectType.getId(), depth, true);
    }
}

