/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.proxy;

import java.net.MalformedURLException;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.annotations.api.Annotation;
import org.nuxeo.ecm.platform.annotations.api.AnnotationException;
import org.nuxeo.ecm.platform.annotations.api.AnnotationManager;
import org.nuxeo.ecm.platform.annotations.api.AnnotationsService;
import org.nuxeo.ecm.platform.annotations.api.UriResolver;
import org.nuxeo.ecm.platform.annotations.service.AnnotabilityManager;
import org.nuxeo.ecm.platform.annotations.service.AnnotationConfigurationService;
import org.nuxeo.ecm.platform.annotations.service.AnnotationsServiceImpl;
import org.nuxeo.ecm.platform.annotations.service.EventListener;
import org.nuxeo.ecm.platform.annotations.service.PermissionManager;
import org.nuxeo.ecm.platform.annotations.service.URLPatternFilter;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.runtime.api.Framework;

public class AnnotationServiceProxy
implements AnnotationsService {
    private static final Log log = LogFactory.getLog(AnnotationServiceProxy.class);
    private final AnnotationManager annotationManager = new AnnotationManager();
    private AnnotationConfigurationService configurationService;
    private AnnotabilityManager annotabilityManager;
    private AnnotationsServiceImpl service;
    private URLPatternFilter filter;
    private UriResolver resolver;
    private PermissionManager permissionManager;
    private List<EventListener> listeners;

    public void initialise() {
        try {
            this.service = new AnnotationsServiceImpl();
            this.configurationService = (AnnotationConfigurationService)Framework.getService(AnnotationConfigurationService.class);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        this.filter = this.configurationService.getUrlPatternFilter();
        this.resolver = this.configurationService.getUriResolver();
        this.annotabilityManager = this.configurationService.getAnnotabilityManager();
        this.permissionManager = this.configurationService.getPermissionManager();
        this.listeners = this.configurationService.getListeners();
    }

    public Annotation addAnnotation(Annotation annotation, NuxeoPrincipal user, String baseUrl) throws AnnotationException {
        this.checkUrl(annotation);
        Annotation translatedAnnotation = this.getTranslatedAnnotation(annotation);
        if (!this.annotabilityManager.isAnnotable(annotation.getAnnotates())) {
            throw new AnnotationException("Not annotable uri: " + annotation.getAnnotates());
        }
        this.checkPermission(annotation, user, this.configurationService.getCreateAnnotationPermission());
        for (EventListener listener : this.listeners) {
            listener.beforeAnnotationCreated((Principal)user, translatedAnnotation);
        }
        Annotation tmpResult = this.service.addAnnotation(translatedAnnotation, user, baseUrl);
        for (EventListener listener : this.listeners) {
            listener.afterAnnotationCreated((Principal)user, tmpResult);
        }
        return this.annotationManager.translateAnnotationFromRepo(this.resolver, baseUrl, tmpResult);
    }

    private void checkPermission(Annotation annotation, NuxeoPrincipal user, String permission) throws AnnotationException {
        if (!this.permissionManager.check(user, permission, annotation.getAnnotates())) {
            throw new AnnotationException(user + " allowed to query annotation.");
        }
    }

    private Annotation getTranslatedAnnotation(Annotation annotation) throws AnnotationException {
        Annotation translatedAnnotation = this.annotationManager.translateAnnotationToRepo(this.resolver, annotation);
        return translatedAnnotation;
    }

    private void checkUrl(Annotation annotation) throws AnnotationException {
        try {
            String url = annotation.getAnnotates().toURL().toString();
            if (!this.filter.allow(url)) {
                throw new AnnotationException("Not allowed to annoates: " + url);
            }
        }
        catch (MalformedURLException e) {
            throw new AnnotationException((Throwable)e);
        }
    }

    public void deleteAnnotation(Annotation annotation, NuxeoPrincipal user) throws AnnotationException {
        this.checkPermission(annotation, user, this.configurationService.getDeleteAnnotationPermission());
        Annotation translatedAnnotation = this.getTranslatedAnnotation(annotation);
        for (EventListener listener : this.listeners) {
            listener.beforeAnnotationDeleted((Principal)user, translatedAnnotation);
        }
        this.service.deleteAnnotation(translatedAnnotation, user);
        for (EventListener listener : this.listeners) {
            listener.afterAnnotationDeleted((Principal)user, translatedAnnotation);
        }
    }

    public void deleteAnnotationFor(URI uri, Annotation annotation, NuxeoPrincipal user) throws AnnotationException {
        this.checkPermission(annotation, user, this.configurationService.getDeleteAnnotationPermission());
        Annotation translatedAnnotation = this.getTranslatedAnnotation(annotation);
        for (EventListener listener : this.listeners) {
            listener.beforeAnnotationDeleted((Principal)user, translatedAnnotation);
        }
        this.service.deleteAnnotationFor(this.resolver.translateToGraphURI(uri), translatedAnnotation, user);
        for (EventListener listener : this.listeners) {
            listener.afterAnnotationDeleted((Principal)user, translatedAnnotation);
        }
    }

    public Annotation getAnnotation(String annotationId, NuxeoPrincipal user, String baseUrl) throws AnnotationException {
        for (EventListener listener : this.listeners) {
            listener.beforeAnnotationRead((Principal)user, annotationId);
        }
        Annotation result = this.service.getAnnotation(annotationId, user, null);
        this.checkPermission(result, user, this.configurationService.getReadAnnotationPermission());
        for (EventListener listener : this.listeners) {
            listener.afterAnnotationRead((Principal)user, result);
        }
        return this.annotationManager.translateAnnotationFromRepo(this.resolver, baseUrl, result);
    }

    public Graph getAnnotationGraph() throws AnnotationException {
        return this.service.getAnnotationGraph();
    }

    public List<Annotation> queryAnnotations(URI uri, Map<String, String> filters, NuxeoPrincipal user) throws AnnotationException {
        String baseUrl = null;
        if (!uri.toString().startsWith("urn")) {
            baseUrl = this.resolver.getBaseUrl(uri);
        }
        List<Annotation> tempResult = this.service.queryAnnotations(this.resolver.translateToGraphURI(uri), filters, user);
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Annotation annotation : tempResult) {
            Annotation translatedAnnotation = this.annotationManager.translateAnnotationFromRepo(this.resolver, baseUrl, annotation);
            for (EventListener listener : this.listeners) {
                listener.afterAnnotationRead((Principal)user, translatedAnnotation);
            }
            this.checkPermission(translatedAnnotation, user, this.configurationService.getReadAnnotationPermission());
            result.add(translatedAnnotation);
        }
        return result;
    }

    public Annotation updateAnnotation(Annotation annotation, NuxeoPrincipal user, String baseUrl) throws AnnotationException {
        this.checkPermission(annotation, user, this.configurationService.getUpdateAnnotationPermission());
        for (EventListener listener : this.listeners) {
            listener.beforeAnnotationUpdated((Principal)user, annotation);
        }
        Annotation result = this.service.updateAnnotation(this.getTranslatedAnnotation(annotation), user, baseUrl);
        for (EventListener listener : this.listeners) {
            listener.afterAnnotationUpdated((Principal)user, result);
        }
        return this.annotationManager.translateAnnotationFromRepo(this.resolver, baseUrl, result);
    }
}

