/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.metadata;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCFunctionMappingMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCMappingMetaData;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public final class JDBCTypeMappingMetaData {
    private static final String[] PRIMITIVES = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"};
    private static final String[] PRIMITIVE_CLASSES = new String[]{"java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double"};
    public static final String CONCAT = "concat";
    public static final String SUBSTRING = "substring";
    public static final String LCASE = "lcase";
    public static final String UCASE = "ucase";
    public static final String LENGTH = "length";
    public static final String LOCATE = "locate";
    public static final String ABS = "abs";
    public static final String SQRT = "sqrt";
    public static final String COUNT = "count";
    public static final String MOD = "mod";
    public static JDBCFunctionMappingMetaData COUNT_FUNC;
    public static JDBCFunctionMappingMetaData MAX_FUNC;
    public static JDBCFunctionMappingMetaData MIN_FUNC;
    public static JDBCFunctionMappingMetaData AVG_FUNC;
    public static JDBCFunctionMappingMetaData SUM_FUNC;
    private final String name;
    private final HashMap mappings = new HashMap();
    private final HashMap functionMappings = new HashMap();
    private final String aliasHeaderPrefix;
    private final String aliasHeaderSuffix;
    private final int aliasMaxLength;
    private final boolean subquerySupported;
    private final String trueMapping;
    private final String falseMapping;
    private final int maxKeysInDelete;
    private JDBCFunctionMappingMetaData rowLocking = null;
    private JDBCFunctionMappingMetaData fkConstraint = null;
    private JDBCFunctionMappingMetaData pkConstraint = null;
    private JDBCFunctionMappingMetaData autoIncrement = null;
    private JDBCFunctionMappingMetaData addColumn = null;
    private JDBCFunctionMappingMetaData dropColumn = null;
    private JDBCFunctionMappingMetaData alterColumn = null;

    public JDBCTypeMappingMetaData(Element element) throws DeploymentException {
        String alterColumnSQL;
        String fkConstraintSQL;
        String pkConstraintSQL;
        this.name = MetaData.getUniqueChildContent(element, "name");
        String rowLockingSQL = MetaData.getUniqueChildContent(element, "row-locking-template");
        if (rowLockingSQL != null && !rowLockingSQL.trim().equals("")) {
            this.rowLocking = new JDBCFunctionMappingMetaData("row-locking", rowLockingSQL);
        }
        if ((pkConstraintSQL = MetaData.getUniqueChildContent(element, "pk-constraint-template")) != null && !pkConstraintSQL.trim().equals("")) {
            this.pkConstraint = new JDBCFunctionMappingMetaData("pk-constraint", pkConstraintSQL);
        }
        if ((fkConstraintSQL = MetaData.getUniqueChildContent(element, "fk-constraint-template")) != null && !fkConstraintSQL.trim().equals("")) {
            this.fkConstraint = new JDBCFunctionMappingMetaData("fk-constraint", fkConstraintSQL);
        }
        this.addColumn = (alterColumnSQL = MetaData.getOptionalChildContent(element, "add-column-template")) != null && !alterColumnSQL.trim().equals("") ? new JDBCFunctionMappingMetaData("add-column-template", alterColumnSQL) : new JDBCFunctionMappingMetaData("add-column-template", "ALTER TABLE ?1 ADD ?2 ?3");
        alterColumnSQL = MetaData.getOptionalChildContent(element, "alter-column-template");
        this.alterColumn = alterColumnSQL != null && !alterColumnSQL.trim().equals("") ? new JDBCFunctionMappingMetaData("alter-column-template", alterColumnSQL) : new JDBCFunctionMappingMetaData("alter-column-template", "ALTER TABLE ?1 ALTER ?2 TYPE ?3");
        alterColumnSQL = MetaData.getOptionalChildContent(element, "drop-column-template");
        this.dropColumn = alterColumnSQL != null && !alterColumnSQL.trim().equals("") ? new JDBCFunctionMappingMetaData("drop-column-template", alterColumnSQL) : new JDBCFunctionMappingMetaData("drop-column-template", "ALTER TABLE ?1 DROP ?2");
        String autoIncrementSQL = MetaData.getOptionalChildContent(element, "auto-increment-template");
        if (autoIncrementSQL != null && !autoIncrementSQL.trim().equals("")) {
            this.autoIncrement = new JDBCFunctionMappingMetaData("auto-increment", autoIncrementSQL);
        }
        Iterator iterator = MetaData.getChildrenByTagName(element, "mapping");
        while (iterator.hasNext()) {
            Element mappingElement = (Element)iterator.next();
            JDBCMappingMetaData mapping = new JDBCMappingMetaData(mappingElement);
            this.mappings.put(mapping.getJavaType(), mapping);
        }
        this.addDefaultFunctionMapping();
        Iterator functions = MetaData.getChildrenByTagName(element, "function-mapping");
        while (functions.hasNext()) {
            Element mappingElement = (Element)functions.next();
            JDBCFunctionMappingMetaData functionMapping = new JDBCFunctionMappingMetaData(mappingElement);
            this.functionMappings.put(functionMapping.getFunctionName().toLowerCase(), functionMapping);
        }
        this.aliasHeaderPrefix = MetaData.getUniqueChildContent(element, "alias-header-prefix");
        this.aliasHeaderSuffix = MetaData.getUniqueChildContent(element, "alias-header-suffix");
        String aliasMaxLengthString = MetaData.getUniqueChildContent(element, "alias-max-length");
        try {
            this.aliasMaxLength = Integer.parseInt(aliasMaxLengthString);
        }
        catch (NumberFormatException e) {
            throw new DeploymentException("Invalid number format in alias-max-length " + aliasMaxLengthString + "': " + e);
        }
        String subquerySupportedStr = MetaData.getUniqueChildContent(element, "subquery-supported");
        this.subquerySupported = Boolean.valueOf(subquerySupportedStr);
        this.trueMapping = MetaData.getUniqueChildContent(element, "true-mapping");
        this.falseMapping = MetaData.getUniqueChildContent(element, "false-mapping");
        String str = MetaData.getOptionalChildContent(element, "max-keys-in-delete");
        if (str != null) {
            try {
                this.maxKeysInDelete = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                throw new DeploymentException("Failed to parse int value '" + str + "' for max-keys-in-delete", (Throwable)e);
            }
            if (this.maxKeysInDelete < 0) {
                throw new DeploymentException("The value of max-keys-in-delete cannot be less than 0: " + this.maxKeysInDelete);
            }
        } else {
            this.maxKeysInDelete = 0;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getAliasHeaderPrefix() {
        return this.aliasHeaderPrefix;
    }

    public String getAliasHeaderSuffix() {
        return this.aliasHeaderSuffix;
    }

    public int getAliasMaxLength() {
        return this.aliasMaxLength;
    }

    public boolean isSubquerySupported() {
        return this.subquerySupported;
    }

    public String getTrueMapping() {
        return this.trueMapping;
    }

    public String getFalseMapping() {
        return this.falseMapping;
    }

    public int getMaxKeysInDelete() {
        return this.maxKeysInDelete;
    }

    public JDBCMappingMetaData getTypeMappingMetaData(Class type) {
        JDBCMappingMetaData mapping;
        String javaType = type.getName();
        for (int i = 0; i < PRIMITIVES.length; ++i) {
            if (!javaType.equals(PRIMITIVES[i])) continue;
            javaType = PRIMITIVE_CLASSES[i];
            break;
        }
        if ((mapping = (JDBCMappingMetaData)this.mappings.get(javaType)) == null) {
            mapping = (JDBCMappingMetaData)this.mappings.get("java.lang.Object");
        }
        return mapping;
    }

    public JDBCFunctionMappingMetaData getFunctionMapping(String name) {
        JDBCFunctionMappingMetaData funcMapping = (JDBCFunctionMappingMetaData)this.functionMappings.get(name.toLowerCase());
        if (funcMapping == null) {
            throw new IllegalStateException("Function " + name + " is not defined for " + this.name);
        }
        return funcMapping;
    }

    public JDBCFunctionMappingMetaData getRowLockingTemplate() {
        return this.rowLocking;
    }

    public JDBCFunctionMappingMetaData getPkConstraintTemplate() {
        return this.pkConstraint;
    }

    public JDBCFunctionMappingMetaData getFkConstraintTemplate() {
        return this.fkConstraint;
    }

    public JDBCFunctionMappingMetaData getAutoIncrementTemplate() {
        return this.autoIncrement;
    }

    public JDBCFunctionMappingMetaData getAddColumnTemplate() {
        return this.addColumn;
    }

    public JDBCFunctionMappingMetaData getDropColumnTemplate() {
        return this.dropColumn;
    }

    public JDBCFunctionMappingMetaData getAlterColumnTemplate() {
        return this.alterColumn;
    }

    public Collection getMappings() {
        return this.mappings.values();
    }

    private void addDefaultFunctionMapping() throws DeploymentException {
        JDBCFunctionMappingMetaData function = new JDBCFunctionMappingMetaData(CONCAT, new String[]{"{fn concat(", ", ", ")}"}, new int[]{0, 1});
        this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
        function = new JDBCFunctionMappingMetaData(SUBSTRING, new String[]{"{fn substring(", ", ", ", ", ")}"}, new int[]{0, 1, 2});
        this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
        function = new JDBCFunctionMappingMetaData(LCASE, new String[]{"{fn lcase(", ")}"}, new int[]{0});
        this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
        function = new JDBCFunctionMappingMetaData(UCASE, new String[]{"{fn ucase(", ")}"}, new int[]{0});
        this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
        function = new JDBCFunctionMappingMetaData(LENGTH, new String[]{"{fn length(", ")}"}, new int[]{0});
        this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
        function = new JDBCFunctionMappingMetaData(LOCATE, new String[]{"{fn locate(", ", ", ", ", ")}"}, new int[]{0, 1, 2});
        this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
        function = new JDBCFunctionMappingMetaData(ABS, new String[]{"{fn abs(", ")}"}, new int[]{0});
        this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
        function = new JDBCFunctionMappingMetaData(SQRT, new String[]{"{fn sqrt(", ")}"}, new int[]{0});
        this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
        function = new JDBCFunctionMappingMetaData(MOD, "mod(?1, ?2)");
        this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
    }

    static {
        try {
            COUNT_FUNC = new JDBCFunctionMappingMetaData(COUNT, "count(?1 ?2)");
            MAX_FUNC = new JDBCFunctionMappingMetaData("max", "max(?1 ?2)");
            MIN_FUNC = new JDBCFunctionMappingMetaData("min", "min(?1 ?2)");
            AVG_FUNC = new JDBCFunctionMappingMetaData("avg", "avg(?1 ?2)");
            SUM_FUNC = new JDBCFunctionMappingMetaData("sum", "sum(?1 ?2)");
        }
        catch (DeploymentException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }
}

