/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ActionFilter;
import org.nuxeo.ecm.platform.actions.ActionFilterRegistry;
import org.nuxeo.ecm.platform.actions.ActionRegistry;
import org.nuxeo.ecm.platform.actions.DefaultActionFilter;
import org.nuxeo.ecm.platform.actions.FilterFactory;
import org.nuxeo.ecm.platform.actions.FilterRule;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class ActionService
extends DefaultComponent
implements ActionManager {
    public static final ComponentName ID = new ComponentName("org.nuxeo.ecm.platform.actions.ActionService");
    private static final long serialVersionUID = -5256555810901945824L;
    private static final Log log = LogFactory.getLog(ActionService.class);
    private ActionRegistry actionReg;
    private ActionFilterRegistry filterReg;

    public void activate(ComponentContext context) {
        this.actionReg = new ActionRegistry();
        this.filterReg = new ActionFilterRegistry();
    }

    public void deactivate(ComponentContext context) {
        this.actionReg = null;
        this.filterReg = null;
    }

    public ActionRegistry getActionRegistry() {
        return this.actionReg;
    }

    public ActionFilterRegistry getFilterRegistry() {
        return this.filterReg;
    }

    private void applyFilters(ActionContext context, List<Action> actions) {
        Iterator<Action> it = actions.iterator();
        block0: while (it.hasNext()) {
            Action action = it.next();
            for (String filterId : action.getFilterIds()) {
                ActionFilter filter = this.filterReg.getFilter(filterId);
                if (filter == null || filter.accept(action, context)) continue;
                it.remove();
                continue block0;
            }
        }
    }

    @Override
    public List<Action> getActions(String category, ActionContext context) {
        return this.getActions(category, context, true);
    }

    @Override
    public List<Action> getAllActions(String category) {
        return this.actionReg.getActions(category);
    }

    @Override
    public List<Action> getActions(String category, ActionContext context, boolean hideUnavailableActions) {
        List<Action> actions = this.actionReg.getActions(category);
        if (hideUnavailableActions) {
            this.applyFilters(context, actions);
            Collections.sort(actions);
            return actions;
        }
        ArrayList<Action> allActions = new ArrayList<Action>();
        allActions.addAll(actions);
        this.applyFilters(context, actions);
        for (Action a : allActions) {
            a.setAvailable(actions.contains(a));
        }
        Collections.sort(allActions);
        return allActions;
    }

    @Override
    public Action getAction(String actionId) {
        return this.actionReg.getAction(actionId);
    }

    @Override
    public boolean isRegistered(String actionId) {
        return this.actionReg.getAction(actionId) != null;
    }

    @Override
    public boolean isEnabled(String actionId, ActionContext context) {
        Action action = this.actionReg.getAction(actionId);
        if (action != null) {
            return this.isEnabled(action, context);
        }
        return false;
    }

    public boolean isEnabled(Action action, ActionContext context) {
        for (String filterId : action.getFilterIds()) {
            ActionFilter filter = this.filterReg.getFilter(filterId);
            if (filter == null || filter.accept(action, context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ActionFilter[] getFilters(String actionId) {
        Action action = this.actionReg.getAction(actionId);
        if (action == null) {
            return null;
        }
        List<String> filterIds = action.getFilterIds();
        if (filterIds != null && !filterIds.isEmpty()) {
            ActionFilter[] filters = new ActionFilter[filterIds.size()];
            for (int i = 0; i < filters.length; ++i) {
                String filterId = filterIds.get(i);
                filters[i] = this.filterReg.getFilter(filterId);
            }
            return filters;
        }
        return null;
    }

    public void registerExtension(Extension extension) {
        String xp = extension.getExtensionPoint();
        if (xp.equals("actions")) {
            this.registerActionExtension(extension);
        } else if (xp.equals("filters")) {
            this.registerFilterExtension(extension);
        }
    }

    public void unregisterExtension(Extension extension) {
        String xp = extension.getExtensionPoint();
        if (xp.equals("actions")) {
            this.unregisterActionExtension(extension);
        } else if (xp.equals("filters")) {
            this.unregisterFilterExtension(extension);
        }
    }

    public void registerFilterExtension(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            ActionFilter filter;
            if (contrib.getClass() == FilterFactory.class) {
                FilterFactory ff = (FilterFactory)contrib;
                this.filterReg.removeFilter(ff.id);
                try {
                    filter = (ActionFilter)Thread.currentThread().getContextClassLoader().loadClass(ff.className).newInstance();
                    filter.setId(ff.id);
                    this.filterReg.addFilter(filter);
                }
                catch (Exception e) {
                    log.error((Object)"Failed to create action filter", (Throwable)e);
                }
                continue;
            }
            filter = (ActionFilter)contrib;
            if (this.filterReg.getFilter(filter.getId()) != null) {
                DefaultActionFilter newFilter = (DefaultActionFilter)filter;
                DefaultActionFilter oldFilter = (DefaultActionFilter)this.filterReg.getFilter(filter.getId());
                if (newFilter.getAppend()) {
                    ArrayList<FilterRule> mergedRules = new ArrayList<FilterRule>();
                    mergedRules.addAll(Arrays.asList(oldFilter.getRules()));
                    mergedRules.addAll(Arrays.asList(newFilter.getRules()));
                    oldFilter.setRules(mergedRules.toArray(new FilterRule[mergedRules.size()]));
                    continue;
                }
                this.filterReg.removeFilter(filter.getId());
                this.filterReg.addFilter(filter);
                continue;
            }
            this.filterReg.addFilter(filter);
        }
    }

    public void unregisterFilterExtension(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            if (contrib.getClass() == FilterFactory.class) {
                this.filterReg.removeFilter(((FilterFactory)contrib).id);
                continue;
            }
            this.filterReg.removeFilter(((ActionFilter)contrib).getId());
        }
    }

    public void registerActionExtension(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            List<String> actionFilterIds;
            Action action = (Action)contrib;
            String actionId = action.getId();
            Action existingAction = this.actionReg.getAction(actionId);
            if (existingAction != null) {
                log.debug((Object)("Upgrading web action with id " + actionId));
                action = ActionService.mergeActions(existingAction, action);
                this.actionReg.removeAction(actionId);
            }
            ArrayList<String> filterIds = new ArrayList<String>();
            ActionFilter[] filters = action.getFilters();
            if (filters != null) {
                for (ActionFilter filter : filters) {
                    this.filterReg.removeFilter(filter.getId());
                    this.filterReg.addFilter(filter);
                    filterIds.add(filter.getId());
                }
                action.setFilters(null);
            }
            if ((actionFilterIds = action.getFilterIds()) == null) {
                action.setFilterIds(filterIds);
            } else {
                actionFilterIds.addAll(filterIds);
                action.setFilterIds(actionFilterIds);
            }
            if (action.getLabel() == null) {
                action.setLabel(actionId);
            }
            this.actionReg.addAction(action);
        }
    }

    public void unregisterActionExtension(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            Action action = (Action)contrib;
            this.actionReg.removeAction(action.getId());
        }
    }

    protected static Action mergeActions(Action existingOne, Action newOne) {
        int newOrder;
        String tooltip;
        String newConfirm;
        String newLink;
        String newIcon = newOne.getIcon();
        if (newIcon != null && !newIcon.equals(existingOne.getIcon())) {
            existingOne.setIcon(newIcon);
        }
        if (newOne.isEnabled() != existingOne.isEnabled()) {
            existingOne.setEnabled(newOne.isEnabled());
        }
        HashSet<String> mergedCategories = new HashSet<String>(Arrays.asList(existingOne.getCategories()));
        mergedCategories.addAll(new HashSet<String>(Arrays.asList(newOne.getCategories())));
        existingOne.setCategories(mergedCategories.toArray(new String[mergedCategories.size()]));
        String newLabel = newOne.getLabel();
        if (newLabel != null && !newLabel.equals(existingOne.getLabel())) {
            existingOne.setLabel(newLabel);
        }
        if ((newLink = newOne.getLink()) != null && !newLink.equals(existingOne.getLink())) {
            existingOne.setLink(newLink);
        }
        if ((newConfirm = newOne.getConfirm()) != null && !newConfirm.equals(existingOne.getConfirm())) {
            existingOne.setConfirm(newConfirm);
        }
        if ((tooltip = newOne.getHelp()) != null && !tooltip.equals(existingOne.getHelp())) {
            existingOne.setHelp(tooltip);
        }
        if ((newOrder = newOne.getOrder()) > 0 && newOrder != existingOne.getOrder()) {
            existingOne.setOrder(newOrder);
        }
        List<String> newFilterIds = newOne.getFilterIds();
        newFilterIds.addAll(existingOne.getFilterIds());
        existingOne.setFilterIds(newFilterIds);
        ActionFilter[] newFilters = newOne.getFilters();
        if (newFilters != null) {
            existingOne.setFilters(newFilters);
        }
        return existingOne;
    }

    @Override
    public void remove() {
    }
}

