/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.actions;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ActionFilter;
import org.nuxeo.ecm.platform.actions.FilterRule;
import org.nuxeo.ecm.platform.actions.elcache.CachedJEXLManager;
import org.nuxeo.runtime.expression.Context;
import org.nuxeo.runtime.expression.JexlExpression;

@XObject(value="filter")
public class DefaultActionFilter
implements ActionFilter {
    private static final long serialVersionUID = 8885038533939001747L;
    private static final Log log = LogFactory.getLog(DefaultActionFilter.class);
    @XNode(value="@id")
    private String id;
    @XNode(value="@append")
    private boolean append;
    @XNodeList(value="rule", type=String[].class, componentType=FilterRule.class)
    private FilterRule[] rules;
    protected static final String PRECOMPUTED_KEY = "PrecomputedFilters";

    public DefaultActionFilter() {
        this(null, null, false);
    }

    public DefaultActionFilter(String id, FilterRule[] rules) {
        this(id, rules, false);
    }

    public DefaultActionFilter(String id, FilterRule[] rules, boolean append) {
        this.id = id;
        this.rules = rules;
        this.append = append;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public FilterRule[] getRules() {
        return this.rules;
    }

    public void setRules(FilterRule[] rules) {
        this.rules = rules;
    }

    @Override
    public boolean accept(Action action, ActionContext context) {
        if (context == null) {
            return false;
        }
        if (this.rules == null || this.rules.length == 0) {
            return true;
        }
        boolean existsGrantRule = false;
        boolean grantApply = false;
        for (FilterRule rule : this.rules) {
            boolean ruleApplies = this.checkRule(rule, action, context);
            if (!rule.grant) {
                if (!ruleApplies) continue;
                return false;
            }
            existsGrantRule = true;
            if (!ruleApplies) continue;
            grantApply = true;
        }
        if (existsGrantRule) {
            return grantApply;
        }
        return true;
    }

    protected final boolean checkRule(FilterRule rule, Action action, ActionContext context) {
        HashMap<FilterRule, Boolean> precomputed = (HashMap<FilterRule, Boolean>)context.get(PRECOMPUTED_KEY);
        if (precomputed == null) {
            precomputed = new HashMap<FilterRule, Boolean>();
            context.put(PRECOMPUTED_KEY, precomputed);
        } else if (precomputed.containsKey(rule)) {
            return (Boolean)precomputed.get(rule);
        }
        boolean result = !(rule.facets != null && rule.facets.length != 0 && !this.checkFacets(action, context, rule.facets) || rule.types != null && rule.types.length != 0 && !this.checkTypes(action, context, rule.types) || rule.schemas != null && rule.schemas.length != 0 && !this.checkSchemas(action, context, rule.schemas) || rule.permissions != null && rule.permissions.length != 0 && !this.checkPermissions(action, context, rule.permissions) || rule.groups != null && rule.groups.length != 0 && !this.checkGroups(action, context, rule.groups) || rule.conditions != null && rule.conditions.length != 0 && !this.checkConditions(action, context, rule.conditions));
        precomputed.put(rule, result);
        return result;
    }

    protected final boolean checkFacets(Action action, ActionContext context, String[] facets) {
        DocumentModel doc = context.getCurrentDocument();
        if (doc == null) {
            return false;
        }
        for (String facet : facets) {
            if (!doc.hasFacet(facet)) continue;
            return true;
        }
        return false;
    }

    protected final boolean checkPermissions(Action action, ActionContext context, String[] permissions) {
        DocumentModel doc = context.getCurrentDocument();
        if (doc == null) {
            NuxeoPrincipal principal = context.getCurrentPrincipal();
            return principal != null && principal.isAdministrator();
        }
        CoreSession docMgr = context.getDocumentManager();
        if (docMgr == null) {
            return false;
        }
        for (String permission : permissions) {
            try {
                if (!docMgr.hasPermission(doc.getRef(), permission)) continue;
                return true;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return false;
    }

    protected final boolean checkGroups(Action action, ActionContext context, String[] groups) {
        NuxeoPrincipal principal = context.getCurrentPrincipal();
        if (principal == null) {
            return false;
        }
        List principalGroups = principal.getGroups();
        for (String group : groups) {
            if (!principalGroups.contains(group)) continue;
            return true;
        }
        return false;
    }

    protected final boolean checkConditions(Action action, ActionContext context, String[] conditions) {
        DocumentModel doc = context.getCurrentDocument();
        NuxeoPrincipal currentPrincipal = context.getCurrentPrincipal();
        int i$ = 0;
        String[] arr$ = conditions;
        int len$ = arr$.length;
        if (i$ < len$) {
            String condition = arr$[i$];
            try {
                JexlExpression exp = CachedJEXLManager.getExpression(condition);
                Context ctx = new Context();
                ctx.put("document", (Object)doc);
                ctx.put("principal", (Object)currentPrincipal);
                for (String k : context.keySet()) {
                    ctx.put(k, context.get(k));
                }
                ctx.put("SeamContext", context.get("SeamContext"));
                Object eval = exp.eval(ctx);
                if (eval == null) {
                    log.error((Object)("evaluation of condition " + condition + " failed: returning false"));
                }
                return Boolean.TRUE.equals(eval);
            }
            catch (Exception e) {
                log.error((Object)("evaluation of condition " + condition + " failed: returning false"), (Throwable)e);
                return false;
            }
        }
        return false;
    }

    protected final boolean checkTypes(Action action, ActionContext context, String[] types) {
        DocumentModel doc = context.getCurrentDocument();
        String docType = doc == null ? "Root" : doc.getType();
        for (String type : types) {
            if (!type.equals(docType)) continue;
            return true;
        }
        return false;
    }

    protected final boolean checkSchemas(Action action, ActionContext context, String[] schemas) {
        DocumentModel doc = context.getCurrentDocument();
        if (doc == null) {
            return false;
        }
        for (String schema : schemas) {
            if (!doc.hasSchema(schema)) continue;
            return true;
        }
        return false;
    }

    public boolean getAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }
}

