/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import org.apache.chemistry.opencmis.client.bindings.spi.CmisSpi;
import org.apache.chemistry.opencmis.client.bindings.spi.CmisSpiFactory;
import org.apache.chemistry.opencmis.client.bindings.spi.Session;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AclServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.DiscoveryServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.MultiFilingServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.NavigationServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.ObjectServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.PolicyServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.PortProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.RelationshipServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.RepositoryServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.VersioningServiceImpl;
import org.apache.chemistry.opencmis.commons.spi.AclService;
import org.apache.chemistry.opencmis.commons.spi.DiscoveryService;
import org.apache.chemistry.opencmis.commons.spi.MultiFilingService;
import org.apache.chemistry.opencmis.commons.spi.NavigationService;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;
import org.apache.chemistry.opencmis.commons.spi.PolicyService;
import org.apache.chemistry.opencmis.commons.spi.RelationshipService;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;
import org.apache.chemistry.opencmis.commons.spi.VersioningService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CmisWebServicesSpi
implements CmisSpiFactory,
CmisSpi {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(CmisWebServicesSpi.class);
    private RepositoryService repositoryService;
    private NavigationService navigationService;
    private ObjectService objectService;
    private VersioningService versioningService;
    private DiscoveryService discoveryService;
    private MultiFilingService multiFilingService;
    private RelationshipService relationshipService;
    private PolicyService policyService;
    private AclService aclService;

    public CmisSpi getSpiInstance(Session session) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing Web Services SPI...");
        }
        PortProvider portProvider = new PortProvider(session);
        this.repositoryService = new RepositoryServiceImpl(session, portProvider);
        this.navigationService = new NavigationServiceImpl(session, portProvider);
        this.objectService = new ObjectServiceImpl(session, portProvider);
        this.versioningService = new VersioningServiceImpl(session, portProvider);
        this.discoveryService = new DiscoveryServiceImpl(session, portProvider);
        this.multiFilingService = new MultiFilingServiceImpl(session, portProvider);
        this.relationshipService = new RelationshipServiceImpl(session, portProvider);
        this.policyService = new PolicyServiceImpl(session, portProvider);
        this.aclService = new AclServiceImpl(session, portProvider);
        return this;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public NavigationService getNavigationService() {
        return this.navigationService;
    }

    public ObjectService getObjectService() {
        return this.objectService;
    }

    public DiscoveryService getDiscoveryService() {
        return this.discoveryService;
    }

    public VersioningService getVersioningService() {
        return this.versioningService;
    }

    public MultiFilingService getMultiFilingService() {
        return this.multiFilingService;
    }

    public RelationshipService getRelationshipService() {
        return this.relationshipService;
    }

    public PolicyService getPolicyService() {
        return this.policyService;
    }

    public AclService getAclService() {
        return this.aclService;
    }

    public void clearAllCaches() {
    }

    public void clearRepositoryCache(String repositoryId) {
    }

    public void close() {
    }
}

