/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import com.google.caja.ancillary.servlet.BadInputException;
import com.google.caja.ancillary.servlet.Content;
import com.google.caja.ancillary.servlet.HelpPage;
import com.google.caja.ancillary.servlet.IndexPage;
import com.google.caja.ancillary.servlet.Input;
import com.google.caja.ancillary.servlet.Job;
import com.google.caja.ancillary.servlet.Processor;
import com.google.caja.ancillary.servlet.Reporter;
import com.google.caja.ancillary.servlet.Request;
import com.google.caja.ancillary.servlet.Result;
import com.google.caja.ancillary.servlet.StaticFiles;
import com.google.caja.ancillary.servlet.UploadPage;
import com.google.caja.ancillary.servlet.Verb;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.HtmlQuasiBuilder;
import com.google.caja.parser.html.Nodes;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.util.ContentType;
import com.google.caja.util.Lists;
import com.google.caja.util.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CajaWebToolsServlet
extends HttpServlet {
    private static final long serialVersionUID = -5232422153254165200L;
    final StaticFiles staticFiles;
    private final Pattern staticFilePath;

    public CajaWebToolsServlet(String cacheId) {
        this.staticFiles = new StaticFiles(cacheId);
        this.staticFilePath = Pattern.compile("^/(?:(favicon\\.ico)|" + Pattern.quote("files-" + cacheId) + "/((?:[^/.]+/)*[^/.]+(?:\\.[^/.]+)))$");
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String reqPath = req.getPathInfo();
        if (null == reqPath || "/".equals(reqPath)) {
            try {
                String query = req.getQueryString();
                URI indexUri = new URI(null, null, Verb.INDEX.relRequestPath, query, null);
                resp.sendRedirect(indexUri.toString());
            }
            catch (URISyntaxException ex) {
                ex.printStackTrace();
            }
            return;
        }
        Matcher m = this.staticFilePath.matcher(reqPath);
        if (m.matches()) {
            String path = m.group(2);
            if (path == null) {
                path = m.group(1);
            }
            this.staticFiles.serve("files/" + path, req, resp);
        } else {
            this.process(reqPath, req.getQueryString(), resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String reqPath = req.getPathInfo();
        if ("/upload".equals(reqPath)) {
            UploadPage.doUpload(req, resp);
            return;
        }
        StringBuilder query = new StringBuilder();
        BufferedReader in = req.getReader();
        try {
            int n;
            char[] buf = new char[1024];
            while ((n = in.read(buf)) > 0) {
                query.append(buf, 0, n);
            }
        }
        finally {
            ((Reader)in).close();
        }
        this.process(reqPath, query.toString(), resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(String reqPath, String query, HttpServletResponse out) throws IOException {
        String contentType;
        Result result = this.handle(reqPath, CajaWebToolsServlet.parseQueryString(query));
        if (result.status != 0) {
            out.setStatus(result.status);
        }
        if ((contentType = result.getContentType()) != null) {
            out.setContentType(contentType);
        }
        for (Pair<String, String> header : result.headers) {
            if (CajaWebToolsServlet.containsControlChar((String)header.b)) {
                throw new IOException("Split header <<" + header + ">>");
            }
            out.setHeader((String)header.a, (String)header.b);
        }
        if (result.content != null) {
            if (result.content.isText()) {
                PrintWriter w = out.getWriter();
                try {
                    result.content.toWriter(w);
                }
                finally {
                    ((Writer)w).close();
                }
            }
            ServletOutputStream os = out.getOutputStream();
            try {
                result.content.toOutputStream((OutputStream)os);
            }
            finally {
                os.close();
            }
        }
    }

    private static List<Pair<String, String>> parseQueryString(String query) {
        List<Pair<String, String>> out = Lists.newArrayList();
        if (query != null) {
            if (query.startsWith("?")) {
                query = query.substring(1);
            }
            if (!"".equals(query)) {
                for (String kv : query.split("&")) {
                    int eq = kv.indexOf(61);
                    if (eq >= 0) {
                        out.add(Pair.pair(CajaWebToolsServlet.uriDecode(kv.substring(0, eq)), CajaWebToolsServlet.uriDecode(kv.substring(eq + 1))));
                        continue;
                    }
                    out.add(Pair.pair(CajaWebToolsServlet.uriDecode(kv), ""));
                }
            }
        }
        return out;
    }

    private static String uriDecode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    Result handle(String reqPath, List<Pair<String, String>> params) {
        List<Job> jobs;
        Verb verb;
        SimpleMessageQueue mq = new SimpleMessageQueue();
        Request req = null;
        if (reqPath.startsWith("/") && (verb = Verb.fromRelReqPath(reqPath.substring(1))) != null) {
            req = Request.create(verb, this.staticFiles);
        }
        if (req == null) {
            return this.errorPage(404, "File not found " + reqPath + ".  Expected a path in " + EnumSet.allOf(Verb.class), mq, new Request());
        }
        List<Job> inputJobs = Lists.newArrayList();
        Processor p = new Processor(req, mq);
        try {
            Verb v = req.verb;
            for (Pair<String, String> cgiParam : params) {
                String name = (String)cgiParam.a;
                String value = (String)cgiParam.b;
                if ("".equals(value)) continue;
                Request.handler(v, name).handle(name, value, req);
            }
            for (Input input : req.inputs) {
                if ("".equals(input.code.trim())) continue;
                InputSource is = new InputSource((req.baseUri != null ? req.baseUri : URI.create("src:///")).resolve(input.path));
                CharProducer cp = CharProducer.Factory.fromString((CharSequence)input.code, is);
                req.srcMap.put(is, cp.clone());
                req.mc.addInputSource(is);
                URI baseUri = req.baseUri != null ? req.baseUri : is.getUri();
                try {
                    inputJobs.add(p.parse(cp, input.t, null, baseUri));
                }
                catch (ParseException ex) {
                    ex.toMessageQueue(mq);
                }
            }
        }
        catch (BadInputException ex) {
            return this.errorPage(ex.getMessage(), mq, req);
        }
        if (req.verb == Verb.INDEX) {
            jobs = Collections.singletonList(Job.html(IndexPage.render(req), null));
        } else if (req.verb == Verb.HELP) {
            jobs = Collections.singletonList(Job.html(HelpPage.render(this.staticFiles), null));
        } else {
            try {
                jobs = p.process(inputJobs);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return this.errorPage(ex.getMessage(), mq, req);
            }
            if (jobs.isEmpty() && !inputJobs.isEmpty()) {
                return this.errorPage(null, mq, req);
            }
        }
        Content content = p.reduce(jobs);
        if (MessageLevel.ERROR.compareTo(CajaWebToolsServlet.maxMessageLevel(mq)) < 0) {
            return this.errorPage(null, mq, req);
        }
        Result result = new Result(200, content, mq);
        if (req.verb == Verb.ECHO) {
            String downloadPath = null;
            if (req.inputs.size() == 1) {
                downloadPath = req.inputs.get((int)0).path;
            }
            if (downloadPath == null || "".equals(downloadPath) || downloadPath.startsWith("unnamed-") || CajaWebToolsServlet.containsControlChar(downloadPath)) {
                downloadPath = "caja_tools_output." + content.type.ext;
            }
            result.headers.add(Pair.pair("Content-disposition", "attachment; filename=" + CajaWebToolsServlet.rfc822QuotedString(downloadPath)));
        }
        return result;
    }

    private static MessageLevel maxMessageLevel(MessageQueue mq) {
        MessageLevel max = MessageLevel.values()[0];
        for (Message msg : mq.getMessages()) {
            MessageLevel lvl = msg.getMessageLevel();
            if (max.compareTo(lvl) >= 0) continue;
            max = lvl;
        }
        return max;
    }

    private Result errorPage(String title, MessageQueue mq, Request req) {
        return this.errorPage(400, title, mq, req);
    }

    private Result errorPage(int status, String title, MessageQueue mq, Request req) {
        Document doc = DomParser.makeDocument(null, null);
        HtmlQuasiBuilder b = HtmlQuasiBuilder.getBuilder(doc);
        DocumentFragment messages = Reporter.messagesToFragment(mq, req, b);
        Node errorDoc = b.substV("<html><head><meta http-equiv=Content-Type content=text/html;charset=UTF-8 /><title>@title</title></head><body>@header@messages</body></html>", "title", title != null ? title : "Errors in input", "header", title != null ? b.substV("<h1>@t</h1>", "t", title) : "", "messages", messages);
        Content errorHtml = new Content(Nodes.render(errorDoc), ContentType.HTML);
        return new Result(status, errorHtml, mq);
    }

    private static boolean containsControlChar(String s) {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            if (s.charAt(i) >= ' ' || s.charAt(i) == '\t') continue;
            return true;
        }
        return false;
    }

    private static String rfc822QuotedString(String s) {
        int n = s.length();
        StringBuilder sb = new StringBuilder(n + 16);
        sb.append('\"');
        int pos = 0;
        for (int i = 0; i < n; ++i) {
            char ch = s.charAt(i);
            if (ch != '\"' && ch != '\\') continue;
            sb.append(s, pos, i).append('\\');
            pos = i;
        }
        sb.append(s, pos, n).append('\"');
        return sb.toString();
    }
}

