/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.demos.playground;

import com.google.caja.demos.playground.client.CajolingServiceResult;
import com.google.caja.demos.playground.server.GWTCajolingServiceImpl;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.util.CajaTestCase;

public class GWTCajolingServiceImplTest
extends CajaTestCase {
    private GWTCajolingServiceImpl service;

    protected void setUp() throws Exception {
        super.setUp();
        this.service = new GWTCajolingServiceImpl();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.service = null;
    }

    private void assertCajoles(String uri, String content) {
        CajolingServiceResult result = this.service.cajole(null, uri, content, false);
        GWTCajolingServiceImplTest.assertTrue((result.getHtml() != null ? 1 : 0) != 0);
    }

    private void assertFailsWithError(String uri, String content, MessageLevel lvl) {
        CajolingServiceResult result = this.service.cajole(null, uri, content, false);
        GWTCajolingServiceImplTest.assertNull((Object)result.getHtml());
        GWTCajolingServiceImplTest.assertNull((Object)result.getJavascript());
        for (String message : result.getMessages()) {
            if (!message.startsWith(lvl.name())) continue;
            return;
        }
    }

    public final void testSimpleCajoling() {
        this.assertCajoles("http://foo/baz.html", "<script>var a=1;</script>");
    }

    public final void testErrorReporting() {
        this.assertFailsWithError("http://foo/bar.html", "<script>var a=b[];</script>", MessageLevel.ERROR);
    }
}

