/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.demos.playground.client;

import com.google.caja.demos.playground.client.CajolingServiceResult;
import com.google.caja.demos.playground.client.PlaygroundService;
import com.google.caja.demos.playground.client.PlaygroundServiceAsync;
import com.google.caja.demos.playground.client.ui.PlaygroundView;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.HistoryListener;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class Playground
implements EntryPoint,
HistoryListener {
    private PlaygroundView gui;
    private PlaygroundServiceAsync cajolingService = (PlaygroundServiceAsync)GWT.create(PlaygroundService.class);

    public void loadSource(String url) {
        this.loadSource(Window.Location.getHref(), url);
    }

    public void loadSource(String base, String url) {
        this.gui.setLoading(true);
        this.gui.setUrl(url);
        if (!url.equals(History.getToken())) {
            History.newItem((String)url);
        }
        this.cajolingService.fetch(base, url, new AsyncCallback<String>(){

            public void onFailure(Throwable caught) {
                Playground.this.gui.setLoading(false);
                Playground.this.gui.addCompileMessage(caught.getMessage());
                Playground.this.gui.selectTab(PlaygroundView.Tabs.COMPILE_WARNINGS);
            }

            public void onSuccess(String result) {
                Playground.this.gui.setLoading(false);
                Playground.this.gui.setOriginalSource(result);
                Playground.this.gui.setCajoledSource("", "");
                Playground.this.gui.selectTab(PlaygroundView.Tabs.SOURCE);
            }
        });
    }

    public void clearPolicy() {
        this.gui.setPolicySource("");
    }

    public void loadPolicy(String url) {
        this.gui.setLoading(true);
        this.gui.setPolicyUrl(url);
        this.cajolingService.fetch(Window.Location.getHref(), url, new AsyncCallback<String>(){

            public void onFailure(Throwable caught) {
                Playground.this.gui.setLoading(false);
                Playground.this.gui.addCompileMessage(caught.getMessage());
                Playground.this.gui.selectTab(PlaygroundView.Tabs.COMPILE_WARNINGS);
            }

            public void onSuccess(String result) {
                Playground.this.gui.setLoading(false);
                Playground.this.gui.setPolicySource(result);
                Playground.this.gui.selectTab(PlaygroundView.Tabs.POLICY);
            }
        });
    }

    public void cajole(String uri, String input, final String policy, boolean debugMode) {
        this.gui.setLoading(true);
        this.cajolingService.cajole(Window.Location.getHref(), uri, input, debugMode, new AsyncCallback<CajolingServiceResult>(){

            public void onFailure(Throwable caught) {
                Playground.this.gui.setLoading(false);
                Playground.this.gui.addCompileMessage(caught.getMessage());
            }

            public void onSuccess(CajolingServiceResult result) {
                Playground.this.gui.setLoading(false);
                if (result == null) {
                    Playground.this.gui.addCompileMessage("An unknown error occurred");
                    Playground.this.gui.selectTab(PlaygroundView.Tabs.COMPILE_WARNINGS);
                    return;
                }
                for (String message : result.getMessages()) {
                    Playground.this.gui.addCompileMessage(message);
                }
                if (result.getHtml() != null) {
                    Playground.this.gui.setCajoledSource(result.getHtml(), result.getJavascript());
                    Playground.this.gui.setRenderedResult(policy, result.getHtml(), result.getJavascript());
                    Playground.this.gui.selectTab(PlaygroundView.Tabs.RENDER);
                } else {
                    Playground.this.gui.setCajoledSource(null, null);
                    Playground.this.gui.setRenderedResult(null, null, null);
                    Playground.this.gui.selectTab(PlaygroundView.Tabs.COMPILE_WARNINGS);
                }
            }
        });
    }

    public void onHistoryChanged(String historyToken) {
        if (null == historyToken || "".equals(historyToken)) {
            return;
        }
        this.loadSource(historyToken);
    }

    public void onModuleLoad() {
        this.gui = new PlaygroundView(this);
        this.gui.setLoading(true);
        this.cajolingService.getBuildInfo(new AsyncCallback<String>(){

            public void onFailure(Throwable caught) {
                Playground.this.gui.setLoading(false);
                Playground.this.gui.addCompileMessage(caught.getMessage());
                Playground.this.gui.setVersion("Unknown");
            }

            public void onSuccess(String result) {
                Playground.this.gui.setLoading(false);
                Playground.this.gui.setVersion(result);
            }
        });
        History.addHistoryListener((HistoryListener)this);
        History.fireCurrentHistoryState();
    }
}

