/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lang.css;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.config.AllowedFileResolver;
import com.google.caja.config.ConfigUtil;
import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.css.JSRE;
import com.google.caja.lexer.CssLexer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.AbstractParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.css.CssPropertySignature;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.parser.js.BooleanLiteral;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.MultiDeclaration;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.RegexpLiteral;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.ValueProperty;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.reporting.EchoingMessageQueue;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.RenderContext;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.tools.BuildCommand;
import com.google.caja.util.Bag;
import com.google.caja.util.Charsets;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.Name;
import com.google.caja.util.Pair;
import com.google.caja.util.Sets;
import com.google.caja.util.Strings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssPropertyPatterns {
    private final CssSchema schema;
    public static Set<Name> HISTORY_INSENSITIVE_STYLE_WHITELIST = Sets.immutableSet(Name.css("display"), Name.css("filter"), Name.css("float"), Name.css("height"), Name.css("left"), Name.css("opacity"), Name.css("overflow"), Name.css("position"), Name.css("right"), Name.css("top"), Name.css("visibility"), Name.css("width"), Name.css("padding-left"), Name.css("padding-right"), Name.css("padding-top"), Name.css("padding-bottom"));
    private static final JSRE SPACES = JSRE.many(JSRE.raw("\\s"));
    private static final JSRE OPT_SPACES = JSRE.any(JSRE.raw("\\s"));
    private final Bag<String> refsUsed = Bag.newHashBag();
    private static final Name COLOR = Name.css("color");
    private static final Name STANDARD_COLOR = Name.css("color-standard");
    private static final Map<String, JSRE> BUILTINS;

    public CssPropertyPatterns(CssSchema schema) {
        this.schema = schema;
    }

    public String cssPropertyToPattern(CssPropertySignature sig) {
        JSRE p = this.cssPropertyToJSRE(sig);
        if (p == null) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        out.append('/');
        p.optimize().render(out);
        out.append("/i");
        return out.toString();
    }

    public Pattern cssPropertyToJavaRegex(CssPropertySignature sig) {
        JSRE p = this.cssPropertyToJSRE(sig);
        if (p == null) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        p.render(out);
        return Pattern.compile("" + out, 2);
    }

    private JSRE cssPropertyToJSRE(CssPropertySignature sig) {
        JSREBuilder b = this.sigToPattern(false, sig);
        if (b == null) {
            return null;
        }
        return JSRE.cat(JSRE.raw("^"), OPT_SPACES, b.p, OPT_SPACES, JSRE.raw("$")).optimize();
    }

    private JSREBuilder sigToPattern(boolean identBefore, CssPropertySignature sig) {
        if (sig instanceof CssPropertySignature.LiteralSignature) {
            return CssPropertyPatterns.litToPattern(identBefore, (CssPropertySignature.LiteralSignature)sig);
        }
        if (sig instanceof CssPropertySignature.RepeatedSignature) {
            return this.repToPattern(identBefore, (CssPropertySignature.RepeatedSignature)sig);
        }
        if (sig instanceof CssPropertySignature.PropertyRefSignature) {
            return this.refToPattern(identBefore, (CssPropertySignature.PropertyRefSignature)sig);
        }
        if (sig instanceof CssPropertySignature.SeriesSignature) {
            return this.seriesToPattern(identBefore, (CssPropertySignature.SeriesSignature)sig);
        }
        if (sig instanceof CssPropertySignature.SymbolSignature) {
            return this.symbolToPattern(identBefore, (CssPropertySignature.SymbolSignature)sig);
        }
        if (sig instanceof CssPropertySignature.SetSignature || sig instanceof CssPropertySignature.ExclusiveSetSignature) {
            return this.setToPattern(identBefore, sig);
        }
        if (sig instanceof CssPropertySignature.CallSignature) {
            return this.callToPattern(identBefore, (CssPropertySignature.CallSignature)sig);
        }
        return null;
    }

    private static JSREBuilder litToPattern(boolean identBefore, CssPropertySignature.LiteralSignature lit) {
        String litValue = lit.getValue();
        boolean ident = CssPropertyPatterns.isIdentChar(litValue.charAt(litValue.length() - 1));
        JSRE p = JSRE.lit(litValue);
        return new JSREBuilder(ident, JSRE.cat(ident && identBefore ? SPACES : OPT_SPACES, p));
    }

    private static boolean isIdentChar(char ch) {
        return CssLexer.isNmStart(ch) || '0' <= ch && ch <= '9' || ch == '#' || ch == '.';
    }

    private JSREBuilder repToPattern(boolean identBefore, CssPropertySignature.RepeatedSignature sig) {
        CssPropertySignature rep = sig.getRepeatedSignature();
        if (rep instanceof CssPropertySignature.ExclusiveSetSignature) {
            return this.exclusiveToPattern(identBefore, rep);
        }
        JSREBuilder repeatedPattern = this.sigToPattern(identBefore, rep);
        if (repeatedPattern == null) {
            return null;
        }
        int min = sig.minCount;
        int max = sig.maxCount;
        if (repeatedPattern.identBefore == identBefore || max == 1) {
            return new JSREBuilder(repeatedPattern.identBefore, JSRE.rep(repeatedPattern.p, min, max));
        }
        JSREBuilder tail = this.sigToPattern(repeatedPattern.identBefore, rep);
        if (min == 0) {
            if (max != Integer.MAX_VALUE) {
                --max;
            }
            return new JSREBuilder(tail.identBefore, JSRE.opt(JSRE.cat(repeatedPattern.p, JSRE.rep(tail.p, 0, max))));
        }
        return new JSREBuilder(tail.identBefore, JSRE.cat(repeatedPattern.p, JSRE.rep(tail.p, min - 1, max)));
    }

    private JSREBuilder refToPattern(boolean identBefore, CssPropertySignature.PropertyRefSignature sig) {
        this.refsUsed.incr(sig.getPropertyName().getCanonicalForm());
        CssSchema.CssPropertyInfo p = this.schema.getCssProperty(sig.getPropertyName());
        return p != null ? this.sigToPattern(identBefore, p.sig) : null;
    }

    private JSREBuilder seriesToPattern(boolean identBefore, CssPropertySignature.SeriesSignature sig) {
        List<JSRE> children = Lists.newArrayList();
        for (CssPropertySignature cssPropertySignature : sig.children()) {
            JSREBuilder b = this.sigToPattern(identBefore, cssPropertySignature);
            if (b == null) {
                return null;
            }
            children.add(b.p);
            identBefore = b.identBefore;
        }
        return new JSREBuilder(identBefore, JSRE.cat(children));
    }

    private JSREBuilder symbolToPattern(boolean identBefore, CssPropertySignature.SymbolSignature sig) {
        CssSchema.SymbolInfo standard;
        Name symbolName = sig.getValue();
        this.refsUsed.incr(symbolName.getCanonicalForm());
        JSRE builtinMatch = this.builtinToPattern(symbolName);
        if (builtinMatch != null) {
            String re = builtinMatch.toString();
            boolean ident = CssPropertyPatterns.isIdentChar(re.charAt(0));
            boolean identAfter = CssPropertyPatterns.isIdentChar(re.charAt(re.length() - 1));
            return new JSREBuilder(identAfter, JSRE.cat(identBefore && ident ? SPACES : OPT_SPACES, builtinMatch));
        }
        CssSchema.SymbolInfo s = this.schema.getSymbol(symbolName);
        if (COLOR.equals(symbolName) && (standard = this.schema.getSymbol(STANDARD_COLOR)) != null) {
            s = standard;
        }
        return s != null ? this.sigToPattern(identBefore, s.sig) : null;
    }

    private JSREBuilder setToPattern(boolean identBefore, CssPropertySignature sig) {
        if (sig.children().isEmpty()) {
            return null;
        }
        List<JSRE> children = Lists.newArrayList();
        boolean identAfter = false;
        for (CssPropertySignature cssPropertySignature : sig.children()) {
            JSREBuilder b = this.sigToPattern(identBefore, cssPropertySignature);
            if (b == null) continue;
            children.add(b.p);
            identAfter |= b.identBefore;
        }
        if (children.isEmpty()) {
            return null;
        }
        return new JSREBuilder(identAfter, JSRE.alt(children));
    }

    private JSREBuilder callToPattern(boolean identBefore, CssPropertySignature.CallSignature sig) {
        Iterator<? extends CssPropertySignature> sigs = sig.children().iterator();
        List<JSRE> children = Lists.newArrayList();
        JSREBuilder fnPattern = this.sigToPattern(identBefore, sigs.next());
        if (fnPattern == null) {
            return null;
        }
        children.add(fnPattern.p);
        children.add(JSRE.lit("("));
        boolean first = true;
        while (sigs.hasNext()) {
            if (first) {
                first = false;
            } else {
                children.add(JSRE.lit(","));
            }
            JSREBuilder actual = this.sigToPattern(false, sigs.next());
            if (actual == null) {
                return null;
            }
            children.add(actual.p);
        }
        children.add(JSRE.lit(")"));
        return new JSREBuilder(false, JSRE.cat(children));
    }

    private JSREBuilder exclusiveToPattern(boolean identBefore, CssPropertySignature sig) {
        boolean bl;
        if (sig.children().isEmpty()) {
            return null;
        }
        List<JSRE> head = Lists.newArrayList();
        boolean identAfterHead = false;
        for (CssPropertySignature cssPropertySignature : sig.children()) {
            JSREBuilder b = this.sigToPattern(identBefore, cssPropertySignature);
            if (b == null) continue;
            head.add(b.p);
            identAfterHead = b.identBefore;
        }
        List<JSRE> tail = Lists.newArrayList();
        boolean bl2 = false;
        for (CssPropertySignature cssPropertySignature : sig.children()) {
            JSREBuilder b = this.sigToPattern(identAfterHead, cssPropertySignature);
            if (b == null) continue;
            tail.add(b.p);
            bl = b.identBefore;
        }
        if (tail.isEmpty()) {
            return null;
        }
        return new JSREBuilder(bl, JSRE.cat(JSRE.alt(head), JSRE.rep(JSRE.alt(tail), 0, tail.size() - 1)));
    }

    private JSRE builtinToPattern(Name name) {
        int comma;
        String key = name.getCanonicalForm();
        JSRE p = BUILTINS.get(key);
        if (p == null && (comma = key.lastIndexOf(58)) >= 0) {
            p = BUILTINS.get(key.substring(0, comma));
        }
        return p;
    }

    public static void generatePatterns(CssSchema schema, Appendable out) throws IOException {
        FilePosition unk = FilePosition.UNKNOWN;
        CssPropertyPatterns pp = new CssPropertyPatterns(schema);
        List<CssSchema.CssPropertyInfo> props = Lists.newArrayList(schema.getCssProperties());
        Collections.sort(props, new Comparator<CssSchema.CssPropertyInfo>(){

            @Override
            public int compare(CssSchema.CssPropertyInfo a, CssSchema.CssPropertyInfo b) {
                return a.name.compareTo(b.name);
            }
        });
        Set<String> commonSubstrings = Sets.newLinkedHashSet();
        commonSubstrings.add("|left|center|right");
        commonSubstrings.add("|top|center|bottom");
        for (Name commonSymbol : new Name[]{COLOR, Name.css("length"), Name.css("length:0,"), Name.css("border-style"), Name.css("border-width"), Name.css("bg-position"), Name.css("bg-size"), Name.css("percentage"), Name.css("percentage:0,"), Name.css("uri"), Name.css("repeat-style")}) {
            CssPropertySignature.SymbolSignature sig = (CssPropertySignature.SymbolSignature)CssPropertySignature.Parser.parseSignature("<" + commonSymbol + ">");
            JSREBuilder p = pp.symbolToPattern(false, sig);
            if (p == null) continue;
            commonSubstrings.add("" + CssPropertyPatterns.withoutSpacesOrZero(p.p.optimize()));
        }
        Map<String, int[]> regexPoolMap = Maps.newHashMap();
        Map<String, Integer> commonSubstringMap = Maps.newLinkedHashMap();
        List<Pair<CssSchema.CssPropertyInfo, String>> patterns = Lists.newArrayList();
        List<StringLiteral> stringPool = Lists.newArrayList();
        List<Expression> regexPool = Lists.newArrayList();
        for (CssSchema.CssPropertyInfo cssPropertyInfo : props) {
            String pattern = pp.cssPropertyToPattern(cssPropertyInfo.sig);
            if (!schema.isPropertyAllowed(cssPropertyInfo.name) || pattern == null || "(?:inherit\\s)".equals(pattern)) continue;
            patterns.add(Pair.pair(cssPropertyInfo, pattern));
        }
        for (String string : commonSubstrings) {
            int n = 0;
            for (Pair pair : patterns) {
                String pattern = (String)pair.b;
                int index = -1;
                while ((index = pattern.indexOf(string, index + 1)) >= 0) {
                    ++n;
                }
            }
            if (n <= true) continue;
            int poolIndx = stringPool.size();
            stringPool.add(StringLiteral.valueOf(unk, string));
            commonSubstringMap.put(string, poolIndx);
        }
        for (Pair pair : patterns) {
            String pattern = (String)pair.b;
            int[] pool = (int[])regexPoolMap.get(pattern);
            if (pool == null) {
                regexPoolMap.put(pattern, new int[]{-1});
                continue;
            }
            if (pool[0] != -1) continue;
            pool[0] = regexPool.size();
            regexPool.add(CssPropertyPatterns.makeRegexp(commonSubstringMap, pattern));
        }
        Declaration poolDecls = null;
        if (!stringPool.isEmpty()) {
            poolDecls = new Declaration(unk, new Identifier(unk, "s"), new ArrayConstructor(unk, stringPool));
        }
        if (!regexPool.isEmpty()) {
            Declaration declaration = new Declaration(unk, new Identifier(unk, "c"), new ArrayConstructor(unk, regexPool));
            poolDecls = poolDecls == null ? declaration : new MultiDeclaration(unk, Arrays.asList(poolDecls, declaration));
        }
        List<ValueProperty> list = Lists.newArrayList();
        List<ValueProperty> alternates = Lists.newArrayList();
        for (Pair pair : patterns) {
            int poolIndex = ((int[])regexPoolMap.get(pair.b))[0];
            Expression re = poolIndex < 0 ? CssPropertyPatterns.makeRegexp(commonSubstringMap, (String)pair.b) : (Expression)QuasiBuilder.substV("c[@i]", "i", new IntegerLiteral(unk, poolIndex));
            StringLiteral name = StringLiteral.valueOf(unk, ((CssSchema.CssPropertyInfo)pair.a).name.getCanonicalForm());
            list.add(new ValueProperty(name, re));
            String dom2property = CssPropertyPatterns.propertyNameToDom2Property(((CssSchema.CssPropertyInfo)pair.a).name);
            AbstractParseTreeNode altNames = null;
            for (String altDom2Property : ((CssSchema.CssPropertyInfo)pair.a).dom2properties) {
                if (altDom2Property.equals(dom2property)) continue;
                if (altNames == null) {
                    altNames = new ArrayConstructor(unk, Collections.emptyList());
                    alternates.add(new ValueProperty(StringLiteral.valueOf(unk, dom2property), (Expression)((Object)altNames)));
                }
                altNames.appendChild(StringLiteral.valueOf(unk, altDom2Property));
            }
        }
        List<ValueProperty> historyInsensitiveStyleWhitelistEls = Lists.newArrayList();
        for (Name propertyName : HISTORY_INSENSITIVE_STYLE_WHITELIST) {
            historyInsensitiveStyleWhitelistEls.add(new ValueProperty(StringLiteral.valueOf(unk, propertyName.getCanonicalForm()), new BooleanLiteral(unk, true)));
        }
        ObjectConstructor objectConstructor = new ObjectConstructor(unk, list);
        ObjectConstructor alternateNames = new ObjectConstructor(unk, alternates);
        ObjectConstructor historyInsensitiveStyleWhitelist = new ObjectConstructor(unk, historyInsensitiveStyleWhitelistEls);
        ParseTreeNode js = QuasiBuilder.substV("var css = {  properties: (function () {    @poolDecls?;    return @cssPropConstructor;  })(),  alternates: @alternates,  HISTORY_INSENSITIVE_STYLE_WHITELIST:       @historyInsensitiveStyleWhitelist};", "poolDecls", poolDecls, "cssPropConstructor", objectConstructor, "alternates", alternateNames, "historyInsensitiveStyleWhitelist", historyInsensitiveStyleWhitelist);
        TokenConsumer tc = js.makeRenderer(out, null);
        js.render(new RenderContext(tc));
        tc.noMoreTokens();
        out.append("\n");
    }

    private static Expression makeRegexp(Map<String, Integer> commonSubstrings, String regex) {
        FilePosition unk = FilePosition.UNKNOWN;
        List<Pair<String, Expression>> substrings = Lists.newArrayList();
        for (Map.Entry<String, Integer> e : commonSubstrings.entrySet()) {
            substrings.add(Pair.pair(e.getKey(), (Expression)QuasiBuilder.substV("s[@i]", "i", new IntegerLiteral(unk, e.getValue().intValue()))));
        }
        List<Expression> parts = Lists.newArrayList();
        assert (regex.startsWith("/") && regex.endsWith("/i"));
        String pattern = regex.substring(1, regex.length() - 2);
        CssPropertyPatterns.makeRegexpOnto(substrings, pattern, 0, parts);
        if (parts.size() == 1 && parts.get(0) instanceof StringLiteral) {
            return new RegexpLiteral(unk, regex);
        }
        Expression e = parts.get(0);
        int n = parts.size();
        for (int i = 1; i < n; ++i) {
            e = Operation.createInfix(Operator.ADDITION, e, parts.get(i));
        }
        return (Expression)QuasiBuilder.substV("RegExp(@pattern, 'i')", "pattern", e);
    }

    private static void makeRegexpOnto(List<Pair<String, Expression>> strs, String pattern, int index, List<Expression> parts) {
        if ("".equals(pattern)) {
            return;
        }
        int n = strs.size();
        while (index < n) {
            Pair<String, Expression> commonString = strs.get(index);
            String s = (String)commonString.a;
            int pos = pattern.indexOf(s);
            if (pos >= 0) {
                CssPropertyPatterns.makeRegexpOnto(strs, pattern.substring(0, pos), index + 1, parts);
                parts.add((Expression)commonString.b);
                CssPropertyPatterns.makeRegexpOnto(strs, pattern.substring(pos + s.length()), index, parts);
                return;
            }
            ++index;
        }
        parts.add(StringLiteral.valueOf(FilePosition.UNKNOWN, pattern));
    }

    private static JSRE withoutSpacesOrZero(JSRE p) {
        if (p instanceof JSRE.Atom) {
            String s = ((JSRE.Atom)p).atom;
            return "0".equals(s) || "\\s".equals(s) ? null : p;
        }
        if (p instanceof JSRE.Concatenation) {
            JSRE.Concatenation c = (JSRE.Concatenation)p;
            List<JSRE> children = Lists.newArrayList(c.children);
            while (!children.isEmpty()) {
                JSRE p0 = children.get(0);
                JSRE p0w = CssPropertyPatterns.withoutSpacesOrZero(p0);
                if (p0w == null) {
                    children.remove(0);
                    continue;
                }
                children.set(0, p0w);
                break;
            }
            if (children.isEmpty()) {
                return null;
            }
            return JSRE.cat(children).optimize();
        }
        if (p instanceof JSRE.Alternation) {
            List<JSRE> children = ((JSRE.Alternation)p).children;
            List<JSRE> childrenNew = Lists.newArrayList();
            for (JSRE child : children) {
                JSRE wo = CssPropertyPatterns.withoutSpacesOrZero(child);
                if (wo == null) continue;
                childrenNew.add(wo);
            }
            if (childrenNew.isEmpty()) {
                return null;
            }
            return JSRE.alt(childrenNew);
        }
        if (p instanceof JSRE.Repetition) {
            JSRE.Repetition rep = (JSRE.Repetition)p;
            JSRE body = CssPropertyPatterns.withoutSpacesOrZero(rep.body);
            return body != null ? JSRE.rep(body, rep.min, rep.max).optimize() : null;
        }
        return p;
    }

    static String propertyNameToDom2Property(Name cssPropertyName) {
        String lcaseDashed = cssPropertyName.getCanonicalForm();
        int dash = lcaseDashed.indexOf(45);
        if (dash < 0) {
            return lcaseDashed;
        }
        StringBuilder sb = new StringBuilder(lcaseDashed.length());
        int written = 0;
        do {
            sb.append(lcaseDashed, written, dash);
            written = dash + 1;
            if (written >= lcaseDashed.length()) continue;
            sb.append(Strings.toUpperCase(lcaseDashed.substring(written, written + 1)));
            ++written;
        } while ((dash = lcaseDashed.indexOf(45, written)) >= 0);
        sb.append(lcaseDashed, written, lcaseDashed.length());
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        CssSchema schema = CssSchema.getDefaultCss21Schema(new SimpleMessageQueue());
        CssPropertyPatterns.generatePatterns(schema, System.out);
    }

    static {
        JSRE zero = JSRE.lit("0");
        JSRE one = JSRE.lit("1");
        JSRE digit = JSRE.raw("\\d");
        JSRE digits = JSRE.many(digit);
        JSRE dot = JSRE.raw("\\.");
        JSRE fraction = JSRE.cat(dot, digits);
        JSRE pct = JSRE.lit("%");
        JSRE minus = JSRE.lit("-");
        JSRE sign = JSRE.alt(JSRE.lit("+"), minus);
        JSRE unsignedNum = JSRE.cat(digits, JSRE.opt(fraction));
        JSRE signedNum = JSRE.cat(JSRE.opt(sign), unsignedNum);
        JSRE angleUnits = JSRE.alt(JSRE.alt(JSRE.lit("rad"), JSRE.lit("grad")), JSRE.lit("deg"));
        JSRE freqUnits = JSRE.alt(JSRE.lit("Hz"), JSRE.lit("kHz"));
        JSRE lengthUnits = JSRE.alt(JSRE.alt(JSRE.lit("cm"), JSRE.lit("mm"), JSRE.lit("em")), JSRE.lit("ex"), JSRE.lit("in"), JSRE.alt(JSRE.lit("pc"), JSRE.lit("pt"), JSRE.lit("px")));
        JSRE timeUnits = JSRE.alt(JSRE.lit("ms"), JSRE.lit("s"));
        JSRE quotedIdentifiers = JSRE.raw("\"\\w(?:[\\w-]*\\w)(?:\\s+\\w([\\w-]*\\w))*\"");
        JSRE hash = JSRE.lit("#");
        JSRE hex = JSRE.alt(digit, JSRE.lit("a"), JSRE.lit("b"), JSRE.lit("c"), JSRE.lit("d"), JSRE.lit("e"), JSRE.lit("f"));
        BUILTINS = Maps.immutableMap().put("number:0,", JSRE.alt(zero, unsignedNum).optimize()).put("number:0,1", JSRE.alt(JSRE.cat(zero, JSRE.opt(fraction)), fraction, JSRE.cat(one, JSRE.opt(JSRE.cat(dot, JSRE.many(zero))))).optimize()).put("number", JSRE.alt(zero, signedNum).optimize()).put("percentage:0,", JSRE.alt(zero, JSRE.cat(unsignedNum, pct)).optimize()).put("percentage", JSRE.alt(zero, JSRE.cat(signedNum, pct)).optimize()).put("angle:0", JSRE.alt(zero, JSRE.cat(unsignedNum, angleUnits))).put("angle", JSRE.alt(zero, JSRE.cat(signedNum, angleUnits))).put("frequency", JSRE.alt(zero, JSRE.cat(unsignedNum, freqUnits))).put("length:0,", JSRE.alt(zero, JSRE.cat(unsignedNum, lengthUnits))).put("length", JSRE.alt(zero, JSRE.cat(signedNum, lengthUnits))).put("time:0,", JSRE.alt(zero, JSRE.cat(unsignedNum, timeUnits))).put("time", JSRE.alt(zero, JSRE.cat(signedNum, timeUnits))).put("integer", JSRE.cat(JSRE.opt(minus), digits)).put("integer:0,", digits).put("hex-color", JSRE.cat(hash, JSRE.rep(JSRE.rep(hex, 3, 3), 1, 2))).put("specific-voice", quotedIdentifiers).put("family-name", quotedIdentifiers).put("uri", JSRE.cat(JSRE.lit("url(\""), JSRE.many(JSRE.raw("[^()\\\\\"\\r\\n]")), JSRE.lit("\")"))).create();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements BuildCommand {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean build(List<File> inputs, List<File> deps, Map<String, Object> options, File output) throws IOException {
            CssSchema schema;
            File symbolsAndPropertiesFile = null;
            File functionsFile = null;
            for (File input : inputs) {
                if (!input.getName().endsWith(".json")) continue;
                if (symbolsAndPropertiesFile == null) {
                    symbolsAndPropertiesFile = input;
                    continue;
                }
                if (functionsFile == null) {
                    functionsFile = input;
                    continue;
                }
                throw new IOException("Unused input " + input);
            }
            if (symbolsAndPropertiesFile == null) {
                throw new IOException("No JSON whitelist for CSS Symbols + Properties");
            }
            if (functionsFile == null) {
                throw new IOException("No JSON whitelist for CSS Functions");
            }
            FilePosition sps = FilePosition.startOfFile(new InputSource(symbolsAndPropertiesFile.getAbsoluteFile().toURI()));
            FilePosition fns = FilePosition.startOfFile(new InputSource(functionsFile.getAbsoluteFile().toURI()));
            MessageContext mc = new MessageContext();
            mc.addInputSource(sps.source());
            mc.addInputSource(fns.source());
            EchoingMessageQueue mq = new EchoingMessageQueue(new PrintWriter((Writer)new OutputStreamWriter(System.err), true), mc, false);
            Set<File> inputsAndDeps = Sets.newHashSet();
            for (File f : inputs) {
                inputsAndDeps.add(f.getAbsoluteFile());
            }
            for (File f : deps) {
                inputsAndDeps.add(f.getAbsoluteFile());
            }
            AllowedFileResolver resolver = new AllowedFileResolver(inputsAndDeps);
            try {
                schema = new CssSchema(ConfigUtil.loadWhiteListFromJson(sps.source().getUri(), resolver, mq), ConfigUtil.loadWhiteListFromJson(fns.source().getUri(), resolver, mq));
            }
            catch (ParseException ex) {
                ex.toMessageQueue(mq);
                throw (IOException)new IOException("Failed to parse schema").initCause(ex);
            }
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(output), Charsets.UTF_8.name());
            String currentDate = "" + new Date();
            if (currentDate.indexOf("*/") >= 0) {
                throw new SomethingWidgyHappenedError("Date should not contain '*/'");
            }
            out.write("/* Copyright Google Inc.\n");
            out.write(" * Licensed under the Apache Licence Version 2.0\n");
            out.write(" * Autogenerated at " + currentDate + "\n");
            out.write(" * @provides css\n");
            out.write(" */\n");
            try {
                CssPropertyPatterns.generatePatterns(schema, out);
            }
            finally {
                ((Writer)out).close();
            }
            return true;
        }
    }

    private static class JSREBuilder {
        final JSRE p;
        final boolean identBefore;

        JSREBuilder(boolean identBefore, JSRE p) {
            this.identBefore = identBefore;
            this.p = p;
        }
    }
}

